/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.info;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.povstalec.sgjourney.common.sgjourney.Address;

public class AddressFilterInfo {
    public static final String FILTER_TYPE = "filter_type";
    public static final String WHITELIST = "whitelist";
    public static final String BLACKLIST = "blacklist";
    private FilterType filterType = FilterType.NONE;
    private ArrayList<HiddenAddress> whitelist = new ArrayList();
    private ArrayList<HiddenAddress> blacklist = new ArrayList();

    public void deserializeFilters(CompoundTag tag) {
        if (tag.contains(FILTER_TYPE)) {
            this.filterType = FilterType.getFilterType(tag.getInt(FILTER_TYPE));
        }
        if (tag.contains(WHITELIST)) {
            CompoundTag whitelistTag = tag.getCompound(WHITELIST);
            for (String addressString : whitelistTag.getAllKeys()) {
                this.whitelist.add(new HiddenAddress(new Address.Immutable(addressString), whitelistTag.getBoolean(addressString)));
            }
        }
        if (tag.contains(BLACKLIST)) {
            CompoundTag blacklistTag = tag.getCompound(BLACKLIST);
            for (String addressString : blacklistTag.getAllKeys()) {
                this.blacklist.add(new HiddenAddress(new Address.Immutable(addressString), blacklistTag.getBoolean(addressString)));
            }
        }
    }

    public void serializeFilters(CompoundTag tag) {
        tag.putInt(FILTER_TYPE, this.filterType.getIntegerValue());
        CompoundTag whitelistTag = new CompoundTag();
        CompoundTag blacklistTag = new CompoundTag();
        for (HiddenAddress hiddenAddress : this.whitelist) {
            whitelistTag.putBoolean(hiddenAddress.address().toString(), hiddenAddress.isVisible());
        }
        for (HiddenAddress hiddenAddress : this.blacklist) {
            blacklistTag.putBoolean(hiddenAddress.address().toString(), hiddenAddress.isVisible());
        }
        tag.put(WHITELIST, (Tag)whitelistTag);
        tag.put(BLACKLIST, (Tag)blacklistTag);
    }

    public FilterType setFilterType(int integerValue) {
        this.filterType = FilterType.getFilterType(integerValue);
        return this.filterType;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public boolean isAddressWhitelisted(Address address) {
        return this.whitelist.contains(address);
    }

    public boolean addToWhitelist(Address.Immutable address, boolean isVisible) {
        if (this.whitelist.contains(address)) {
            for (HiddenAddress hiddenAddress : this.whitelist) {
                if (!hiddenAddress.address().equals(address)) continue;
                hiddenAddress.isVisible = isVisible;
                break;
            }
            return false;
        }
        this.whitelist.add(new HiddenAddress(address, isVisible));
        return true;
    }

    public boolean removeFromWhitelist(Address address) {
        if (!this.whitelist.contains(address)) {
            return false;
        }
        this.whitelist.remove(address);
        return true;
    }

    public List<HiddenAddress> getWhitelist() {
        return this.whitelist;
    }

    public void clearWhitelist() {
        this.whitelist.clear();
    }

    public boolean isAddressBlacklisted(Address address) {
        return this.blacklist.contains(address);
    }

    public boolean addToBlacklist(Address address, boolean isVisible) {
        if (this.blacklist.contains(address)) {
            for (HiddenAddress hiddenAddress : this.blacklist) {
                if (!hiddenAddress.address().equals(address)) continue;
                hiddenAddress.isVisible = isVisible;
                break;
            }
            return false;
        }
        this.blacklist.add(new HiddenAddress(address, isVisible));
        return true;
    }

    public boolean removeFromBlacklist(Address.Immutable address) {
        if (!this.blacklist.contains(address)) {
            return false;
        }
        this.blacklist.remove(address);
        return true;
    }

    public List<HiddenAddress> getBlacklist() {
        return this.blacklist;
    }

    public void clearBlacklist() {
        this.blacklist.clear();
    }

    public static enum FilterType {
        NONE(0),
        WHITELIST(1),
        BLACKLIST(-1);

        private int integerValue;

        private FilterType(int integerValue) {
            this.integerValue = integerValue;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public boolean shouldFilter() {
            return this != NONE;
        }

        public boolean isWhitelist() {
            return this == WHITELIST;
        }

        public boolean isBlacklist() {
            return this == BLACKLIST;
        }

        public static FilterType getFilterType(int integerValue) {
            switch (integerValue) {
                case 1: {
                    return WHITELIST;
                }
                case -1: {
                    return BLACKLIST;
                }
            }
            return NONE;
        }
    }

    public static class HiddenAddress {
        private Address.Immutable address;
        private boolean isVisible;

        public HiddenAddress(Address address, boolean isVisible) {
            this.address = new Address.Immutable(address);
            this.isVisible = isVisible;
        }

        public Address.Immutable address() {
            return this.address;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public boolean equals(Object object) {
            return this.address.equals(object);
        }
    }

    public static interface Interface {
        public AddressFilterInfo addressFilterInfo();
    }
}

