/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.povstalec.sgjourney.client.models.block_entity.AbstractStargateModel;
import net.povstalec.sgjourney.client.models.block_entity.SGJourneyModel;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.TollanStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TollanStargateModel
extends AbstractStargateModel<TollanStargateEntity, TollanStargateVariant> {
    protected static final float TOLLAN_RADIUS = 3.0f;
    protected static final float TOLLAN_RING_HEIGHT = 0.5f;
    protected static final float STARGATE_RING_THICKNESS = 3.0f;
    protected static final float STARGATE_RING_OFFSET = 0.09375f;
    protected static final float STARGATE_RING_OUTER_RADIUS = 2.999f;
    protected static final float STARGATE_RING_OUTER_LENGTH = SGJourneyModel.getUsedWidth(36, 2.999f, 3.5f);
    protected static final float STARGATE_RING_OUTER_CENTER = STARGATE_RING_OUTER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_INNER_RADIUS = 2.501f;
    protected static final float STARGATE_RING_INNER_LENGTH = SGJourneyModel.getUsedWidth(36, 2.501f, 3.5f);
    protected static final float STARGATE_RING_INNER_CENTER = STARGATE_RING_INNER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_HEIGHT = 0.49800014f;
    protected static final float CHEVRON_OFFSET = 0.0625f;
    protected static final float CHEVRON_THICKNESS = 0.3125f;
    protected static final float CHEVRON_WIDTH = 0.3125f;
    protected static final float CHEVRON_HEIGHT = 0.5625f;

    public TollanStargateModel() {
        super((short)0);
    }

    @Override
    public void renderRing(TollanStargateEntity stargate, TollanStargateVariant stargateVariant, float partialTick, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderOuterRing(stack, consumer, source, combinedLight);
    }

    @Override
    protected void renderPrimaryChevron(TollanStargateEntity stargate, TollanStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean chevronEngaged) {
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        stack.m_85836_();
        stack.m_252880_(0.0f, 2.501f, 0.0f);
        this.renderChevronLight(stack, consumer, source, light, chevronEngaged);
        stack.m_85849_();
    }

    @Override
    protected void renderChevron(TollanStargateEntity stargate, TollanStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int chevronNumber, boolean chevronEngaged) {
        int chevron = AbstractStargateEntity.getChevron(stargate, chevronNumber);
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(-40.0f * (float)chevron));
        stack.m_252880_(0.0f, 2.501f, 0.0f);
        this.renderChevronLight(stack, consumer, source, light, chevronEngaged);
        stack.m_85849_();
    }

    protected void renderChevronLight(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean isEngaged) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.15625f, 0.5625f, -0.15625f, 0.765625f, 0.0f, -0.15625f, 0.5625f, 0.15625f, 0.765625f, 0.078125f, 0.15625f, 0.5625f, 0.15625f, 0.84375f, 0.078125f, 0.15625f, 0.5625f, -0.15625f, 0.84375f, 0.0f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.15625f, 0.5625f, 0.15625f, 0.765625f, 0.078125f, -0.15625f, 0.0f, 0.15625f, 0.765625f, 0.21875f, 0.15625f, 0.0f, 0.15625f, 0.84375f, 0.21875f, 0.15625f, 0.5625f, 0.15625f, 0.84375f, 0.078125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 0.0f, 0.0f, -0.15625f, 0.5625f, -0.15625f, 0.6875f, 0.078125f, -0.15625f, 0.0f, -0.15625f, 0.6875f, 0.21875f, -0.15625f, 0.0f, 0.15625f, 0.765625f, 0.21875f, -0.15625f, 0.5625f, 0.15625f, 0.765625f, 0.078125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 0.0f, 0.0f, 0.15625f, 0.5625f, 0.15625f, 0.84375f, 0.078125f, 0.15625f, 0.0f, 0.15625f, 0.84375f, 0.21875f, 0.15625f, 0.0f, -0.15625f, 0.921875f, 0.21875f, 0.15625f, 0.5625f, -0.15625f, 0.921875f, 0.078125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, 0.15625f, 0.5625f, -0.15625f, 0.921875f, 0.078125f, 0.15625f, 0.0f, -0.15625f, 0.921875f, 0.21875f, -0.15625f, 0.0f, -0.15625f, 1.0f, 0.21875f, -0.15625f, 0.5625f, -0.15625f, 1.0f, 0.078125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -0.15625f, 0.0f, 0.15625f, 0.84375f, 0.0f, -0.15625f, 0.0f, 0.09375f, 0.84375f, 0.015625f, 0.15625f, 0.0f, 0.09375f, 0.921875f, 0.015625f, 0.15625f, 0.0f, 0.15625f, 0.921875f, 0.0f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -0.15625f, 0.0f, -0.09375f, 0.84375f, 0.0625f, -0.15625f, 0.0f, -0.15625f, 0.84375f, 0.078125f, 0.15625f, 0.0f, -0.15625f, 0.921875f, 0.078125f, 0.15625f, 0.0f, -0.09375f, 0.921875f, 0.0625f);
    }

    protected void renderOuterRing(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        for (int j = 0; j < 36; ++j) {
            stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -STARGATE_RING_OUTER_CENTER, 2.999f, 0.09375f, (4.5f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.047124982f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.09375f, (4.5f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.17162502f, STARGATE_RING_INNER_CENTER, 2.501f, 0.09375f, (4.5f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.17162502f, STARGATE_RING_OUTER_CENTER, 2.999f, 0.09375f, (4.5f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.047124982f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, STARGATE_RING_OUTER_CENTER, 2.999f, -0.09375f, (12.5f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.047124982f, STARGATE_RING_INNER_CENTER, 2.501f, -0.09375f, (12.5f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.17162502f, -STARGATE_RING_INNER_CENTER, 2.501f, -0.09375f, (12.5f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.17162502f, -STARGATE_RING_OUTER_CENTER, 2.999f, -0.09375f, (12.5f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.047124982f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 2.999f, -0.09375f, (4.5f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 2.999f, 0.09375f, (4.5f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.046875f, STARGATE_RING_OUTER_CENTER, 2.999f, 0.09375f, (4.5f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.046875f, STARGATE_RING_OUTER_CENTER, 2.999f, -0.09375f, (4.5f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, STARGATE_RING_INNER_CENTER, 2.501f, -0.09375f, (12.5f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.0f, STARGATE_RING_INNER_CENTER, 2.501f, 0.09375f, (12.5f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.046875f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.09375f, (12.5f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.046875f, -STARGATE_RING_INNER_CENTER, 2.501f, -0.09375f, (12.5f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.0f);
        }
    }
}

