/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.io.Serializable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.info.IrisInfo;

public abstract class IrisStargateEntity
extends AbstractStargateEntity
implements IrisInfo.Interface {
    protected IrisInfo irisInfo = new IrisInfo(this);

    public IrisStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight) {
        super(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, verticalCenterHeight, horizontalCenterHeight);
    }

    public IrisStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork) {
        this(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, 0.5f, 0.28125f);
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        super.deserializeStargateInfo(tag, isUpgraded);
        short irisProgress = tag.m_128448_("IrisProgress");
        this.irisInfo().setIrisProgress(irisProgress, irisProgress);
        this.irisInfo().deserializeIrisInventory(tag.m_128469_("IrisInventory"));
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag) {
        super.serializeStargateInfo(tag);
        tag.m_128376_("IrisProgress", this.irisInfo().getIrisProgress());
        tag.m_128365_("IrisInventory", (Tag)this.irisInfo().serializeIrisInventory());
        return tag;
    }

    @Override
    public IrisInfo irisInfo() {
        return this.irisInfo;
    }

    @Override
    public void doKawoosh() {
        if (!this.irisInfo().isIrisClosed()) {
            super.doKawoosh();
        }
    }

    @Override
    public void setStargateState(boolean updateInterfaces) {
        this.setStargateState(updateInterfaces, false, this.irisInfo().getShieldingState());
        this.updateClientState();
    }

    @Override
    public void getStatus(Player player) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.iris").m_7220_((Component)Component.m_237113_((String)": ").m_7220_((Component)(!this.irisInfo().getIris().m_41619_() ? this.irisInfo().getIris().m_41611_() : Component.m_237113_((String)"-")))).m_130940_(ChatFormatting.GRAY));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.iris_durability").m_7220_((Component)Component.m_237113_((String)(": " + (Serializable)(!this.irisInfo().getIris().m_41619_() ? Integer.valueOf(StargateIrisItem.getDurability(this.irisInfo().getIris())) : "-")))).m_130940_(ChatFormatting.GRAY));
        if (!this.irisInfo().getIris().m_41619_() && StargateIrisItem.hasCustomTexture(this.irisInfo().getIris())) {
            player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.iris_texture").m_7220_((Component)Component.m_237113_((String)(": " + StargateIrisItem.getIrisTexture(this.irisInfo().getIris())))).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        super.getStatus(player);
    }

    @Override
    public boolean updateClient() {
        if (this.f_58857_.m_5776_()) {
            return false;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateUpdatePacket(this.f_58858_, this.getEnergyStored(), this.openTime, this.timeSinceLastTraveler, this.address.getArray(), this.engagedChevrons, this.kawooshTick, this.animationTick, this.irisInfo().getIrisProgress(), this.symbolInfo().pointOfOrigin(), this.symbolInfo().symbols(), this.variant, this.irisInfo().getIris()));
        return true;
    }
}

