/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundBatteryBlockUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class BatteryBlockEntity
extends EnergyBlockEntity {
    public static final String INVENTORY = "inventory";
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);

    public BatteryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_(INVENTORY));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_(INVENTORY, (Tag)this.itemHandler.serializeNBT());
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.lazyItemHandler.cast();
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                BatteryBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BatteryBlockEntity battery) {
        if (level.m_5776_()) {
            return;
        }
        battery.extractItemEnergy(battery.itemHandler.getStackInSlot(0));
        battery.fillItemEnergy(battery.itemHandler.getStackInSlot(1));
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(battery.m_58899_())), (Object)new ClientboundBatteryBlockUpdatePacket(battery.m_58899_(), battery.getEnergyStored()));
    }

    public static class Naquadah
    extends BatteryBlockEntity {
        public Naquadah(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_BATTERY.get(), pos, state);
        }

        @Override
        protected long capacity() {
            return (Long)CommonTechConfig.large_naquadah_battery_capacity.get();
        }

        @Override
        protected long maxReceive() {
            return (Long)CommonTechConfig.large_naquadah_battery_max_transfer.get();
        }

        @Override
        protected long maxExtract() {
            return (Long)CommonTechConfig.large_naquadah_battery_max_transfer.get();
        }
    }
}

