/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;

public enum ShieldingPart implements StringRepresentable
{
    LEFT_ABOVE5("left_above5", 1, 5, ShieldingState.MOVING_1),
    ABOVE5("above5", 0, 5, ShieldingState.MOVING_1),
    RIGHT_ABOVE5("right_above5", -1, 5, ShieldingState.MOVING_1),
    LEFT2_ABOVE4("left2_above4", 2, 4, ShieldingState.MOVING_1),
    LEFT_ABOVE4("left_above4", 1, 4, ShieldingState.MOVING_2),
    ABOVE4("above4", 0, 4, ShieldingState.MOVING_3),
    RIGHT_ABOVE4("right_above4", -1, 4, ShieldingState.MOVING_2),
    RIGHT2_ABOVE4("right2_above4", -2, 4, ShieldingState.MOVING_1),
    LEFT2_ABOVE3("left2_above3", 2, 3, ShieldingState.MOVING_1),
    LEFT_ABOVE3("left_above3", 1, 3, ShieldingState.MOVING_3),
    ABOVE3("above3", 0, 3, ShieldingState.CLOSED),
    RIGHT_ABOVE3("right_above3", -1, 3, ShieldingState.MOVING_3),
    RIGHT2_ABOVE3("right2_above3", -2, 3, ShieldingState.MOVING_1),
    LEFT2_ABOVE2("left2_above2", 2, 2, ShieldingState.MOVING_1),
    LEFT_ABOVE2("left_above2", 1, 2, ShieldingState.MOVING_2),
    ABOVE2("above2", 0, 2, ShieldingState.MOVING_3),
    RIGHT_ABOVE2("right_above2", -1, 2, ShieldingState.MOVING_2),
    RIGHT2_ABOVE2("right2_above2", -2, 2, ShieldingState.MOVING_1),
    LEFT_ABOVE("left_above", 1, 1, ShieldingState.MOVING_1),
    ABOVE("above", 0, 1, ShieldingState.MOVING_1),
    RIGHT_ABOVE("right_above", -1, 1, ShieldingState.MOVING_1);

    public static final ArrayList<ShieldingPart> DEFAULT_PARTS;
    private final String name;
    private final int width;
    private final int height;
    private final ShieldingState requiredShieldingState;

    private ShieldingPart(String name, int width, int height, ShieldingState requiredShieldingState) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.requiredShieldingState = requiredShieldingState;
    }

    public boolean canExist(ShieldingState shieldingState) {
        return shieldingState == this.requiredShieldingState || shieldingState.isAfter(this.requiredShieldingState);
    }

    public ShieldingState shieldingState() {
        return this.requiredShieldingState;
    }

    private static ArrayList<ShieldingPart> getParts() {
        ArrayList<ShieldingPart> parts = new ArrayList<ShieldingPart>();
        parts.add(LEFT_ABOVE5);
        parts.add(ABOVE5);
        parts.add(RIGHT_ABOVE5);
        parts.add(LEFT2_ABOVE4);
        parts.add(LEFT2_ABOVE3);
        parts.add(LEFT2_ABOVE2);
        parts.add(LEFT_ABOVE);
        parts.add(ABOVE);
        parts.add(RIGHT_ABOVE);
        parts.add(RIGHT2_ABOVE2);
        parts.add(RIGHT2_ABOVE3);
        parts.add(RIGHT2_ABOVE4);
        parts.add(LEFT_ABOVE4);
        parts.add(ABOVE4);
        parts.add(RIGHT_ABOVE4);
        parts.add(LEFT_ABOVE3);
        parts.add(RIGHT_ABOVE3);
        parts.add(LEFT_ABOVE2);
        parts.add(ABOVE2);
        parts.add(RIGHT_ABOVE2);
        parts.add(ABOVE3);
        return parts;
    }

    public String toString() {
        return this.name;
    }

    public String m_7912_() {
        return this.name;
    }

    public BlockPos getBaseBlockPos(BlockPos pos, Direction direction, Orientation orientation) {
        Direction newDirection = direction.m_122428_();
        Direction centerDirection = Orientation.getCenterDirection(direction, orientation);
        return pos.m_5484_(newDirection, this.width).m_5484_(centerDirection, -this.height);
    }

    public BlockPos getShieldingPos(BlockPos pos, Direction direction, Orientation orientation) {
        Direction newDirection = direction.m_122427_();
        Direction centerDirection = Orientation.getCenterDirection(direction, orientation);
        return pos.m_5484_(newDirection, this.width).m_5484_(centerDirection, this.height);
    }

    public Vec3 getRelativeRingPos(BlockPos pos, Direction direction, Orientation orientation) {
        BlockPos ringPos = this.getShieldingPos(pos, direction, orientation);
        return new Vec3((double)(ringPos.m_123341_() - pos.m_123341_()), (double)(ringPos.m_123342_() - pos.m_123342_()), (double)(ringPos.m_123343_() - pos.m_123343_()));
    }

    static {
        DEFAULT_PARTS = ShieldingPart.getParts();
    }
}

