/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadahProvider;
import net.povstalec.sgjourney.common.entities.Goauld;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.entities.goals.EvacuateHostGoal;
import net.povstalec.sgjourney.common.entities.goals.NearestThreatGoal;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.items.GoauldItem;

public class GoauldHost {
    public static final String HOST_DATA = "host_data";
    public static final String CUSTOM_NAME = "CustomName";
    private CompoundTag hostData = null;
    private Goauld.Info goauldInfo = null;

    public boolean isHost() {
        return this.goauldInfo != null;
    }

    public boolean takeOverHost(Goauld.Info goauldInfo, Mob host) {
        if (this.goauldInfo != null || goauldInfo == null || host == null) {
            return false;
        }
        this.saveHostData(host);
        GoauldHost.addGoauldHostGoals(host);
        host.getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).ifPresent(cap -> cap.addNaquadahToBloodstream());
        if (goauldInfo.name() != null) {
            host.m_6593_(goauldInfo.name());
        }
        this.goauldInfo = goauldInfo;
        return true;
    }

    public boolean takeOverHost(Goauld goauld, Mob host) {
        if (goauld == null) {
            return false;
        }
        boolean res = this.takeOverHost(goauld.goauldInfo(), host);
        if (res) {
            goauld.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return res;
    }

    public boolean takeOverHost(ItemStack stack, Mob host) {
        if (stack == null || !(stack.m_41720_() instanceof GoauldItem)) {
            return false;
        }
        return this.takeOverHost(Goauld.Info.fromItemStack(stack), host);
    }

    public void leaveHost(Mob host) {
        if (host == null || this.goauldInfo == null) {
            return;
        }
        Goauld goauld = (Goauld)((EntityType)EntityInit.GOAULD.get()).m_20615_(host.m_9236_());
        goauld.m_7678_(host.m_20185_(), host.m_20186_(), host.m_20189_(), host.m_146908_(), 0.0f);
        goauld.setFromInfo(this.goauldInfo);
        host.m_9236_().m_7967_((Entity)goauld);
        GoauldHost.removeGoauldHostGoals(host);
        this.restoreHostData(host);
        this.goauldInfo = null;
    }

    public static void addGoauldHostGoals(Mob host) {
        host.f_21346_.m_25352_(1, new NearestThreatGoal<Player>(host, Player.class, true));
        host.f_21346_.m_25352_(2, new NearestThreatGoal<Human>(host, Human.class, true));
    }

    public static void removeGoauldHostGoals(Mob host) {
        host.f_21345_.m_262460_(goal -> goal instanceof EvacuateHostGoal || goal instanceof NearestThreatGoal);
        host.m_6598_(null);
        host.m_6703_(null);
        host.m_6710_(null);
        host.m_21561_(false);
    }

    public void saveHostData(Mob host) {
        this.hostData = new CompoundTag();
        if (host.m_7770_() != null) {
            this.hostData.m_128359_(CUSTOM_NAME, Component.Serializer.m_130703_((Component)host.m_7770_()));
        }
    }

    public void restoreHostData(Mob host) {
        if (this.hostData != null) {
            if (this.hostData.m_128425_(CUSTOM_NAME, 8)) {
                host.m_6593_((Component)Component.Serializer.m_130701_((String)this.hostData.m_128461_(CUSTOM_NAME)));
            } else {
                host.m_6593_(null);
            }
        }
        this.hostData = null;
    }

    public void copyFrom(GoauldHost source) {
        if (this.goauldInfo != null) {
            this.goauldInfo = source.goauldInfo.copy();
        }
    }

    public void saveData(CompoundTag tag) {
        if (this.goauldInfo != null) {
            tag.m_128365_("goauld_info", (Tag)this.goauldInfo.serializeNBT());
        }
        if (this.hostData != null) {
            tag.m_128365_(HOST_DATA, (Tag)this.hostData);
        }
    }

    public void loadData(CompoundTag tag) {
        if (tag.m_128425_("goauld_info", 10)) {
            this.goauldInfo = new Goauld.Info();
            this.goauldInfo.deserializeNBT(tag.m_128469_("goauld_info"));
        }
        if (tag.m_128425_(HOST_DATA, 10)) {
            this.hostData = tag.m_128469_(HOST_DATA);
        }
    }
}

