/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.povstalec.sgjourney.common.capabilities.ItemEnergy;
import net.povstalec.sgjourney.common.capabilities.ItemFluidHolderProvider;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.items.PowerCellItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemPowerCellProvider
extends ItemFluidHolderProvider {
    public static final String ENERGY_BUFFER = "energy";
    private final ItemEnergy ENERGY_STORAGE = new ItemEnergy(this.energyCapacity(), this.energyMaxTransfer(), this.energyMaxTransfer()){

        @Override
        public void reloadEnergy() {
            ItemPowerCellProvider.this.loadEnergy();
        }

        @Override
        public long getTrueEnergyStored() {
            FluidStack fluidStack = ItemPowerCellProvider.this.getFluidInTank(0);
            if (fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get()) {
                return (long)fluidStack.getAmount() * (Long)CommonTechConfig.energy_from_liquid_naquadah.get() + this.energy;
            }
            if (fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()) {
                return (long)fluidStack.getAmount() * (Long)CommonTechConfig.energy_from_heavy_liquid_naquadah.get() + this.energy;
            }
            return this.energy;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            ItemPowerCellProvider.this.saveEnergy();
        }

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            return 0L;
        }

        @Override
        public long extractLongEnergy(long maxExtract, boolean simulate) {
            long currentEnergy = this.getTrueEnergyStored();
            if (currentEnergy >= maxExtract) {
                return super.extractLongEnergy(maxExtract, simulate);
            }
            long convertedEnergy = ItemPowerCellProvider.this.convertLiquidNaquadahToEnergy(maxExtract, simulate);
            if (convertedEnergy <= 0L) {
                return super.extractLongEnergy(maxExtract, simulate);
            }
            long extractedEnergy = Math.min(maxExtract, currentEnergy += convertedEnergy);
            long energyLeft = currentEnergy - extractedEnergy;
            if (!simulate) {
                this.setEnergy(Math.min(this.getTrueMaxEnergyStored(), energyLeft));
            }
            return extractedEnergy;
        }
    };
    private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);

    public ItemPowerCellProvider(ItemStack stack) {
        super(stack);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract long energyCapacity();

    public abstract long energyMaxTransfer();

    private long convertFluidToEnergy(long maxExtract, long energyFromFluid, boolean simulate) {
        long drained = maxExtract / energyFromFluid;
        int toDrain = (int)Math.min((long)((PowerCellItem)this.stack.m_41720_()).getFluidAmount(this.stack), drained);
        this.deplete(toDrain, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return (long)toDrain * energyFromFluid;
    }

    public long convertLiquidNaquadahToEnergy(long maxExtract, boolean simulate) {
        FluidStack fluidStack = this.getFluidInTank(0);
        if (fluidStack.getAmount() <= 0) {
            return 0L;
        }
        if (fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get()) {
            return this.convertFluidToEnergy(maxExtract, (Long)CommonTechConfig.energy_from_liquid_naquadah.get(), simulate);
        }
        if (fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()) {
            return this.convertFluidToEnergy(maxExtract, (Long)CommonTechConfig.energy_from_heavy_liquid_naquadah.get(), simulate);
        }
        return 0L;
    }

    public void loadEnergy() {
        if (!this.stack.m_41782_()) {
            return;
        }
        CompoundTag tag = this.stack.m_41783_();
        if (tag.m_128425_(ENERGY_BUFFER, 4)) {
            this.ENERGY_STORAGE.deserializeNBT(tag.m_128423_(ENERGY_BUFFER));
        }
    }

    public void saveEnergy() {
        if (this.ENERGY_STORAGE.getEnergyWithoutLoading() > 0L) {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128365_(ENERGY_BUFFER, this.ENERGY_STORAGE.serializeNBT());
            this.stack.m_41751_(tag);
        } else if (this.stack.m_41783_() != null && this.stack.m_41783_().m_128441_(ENERGY_BUFFER)) {
            this.stack.m_41749_(ENERGY_BUFFER);
        }
    }
}

