/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.stargate.SGJourneyStargate;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;
import net.povstalec.sgjourney.common.sgjourney.transporter.SGJourneyTransporter;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class BlockEntityList
extends SavedData {
    private static final String FILE_NAME = "sgjourney-block_entities";
    private static final String INCORRECT_FILE_NAME = "sgjourney-block_enties";
    public static final String STARGATES = "Stargates";
    public static final String TRANSPORT_RINGS = "TransportRings";
    public static final String TRANSPORTERS = "Transporters";
    private MinecraftServer server;
    protected HashMap<Address.Immutable, Stargate> stargateMap = new HashMap();
    protected HashMap<UUID, Transporter> transporterMap = new HashMap();

    @Nullable
    public Stargate addStargate(AbstractStargateEntity stargate) {
        Address.Immutable address = stargate.get9ChevronAddress();
        if (address.getLength() != 8) {
            return null;
        }
        if (this.stargateMap.containsKey(address)) {
            return this.stargateMap.get(address);
        }
        if (stargate.m_58904_() == null) {
            return null;
        }
        SGJourneyStargate savedStargate = new SGJourneyStargate(stargate);
        this.stargateMap.put(address, savedStargate);
        this.m_77762_();
        StargateJourney.LOGGER.debug("Added Stargate " + address.toString() + " to BlockEntityList");
        return savedStargate;
    }

    public void removeStargate(Address id) {
        if (!this.stargateMap.containsKey(id)) {
            StargateJourney.LOGGER.error(id + " not found in BlockEntityList");
            return;
        }
        this.stargateMap.remove(id);
        StargateJourney.LOGGER.debug("Removed Stargate " + id + " from BlockEntityList");
        this.m_77762_();
    }

    public void printStargates() {
        System.out.println("[Stargates]");
        this.stargateMap.entrySet().stream().forEach(stargateEntry -> System.out.println("- " + ((Stargate)stargateEntry.getValue()).toString()));
    }

    public HashMap<Address.Immutable, Stargate> getStargates() {
        return (HashMap)this.stargateMap.clone();
    }

    public boolean containsStargate(Address address) {
        return this.stargateMap.containsKey(address);
    }

    @Nullable
    public Stargate getStargate(Address address) {
        return this.stargateMap.get(address);
    }

    @Nullable
    public Stargate getRandomStargate(long seed) {
        int size = this.stargateMap.size();
        if (size < 1) {
            return null;
        }
        Random random = new Random(seed);
        int randomValue = random.nextInt(0, size);
        Stargate randomStargate = (Stargate)this.stargateMap.entrySet().stream().toArray()[randomValue];
        return randomStargate;
    }

    public Transporter addTransporter(AbstractTransporterEntity transporterEntity) {
        UUID id;
        if (transporterEntity.getID() == null) {
            transporterEntity.setID(transporterEntity.generateID());
        }
        if (this.transporterMap.containsKey(id = transporterEntity.getID())) {
            return this.transporterMap.get(id);
        }
        if (transporterEntity.m_58904_() == null) {
            return null;
        }
        if (transporterEntity.m_58899_() == null) {
            return null;
        }
        SGJourneyTransporter transporter = new SGJourneyTransporter(transporterEntity);
        this.transporterMap.put(id, transporter);
        this.m_77762_();
        StargateJourney.LOGGER.debug("Added Transporter " + id + " to BlockEntityList");
        return transporter;
    }

    public void removeTransporter(UUID id) {
        if (!this.transporterMap.containsKey(id)) {
            StargateJourney.LOGGER.error(id + " not found in BlockEntityList");
            return;
        }
        this.transporterMap.remove(id);
        StargateJourney.LOGGER.debug("Removed Transporter " + id + " from BlockEntityList");
        this.m_77762_();
    }

    public HashMap<UUID, Transporter> getTransporters() {
        return (HashMap)this.transporterMap.clone();
    }

    @Nullable
    public Transporter getTransporter(UUID id) {
        Transporter transporter = this.transporterMap.get(id);
        return transporter;
    }

    public void printTransporters() {
        System.out.println("[Transporters]");
        this.transporterMap.entrySet().stream().forEach(transporterEntry -> System.out.println("- " + transporterEntry.getKey() + " " + ((Transporter)transporterEntry.getValue()).toString()));
    }

    public CompoundTag serialize() {
        CompoundTag blockEntityList = new CompoundTag();
        CompoundTag stargates = this.serializeStargates();
        CompoundTag transportRings = this.serializeTransporters();
        blockEntityList.m_128365_(STARGATES, (Tag)stargates);
        blockEntityList.m_128365_(TRANSPORTERS, (Tag)transportRings);
        return blockEntityList;
    }

    private CompoundTag serializeStargates() {
        CompoundTag stargates = new CompoundTag();
        this.stargateMap.forEach((stargateID, stargate) -> {
            if (stargate != null) {
                CompoundTag stargateTag = stargate.serializeNBT();
                if (stargateTag != null) {
                    stargates.m_128365_(stargateID.toString(), (Tag)stargateTag);
                } else {
                    StargateJourney.LOGGER.error("Cannot serialize Stargate " + stargateID + " because the tag is null");
                }
            } else {
                StargateJourney.LOGGER.error("Cannot serialize Stargate " + stargateID + " because it's null");
            }
        });
        return stargates;
    }

    private CompoundTag serializeTransporters() {
        CompoundTag transportersTag = new CompoundTag();
        this.transporterMap.forEach((ringsID, transporter) -> transportersTag.m_128365_(ringsID.toString(), (Tag)transporter.serializeNBT()));
        return transportersTag;
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag blockEntityList = tag.m_6426_();
        this.deserializeStargates(blockEntityList);
        this.deserializeTransporters(blockEntityList);
    }

    private void deserializeStargates(CompoundTag blockEntityList) {
        StargateJourney.LOGGER.debug("Deserializing Stargates");
        CompoundTag stargates = blockEntityList.m_128469_(STARGATES);
        stargates.m_128431_().stream().forEach(stargateAddress -> {
            Address.Immutable address = Address.Immutable.extendWithPointOfOrigin(new Address.Immutable((String)stargateAddress));
            if (address.getType() == Address.Type.ADDRESS_9_CHEVRON) {
                SGJourneyStargate stargate = new SGJourneyStargate();
                stargate.deserializeNBT(this.server, address, stargates.m_128469_(stargateAddress));
                this.stargateMap.put(address, stargate);
            }
        });
        StargateJourney.LOGGER.debug("Finished deserializing Stargates");
    }

    private void deserializeTransporters(CompoundTag blockEntityList) {
        StargateJourney.LOGGER.debug("Deserializing Transporters");
        if (blockEntityList.m_128441_(TRANSPORT_RINGS)) {
            CompoundTag transportRingsTag = blockEntityList.m_128469_(TRANSPORT_RINGS);
            transportRingsTag.m_128431_().stream().forEach(transportRings -> {
                Transporter transporter = BlockEntityList.tryDeserializeTransporter(this.server, transportRings, transportRingsTag.m_128469_(transportRings));
                if (transporter != null && !this.transporterMap.containsKey(transporter.getID())) {
                    this.transporterMap.put(transporter.getID(), transporter);
                }
            });
        }
        CompoundTag transportersTag = blockEntityList.m_128469_(TRANSPORTERS);
        transportersTag.m_128431_().stream().forEach(transporterString -> {
            Transporter transporter = BlockEntityList.tryDeserializeTransporter(this.server, transporterString, transportersTag.m_128469_(transporterString));
            if (transporter != null && !this.transporterMap.containsKey(transporter.getID())) {
                this.transporterMap.put(transporter.getID(), transporter);
            }
        });
        StargateJourney.LOGGER.debug("Finished deserializing Transporters");
    }

    private static Transporter tryDeserializeTransporter(MinecraftServer server, String id, CompoundTag transporterTag) {
        try {
            SGJourneyTransporter transporter = new SGJourneyTransporter();
            transporter.deserializeNBT(server, UUID.fromString(id), transporterTag);
            return transporter;
        }
        catch (IllegalArgumentException e) {
            BlockEntity blockEntity;
            ResourceKey<Level> dimension = Conversion.stringToDimension(transporterTag.m_128461_("Dimension"));
            BlockPos blockPos = Conversion.intArrayToBlockPos(transporterTag.m_128465_("Coordinates"));
            if (dimension != null && blockPos != null && (blockEntity = server.m_129880_(dimension).m_7702_(blockPos)) instanceof AbstractTransporterEntity) {
                AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
                transporter.setID(transporter.generateID());
                return new SGJourneyTransporter(transporter);
            }
            return null;
        }
    }

    public BlockEntityList(MinecraftServer server) {
        this.server = server;
    }

    public static BlockEntityList create(MinecraftServer server) {
        return new BlockEntityList(server);
    }

    public static BlockEntityList load(MinecraftServer server, CompoundTag tag) {
        BlockEntityList data = BlockEntityList.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static BlockEntityList get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return BlockEntityList.get(level.m_7654_());
    }

    @Nonnull
    public static BlockEntityList get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (BlockEntityList)storage.m_164861_(tag -> BlockEntityList.load(server, tag), () -> BlockEntityList.create(server), INCORRECT_FILE_NAME);
    }
}

