/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.common.sgjourney.stargate.ClassicStargate;
import net.povstalec.sgjourney.common.sgjourney.stargate.MilkyWayStargate;
import net.povstalec.sgjourney.common.sgjourney.stargate.PegasusStargate;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;
import net.povstalec.sgjourney.common.sgjourney.stargate.TollanStargate;
import net.povstalec.sgjourney.common.sgjourney.stargate.UniverseStargate;

public class StargateInit {
    private static final HashMap<ResourceLocation, StargateConstructor> STARGATES = new HashMap();
    private static final HashMap<Class<? extends Stargate>, ResourceLocation> LOCATIONS = new HashMap();

    public static <T extends Stargate> void register(ResourceLocation resourceLocation, Class<T> objectClass, StargateConstructor<T> constructor) {
        if (STARGATES.containsKey(resourceLocation)) {
            throw new IllegalStateException("Duplicate registration for " + resourceLocation.toString());
        }
        if (LOCATIONS.containsKey(objectClass)) {
            throw new IllegalStateException("Duplicate registration for " + objectClass.getName());
        }
        STARGATES.put(resourceLocation, constructor);
        LOCATIONS.put(objectClass, resourceLocation);
    }

    @Nullable
    public static Stargate constructStargate(ResourceLocation resourceLocation) {
        if (STARGATES.containsKey(resourceLocation)) {
            return STARGATES.get(resourceLocation).create();
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(Stargate stargate) {
        if (stargate != null && LOCATIONS.containsKey(stargate.getClass())) {
            return LOCATIONS.get(stargate.getClass());
        }
        return null;
    }

    public static void register() {
        StargateInit.register(new ResourceLocation("sgjourney", "universe_stargate"), UniverseStargate.class, UniverseStargate::new);
        StargateInit.register(new ResourceLocation("sgjourney", "milky_way_stargate"), MilkyWayStargate.class, MilkyWayStargate::new);
        StargateInit.register(new ResourceLocation("sgjourney", "pegasus_stargate"), PegasusStargate.class, PegasusStargate::new);
        StargateInit.register(new ResourceLocation("sgjourney", "tollan_stargate"), TollanStargate.class, TollanStargate::new);
        StargateInit.register(new ResourceLocation("sgjourney", "classic_stargate"), ClassicStargate.class, ClassicStargate::new);
    }

    public static interface StargateConstructor<T extends Stargate> {
        public T create();
    }
}

