/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import org.jetbrains.annotations.Nullable;

public abstract class EnergyBlockItem
extends BlockItem {
    public EnergyBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public long getEnergy(ItemStack stack) {
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null && blockEntityTag.m_128425_("Energy", 4)) {
            return blockEntityTag.m_128454_("Energy");
        }
        return 0L;
    }

    public abstract long getCapacity();

    public boolean m_142522_(ItemStack stack) {
        return this.getEnergy(stack) > 0L;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.getEnergy(stack) / (float)this.getCapacity());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.getEnergy(stack) / (float)this.getCapacity());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + SGJourneyEnergy.energyToString(this.getEnergy(stack), this.getCapacity())))).m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static interface CapacityGetter {
        public long getCapacity();
    }

    public static class Getter
    extends EnergyBlockItem {
        private CapacityGetter capacityGetter;

        public Getter(Block block, Item.Properties properties, CapacityGetter capacityGetter) {
            super(block, properties);
            this.capacityGetter = capacityGetter;
        }

        @Override
        public long getCapacity() {
            return this.capacityGetter.getCapacity();
        }
    }
}

