/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import org.jetbrains.annotations.Nullable;

public class MemoryCrystalItem
extends AbstractCrystalItem {
    public static final int DEFAULT_MEMORY_CAPACITY = 5;
    public static final int ADVANCED_MEMORY_CAPACITY = 10;
    public static final String MEMORY_LIST = "memory_list";
    public static final String ID = "id";
    public static final String COORDINATES = "coords";
    public static final String ADDRESS = "address";

    public MemoryCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public int getMemoryCapacity() {
        return 5;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_();
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        ListTag list = MemoryCrystalItem.getMemoryList(stack);
        for (int i = 0; i < list.size(); ++i) {
            tooltipComponents.add((Component)Component.m_237113_((String)("[" + i + "] ")).m_7220_(this.memoryTypeComponentAt(list, i)));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public MemoryType memoryTypeAt(ListTag list, int index) {
        if (list.m_128728_(index).m_128425_(ADDRESS, 11)) {
            return MemoryType.ADDRESS;
        }
        if (list.m_128728_(index).m_128425_(COORDINATES, 11)) {
            return MemoryType.COORDINATES;
        }
        if (list.m_128728_(index).m_128425_(ID, 8)) {
            return MemoryType.ID;
        }
        return MemoryType.UNKNOWN;
    }

    public Component memoryTypeComponentAt(ListTag list, int index) {
        return this.memoryTypeAt(list, index).getComponent();
    }

    public String memoryStringAt(ListTag list, int index) {
        MemoryType memoryType = this.memoryTypeAt(list, index);
        return switch (memoryType) {
            case MemoryType.ADDRESS -> MemoryCrystalItem.getAddress(list, index).toString();
            case MemoryType.COORDINATES -> MemoryCrystalItem.getCoords(list, index).toString();
            case MemoryType.ID -> MemoryCrystalItem.getUUID(list, index).toString();
            default -> "-";
        };
    }

    private boolean saveMemory(ItemStack stack, CompoundTag memory) {
        ListTag list = MemoryCrystalItem.getMemoryList(stack);
        if (list.size() >= this.getMemoryCapacity()) {
            return false;
        }
        list.add((Object)memory);
        MemoryCrystalItem.setMemoryList(stack, list);
        return true;
    }

    public boolean saveAddress(ItemStack stack, Address.Immutable address) {
        CompoundTag addressTag = new CompoundTag();
        addressTag.m_128385_(ADDRESS, address.toArray());
        return this.saveMemory(stack, addressTag);
    }

    public boolean saveCoords(ItemStack stack, Vec3i coords) {
        CompoundTag coordsTag = new CompoundTag();
        coordsTag.m_128385_(COORDINATES, Conversion.vecToIntArray(coords));
        return this.saveMemory(stack, coordsTag);
    }

    public boolean saveUUID(ItemStack stack, UUID uuid) {
        CompoundTag uuidTag = new CompoundTag();
        uuidTag.m_128359_(ID, uuid.toString());
        return this.saveMemory(stack, uuidTag);
    }

    @Nullable
    public static Address.Immutable getAddress(ListTag list, int index) {
        if (list.m_128728_(index).m_128425_(ADDRESS, 11)) {
            return new Address.Immutable(list.m_128728_(index).m_128465_(ADDRESS));
        }
        return null;
    }

    @Nullable
    public static Address.Immutable getFirstAddress(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            Address.Immutable address = MemoryCrystalItem.getAddress(list, i);
            if (address == null) continue;
            return address;
        }
        return null;
    }

    @Nullable
    public static Address.Immutable getFirstAddress(ItemStack stack) {
        return MemoryCrystalItem.getFirstAddress(MemoryCrystalItem.getMemoryList(stack));
    }

    @Nullable
    public static Vec3i getCoords(ListTag list, int index) {
        if (list.m_128728_(index).m_128425_(COORDINATES, 11)) {
            return Conversion.intArrayToVec(list.m_128728_(index).m_128465_(COORDINATES));
        }
        return null;
    }

    @Nullable
    public static Vec3i getFirstCoords(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            Vec3i coords = MemoryCrystalItem.getCoords(list, i);
            if (coords == null) continue;
            return coords;
        }
        return null;
    }

    @Nullable
    public static Vec3i getFirstCoords(ItemStack stack) {
        return MemoryCrystalItem.getFirstCoords(MemoryCrystalItem.getMemoryList(stack));
    }

    @Nullable
    public static UUID getUUID(ListTag list, int index) {
        if (list.m_128728_(index).m_128425_(ID, 8)) {
            try {
                return UUID.fromString(list.m_128728_(index).m_128461_(ID));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static UUID getFirstUUID(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            UUID uuid = MemoryCrystalItem.getUUID(list, i);
            if (uuid == null) continue;
            return uuid;
        }
        return null;
    }

    @Nullable
    public static UUID getFirstUUID(ItemStack stack) {
        return MemoryCrystalItem.getFirstUUID(MemoryCrystalItem.getMemoryList(stack));
    }

    public static ListTag getMemoryList(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof MemoryCrystalItem && (tag = stack.m_41783_()) != null && tag.m_128425_(MEMORY_LIST, 9)) {
            return tag.m_128437_(MEMORY_LIST, 10);
        }
        return new ListTag();
    }

    private static void setMemoryList(ItemStack stack, ListTag list) {
        if (stack.m_41720_() instanceof MemoryCrystalItem && list != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(MEMORY_LIST, (Tag)list);
            stack.m_41751_(tag);
        }
    }

    static enum MemoryType {
        UNKNOWN((Component)Component.m_237115_((String)"tooltip.sgjourney.unknown").m_130940_(ChatFormatting.DARK_RED)),
        ADDRESS((Component)Component.m_237115_((String)"tooltip.sgjourney.address").m_130940_(ChatFormatting.AQUA)),
        ID((Component)Component.m_237115_((String)"tooltip.sgjourney.id").m_130940_(ChatFormatting.DARK_AQUA)),
        COORDINATES((Component)Component.m_237115_((String)"tooltip.sgjourney.coordinates").m_130940_(ChatFormatting.BLUE));

        private final Component component;

        private MemoryType(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    public static class Advanced
    extends MemoryCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public int getMemoryCapacity() {
            return 10;
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }
    }
}

