/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.config.CommonStargateNetworkConfig;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class SolarSystem {
    public static final ResourceKey<Registry<SolarSystem>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("sgjourney", "solar_system"));
    public static final Codec<ResourceKey<SolarSystem>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    private static final Codec<Pair<List<Integer>, Boolean>> ADDRESS = Codec.pair((Codec)Codec.INT.listOf().fieldOf("address").codec(), (Codec)Codec.BOOL.fieldOf("randomizable").codec());
    private static final Codec<Pair<ResourceKey<Galaxy>, Pair<List<Integer>, Boolean>>> GALAXY_AND_ADDRESS = Codec.pair((Codec)Galaxy.RESOURCE_KEY_CODEC.fieldOf("galaxy").codec(), (Codec)ADDRESS.fieldOf("address").codec());
    public static final Codec<SolarSystem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(SolarSystem::getName), (App)Symbols.RESOURCE_KEY_CODEC.fieldOf("symbols").forGetter(SolarSystem::getSymbols), (App)Codec.INT.fieldOf("symbol_prefix").forGetter(SolarSystem::getSymbolPrefix), (App)ADDRESS.fieldOf("extragalactic_address").forGetter(SolarSystem::getExtragalacticAddress), (App)GALAXY_AND_ADDRESS.listOf().optionalFieldOf("addresses").forGetter(SolarSystem::getAddresses), (App)PointOfOrigin.RESOURCE_KEY_CODEC.fieldOf("point_of_origin").forGetter(SolarSystem::getPointOfOrigin), (App)Level.f_46427_.listOf().fieldOf("dimensions").forGetter(SolarSystem::getDimensions)).apply((Applicative)instance, SolarSystem::new));
    private final String name;
    private final ResourceKey<Symbols> symbols;
    private final int symbolPrefix;
    private final Pair<List<Integer>, Boolean> extragalactic_address;
    private final ResourceKey<PointOfOrigin> point_of_origin;
    private final Optional<List<Pair<ResourceKey<Galaxy>, Pair<List<Integer>, Boolean>>>> addresses;
    private final List<ResourceKey<Level>> dimensions;

    public SolarSystem(String name, ResourceKey<Symbols> symbols, int symbolPrefix, Pair<List<Integer>, Boolean> extragalactic_address, Optional<List<Pair<ResourceKey<Galaxy>, Pair<List<Integer>, Boolean>>>> addresses, ResourceKey<PointOfOrigin> point_of_origin, List<ResourceKey<Level>> dimensions) {
        this.name = name;
        this.symbols = symbols;
        this.symbolPrefix = symbolPrefix;
        this.extragalactic_address = extragalactic_address;
        this.point_of_origin = point_of_origin;
        this.addresses = addresses;
        this.dimensions = dimensions;
    }

    public String getName() {
        return this.name;
    }

    public ResourceKey<Symbols> getSymbols() {
        return this.symbols;
    }

    public int getSymbolPrefix() {
        return this.symbolPrefix;
    }

    public Pair<List<Integer>, Boolean> getExtragalacticAddress() {
        return this.extragalactic_address;
    }

    public int[] getAddressArray() {
        return ((List)this.extragalactic_address.getFirst()).stream().mapToInt(integer -> integer).toArray();
    }

    public boolean isAddressRandomizable() {
        return (Boolean)this.extragalactic_address.getSecond();
    }

    public Optional<List<Pair<ResourceKey<Galaxy>, Pair<List<Integer>, Boolean>>>> getAddresses() {
        return this.addresses;
    }

    public ResourceKey<PointOfOrigin> getPointOfOrigin() {
        return this.point_of_origin;
    }

    public List<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }

    public static SolarSystem getSolarSystem(Level level, String part1, String part2) {
        return SolarSystem.getSolarSystem(level, new ResourceLocation(part1, part2));
    }

    public static SolarSystem getSolarSystem(Level level, ResourceLocation solarSystem) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (SolarSystem)registry.m_7745_(solarSystem);
    }

    public static class Serializable {
        public static final String PRIMARY_STARGATE = "primary_stargate";
        public static final String LOCATION = "location";
        public static final String NAME = "name";
        public static final String POINT_OF_ORIGIN = "point_of_origin";
        public static final String SYMBOLS = "symbols";
        public static final String SYMBOL_PREFIX = "symbol_prefix";
        public static final String EXTRAGALACTIC_ADDRESS = "extragalactic_address";
        public static final String DIMENSIONS = "dimensions";
        private static final boolean DHD_PREFERENCE = !CommonStargateNetworkConfig.disable_dhd_preference.get();
        private final ResourceLocation location;
        private final String name;
        private final boolean isGenerated;
        private final ResourceKey<PointOfOrigin> pointOfOrigin;
        private final ResourceKey<Symbols> symbols;
        private final int symbolPrefix;
        private final Address.Immutable extragalacticAddress;
        private final List<ResourceKey<Level>> dimensions;
        private HashMap<Galaxy.Serializable, Address.Immutable> galacticAddresses = new HashMap();
        private List<Stargate> stargates = new ArrayList<Stargate>();
        @Nullable
        private Address.Immutable primaryAddress = null;
        @Nullable
        private Stargate primaryStargate = null;

        public Serializable(ResourceLocation location, Address.Immutable extragalacticAddress, SolarSystem solarSystem) {
            this.location = location;
            this.name = solarSystem.getName();
            this.isGenerated = false;
            this.pointOfOrigin = solarSystem.getPointOfOrigin();
            this.symbols = solarSystem.getSymbols();
            this.symbolPrefix = solarSystem.getSymbolPrefix();
            this.extragalacticAddress = extragalacticAddress;
            this.dimensions = solarSystem.getDimensions();
        }

        public Serializable(ResourceLocation location, String name, Address.Immutable extragalacticAddress, ResourceKey<PointOfOrigin> pointOfOrigin, ResourceKey<Symbols> symbols, int symbolPrefix, List<ResourceKey<Level>> dimensions) {
            this.location = location;
            this.name = name;
            this.isGenerated = true;
            this.extragalacticAddress = extragalacticAddress;
            this.pointOfOrigin = pointOfOrigin;
            this.symbols = symbols;
            this.symbolPrefix = symbolPrefix;
            this.dimensions = dimensions;
        }

        public ResourceLocation location() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public Component getTranslatedName() {
            if (!this.isGenerated) {
                return Component.m_237115_((String)this.name);
            }
            return Component.m_237113_((String)this.name);
        }

        public ResourceKey<PointOfOrigin> getPointOfOrigin() {
            return this.pointOfOrigin;
        }

        public ResourceKey<Symbols> getSymbols() {
            return this.symbols;
        }

        public int getSymbolPrefix() {
            return this.symbolPrefix;
        }

        public Address.Immutable getExtragalacticAddress() {
            return this.extragalacticAddress;
        }

        public List<ResourceKey<Level>> getDimensions() {
            return this.dimensions;
        }

        public boolean isGenerated() {
            return this.isGenerated;
        }

        public HashMap<Galaxy.Serializable, Address.Immutable> getGalacticAddresses() {
            return this.galacticAddresses;
        }

        public void addToGalaxy(Galaxy.Serializable galaxy, Address.Immutable address) {
            this.galacticAddresses.put(galaxy, address);
        }

        @Nullable
        public Address.Immutable getAddressFromGalaxy(Galaxy.Serializable galaxy) {
            if (galaxy == null) {
                return null;
            }
            return this.galacticAddresses.get(galaxy);
        }

        @Nullable
        public Galaxy.Serializable findCommonGalaxy(Serializable other) {
            if (other == null) {
                return null;
            }
            for (Map.Entry<Galaxy.Serializable, Address.Immutable> entry : this.galacticAddresses.entrySet()) {
                for (Map.Entry<Galaxy.Serializable, Address.Immutable> otherEntry : other.galacticAddresses.entrySet()) {
                    if (!entry.getKey().equals(otherEntry.getKey())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        @Nullable
        public Serializable getSolarSystemFromAddress(Address address) {
            for (Map.Entry<Galaxy.Serializable, Address.Immutable> entry : this.galacticAddresses.entrySet()) {
                if (!entry.getKey().containsSolarSystem(address)) continue;
                return entry.getKey().getSolarSystem(address);
            }
            return null;
        }

        public List<Stargate> getStargates() {
            return this.stargates;
        }

        public void addStargate(MinecraftServer server, Stargate addedStargate) {
            if (this.primaryAddress == null) {
                if (addedStargate.isPrimary(server)) {
                    this.primaryAddress = addedStargate.get9ChevronAddress().clone();
                    this.primaryStargate = addedStargate;
                }
            } else if (this.primaryStargate == null && this.primaryAddress.equals(addedStargate.get9ChevronAddress())) {
                this.primaryStargate = addedStargate;
            }
            if (!this.stargates.contains(addedStargate)) {
                int i;
                for (i = 0; i < this.stargates.size(); ++i) {
                    Stargate existingStargate = this.stargates.get(i);
                    if (DHD_PREFERENCE && Boolean.compare(addedStargate.hasDHD(), existingStargate.hasDHD()) > 0 || (!DHD_PREFERENCE || Boolean.compare(addedStargate.hasDHD(), existingStargate.hasDHD()) == 0) && (addedStargate.getGeneration().isNewer(existingStargate.getGeneration()) || addedStargate.getGeneration() == existingStargate.getGeneration() && addedStargate.getTimesOpened() > existingStargate.getTimesOpened())) break;
                }
                this.stargates.add(i, addedStargate);
            }
        }

        public void removeStargate(Stargate stargate) {
            if (stargate == this.primaryStargate) {
                this.primaryStargate = null;
            }
            if (this.stargates.contains(stargate)) {
                this.stargates.remove(stargate);
            }
        }

        @Nullable
        private Stargate findStargate(Address.Immutable primaryAddress) {
            for (Stargate stargate : this.stargates) {
                if (!primaryAddress.equals(stargate.get9ChevronAddress())) continue;
                return stargate;
            }
            return null;
        }

        @Nullable
        public boolean setPrimaryStargate(@Nullable Address.Immutable primaryAddress) {
            if (primaryAddress != null && primaryAddress.getType() != Address.Type.ADDRESS_9_CHEVRON) {
                return false;
            }
            if (primaryAddress == null) {
                this.primaryStargate = null;
                this.primaryAddress = null;
            } else {
                if (primaryAddress.equals(this.primaryAddress)) {
                    return false;
                }
                this.primaryStargate = this.findStargate(primaryAddress);
                this.primaryAddress = primaryAddress;
            }
            return true;
        }

        @Nullable
        public Address.Immutable primaryAddress() {
            return this.primaryAddress;
        }

        @Nullable
        public Stargate primaryStargate() {
            return this.primaryStargate;
        }

        @Nullable
        public Stargate getRandomStargate(long seed) {
            int size = this.stargates.size();
            if (size < 1) {
                return null;
            }
            Random random = new Random(seed);
            int randomValue = random.nextInt(0, size);
            Stargate randomStargate = this.stargates.get(randomValue);
            return randomStargate;
        }

        public CompoundTag serialize() {
            CompoundTag solarSystemTag = new CompoundTag();
            solarSystemTag.m_128359_(LOCATION, this.location.toString());
            if (this.isGenerated()) {
                solarSystemTag.m_128359_(NAME, this.name);
                solarSystemTag.m_128359_(POINT_OF_ORIGIN, this.pointOfOrigin.m_135782_().toString());
                solarSystemTag.m_128359_(SYMBOLS, this.symbols.m_135782_().toString());
                solarSystemTag.m_128405_(SYMBOL_PREFIX, this.symbolPrefix);
                CompoundTag dimensionsTag = new CompoundTag();
                this.dimensions.stream().forEach(dimension -> dimensionsTag.m_128359_(dimension.m_135782_().toString(), dimension.m_135782_().toString()));
                solarSystemTag.m_128365_(DIMENSIONS, (Tag)dimensionsTag);
            }
            solarSystemTag.m_128385_(EXTRAGALACTIC_ADDRESS, this.extragalacticAddress.toArray());
            if (this.primaryAddress != null) {
                solarSystemTag.m_128385_(PRIMARY_STARGATE, this.primaryAddress.toArray());
            }
            return solarSystemTag;
        }

        public static Serializable deserialize(MinecraftServer server, Registry<SolarSystem> solarSystemRegistry, CompoundTag solarSystemTag) {
            Serializable solarSystem;
            if (!solarSystemTag.m_128425_(NAME, 8)) {
                ResourceKey<SolarSystem> solarSystemKey = Conversion.stringToSolarSystemKey(solarSystemTag.m_128461_(LOCATION));
                Address.Immutable extragalacticAddress = new Address.Immutable(solarSystemTag.m_128465_(EXTRAGALACTIC_ADDRESS));
                solarSystem = new Serializable(solarSystemKey.m_135782_(), extragalacticAddress, (SolarSystem)solarSystemRegistry.m_6246_(solarSystemKey));
            } else {
                String translationName = solarSystemTag.m_128461_(NAME);
                ResourceLocation location = ResourceLocation.m_135820_((String)solarSystemTag.m_128461_(LOCATION));
                ResourceKey<PointOfOrigin> pointOfOrigin = Conversion.stringToPointOfOrigin(solarSystemTag.m_128461_(POINT_OF_ORIGIN));
                ResourceKey<Symbols> symbols = Conversion.stringToSymbols(solarSystemTag.m_128461_(SYMBOLS));
                int symbolPrefix = solarSystemTag.m_128451_(SYMBOL_PREFIX);
                Address.Immutable extragalacticAddress = new Address.Immutable(solarSystemTag.m_128465_(EXTRAGALACTIC_ADDRESS));
                ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
                solarSystemTag.m_128469_(DIMENSIONS).m_128431_().forEach(dimensionString -> dimensions.add(Conversion.stringToDimension(dimensionString)));
                solarSystem = new Serializable(location, translationName, extragalacticAddress, pointOfOrigin, symbols, symbolPrefix, dimensions);
            }
            if (solarSystemTag.m_128425_(PRIMARY_STARGATE, 11)) {
                solarSystem.setPrimaryStargate(new Address.Immutable(solarSystemTag.m_128465_(PRIMARY_STARGATE)));
            }
            return solarSystem;
        }
    }
}

