/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.widgets.GDOButton;
import net.povstalec.sgjourney.client.widgets.GDOLargeButton;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ServerboundGDOUpdatePacket;

public class GDOScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("sgjourney", "textures/gui/gdo/gdo_background.png");
    private int imageWidth = 240;
    private int imageHeight = 120;
    private final UUID playerId;
    private final boolean mainHand;
    private String idc;
    private int frequency;
    private boolean toggledFrequency = false;

    public GDOScreen(UUID playerId, boolean mainHand, String idc, int frequency) {
        super((Component)Component.m_237119_());
        this.playerId = playerId;
        this.idc = idc;
        this.frequency = frequency;
        this.mainHand = mainHand;
    }

    public void m_7856_() {
        int x = (this.f_96543_ - this.imageWidth) / 2;
        int y = (this.f_96544_ - this.imageHeight) / 2;
        super.m_7856_();
        this.m_142416_((GuiEventListener)new GDOButton(x + 75, y + 37, (Component)Component.m_237113_((String)"7"), button -> this.addToCode(7)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 93, y + 37, (Component)Component.m_237113_((String)"8"), button -> this.addToCode(8)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 111, y + 37, (Component)Component.m_237113_((String)"9"), button -> this.addToCode(9)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 75, y + 49, (Component)Component.m_237113_((String)"4"), button -> this.addToCode(4)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 93, y + 49, (Component)Component.m_237113_((String)"5"), button -> this.addToCode(5)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 111, y + 49, (Component)Component.m_237113_((String)"6"), button -> this.addToCode(6)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 75, y + 61, (Component)Component.m_237113_((String)"1"), button -> this.addToCode(1)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 93, y + 61, (Component)Component.m_237113_((String)"2"), button -> this.addToCode(2)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 111, y + 61, (Component)Component.m_237113_((String)"3"), button -> this.addToCode(3)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 75, y + 73, (Component)Component.m_237115_((String)"screen.sgjourney.gdo.symbol.delete"), (Component)Component.m_237115_((String)"screen.sgjourney.gdo.delete"), button -> this.removeFromCode()));
        this.m_142416_((GuiEventListener)new GDOButton(x + 93, y + 73, (Component)Component.m_237113_((String)"0"), button -> this.addToCode(0)));
        this.m_142416_((GuiEventListener)new GDOButton(x + 111, y + 73, (Component)Component.m_237115_((String)"screen.sgjourney.gdo.symbol.toggle_frequency"), (Component)Component.m_237115_((String)"screen.sgjourney.gdo.toggle_frequency"), button -> this.toggleFrequency()));
        this.m_142416_((GuiEventListener)new GDOLargeButton(x + 32, y + 46, (Component)Component.m_237119_(), (Component)Component.m_237115_((String)"screen.sgjourney.gdo.send_transmission"), button -> this.sendTransmission()));
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_7333_(poseStack);
        int x = (this.f_96543_ - this.imageWidth) / 2;
        int y = (this.f_96544_ - this.imageHeight) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.imageWidth, this.imageHeight);
        super.m_86412_(poseStack, mouseX, mouseY, delta);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        this.renderLabels(poseStack, mouseX, mouseY, x, y);
        poseStack.m_85849_();
    }

    protected void renderLabels(PoseStack stack, int mouseX, int mouseY, float x, float y) {
        this.f_96547_.m_92889_(stack, (Component)Component.m_237113_((String)this.idc), x + 266.0f, y + 104.0f, 2763047);
        this.f_96547_.m_92889_(stack, (Component)Component.m_237115_((String)"screen.sgjourney.transceiver.frequency").m_7220_((Component)Component.m_237113_((String)(this.toggledFrequency ? ": #" : ":"))), x + 266.0f, y + 120.0f, 2763047);
        this.f_96547_.m_92889_(stack, (Component)Component.m_237113_((String)String.valueOf(this.frequency)), x + 266.0f, y + 132.0f, 2763047);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 48: 
            case 320: {
                this.addToCode(0);
                break;
            }
            case 49: 
            case 321: {
                this.addToCode(1);
                break;
            }
            case 50: 
            case 322: {
                this.addToCode(2);
                break;
            }
            case 51: 
            case 323: {
                this.addToCode(3);
                break;
            }
            case 52: 
            case 324: {
                this.addToCode(4);
                break;
            }
            case 53: 
            case 325: {
                this.addToCode(5);
                break;
            }
            case 54: 
            case 326: {
                this.addToCode(6);
                break;
            }
            case 55: 
            case 327: {
                this.addToCode(7);
                break;
            }
            case 56: 
            case 328: {
                this.addToCode(8);
                break;
            }
            case 57: 
            case 329: {
                this.addToCode(9);
                break;
            }
            case 259: 
            case 261: {
                this.removeFromCode();
                break;
            }
            case 257: 
            case 335: {
                this.sendTransmission();
                break;
            }
            case 341: 
            case 345: {
                this.toggleFrequency();
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void sendTransmission() {
        PacketHandlerInit.INSTANCE.sendToServer((Object)new ServerboundGDOUpdatePacket(this.mainHand, this.frequency, this.idc, true));
    }

    private void updateServer() {
        PacketHandlerInit.INSTANCE.sendToServer((Object)new ServerboundGDOUpdatePacket(this.mainHand, this.frequency, this.idc, false));
    }

    private void toggleFrequency() {
        this.toggledFrequency = !this.toggledFrequency;
    }

    private void addToCode(int number) {
        if (!this.toggledFrequency) {
            if (this.idc.length() >= 16) {
                return;
            }
            this.idc = this.idc + String.valueOf(number);
        } else {
            long tempFrequency = this.frequency;
            if ((tempFrequency = tempFrequency * 10L + (long)number) > Integer.MAX_VALUE) {
                return;
            }
            this.frequency = (int)tempFrequency;
        }
        this.updateServer();
    }

    private void removeFromCode() {
        if (!this.toggledFrequency) {
            if (this.idc.length() <= 0) {
                return;
            }
            this.idc = this.idc.substring(0, this.idc.length() - 1);
        } else {
            if (this.frequency <= 0) {
                return;
            }
            this.frequency /= 10;
        }
        this.updateServer();
    }
}

