/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.povstalec.sgjourney.common.blocks.tech.CableBlock;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCableConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.data.ConduitNetworks;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CableBlockEntity
extends BlockEntity {
    public static final String NETWORK_ID = "network_id";
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private int networkID = 0;
    private ConduitNetworks.ConduitNetwork cableNetwork = null;
    private List<Direction> connectedSides = null;
    public final SGJourneyEnergy ENERGY_STORAGE = new SGJourneyEnergy(this.maxTransfer(), this.maxTransfer(), this.maxTransfer()){

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            return CableBlockEntity.this.transferEnergy(Math.min(CableBlockEntity.this.maxTransfer(), maxReceive), simulate, false);
        }

        @Override
        public long receiveZeroPointEnergy(long maxReceive, boolean simulate) {
            return CableBlockEntity.this.transferEnergy(Math.min(CableBlockEntity.this.maxTransfer(), maxReceive), simulate, true);
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return true;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            CableBlockEntity.this.m_6596_();
        }
    };

    public CableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        this.lazyEnergyHandler.invalidate();
        super.invalidateCaps();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.networkID = nbt.m_128451_(NETWORK_ID);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_(NETWORK_ID, this.networkID);
    }

    public abstract long maxTransfer();

    public void setNetworkID(int networkID) {
        this.networkID = networkID;
        this.cableNetwork = null;
    }

    public int networkID() {
        return this.networkID;
    }

    @Nullable
    private ConduitNetworks.ConduitNetwork getNetwork() {
        if (this.cableNetwork != null) {
            return this.cableNetwork;
        }
        if (this.networkID == 0) {
            return null;
        }
        this.cableNetwork = ConduitNetworks.get(this.m_58904_()).getCableNetwork(this.networkID);
        return this.cableNetwork;
    }

    public void update() {
        this.connectedSides = null;
    }

    public boolean isOutput() {
        for (Direction direction : this.getConnectedSides()) {
            IEnergyStorage energy;
            BlockPos outputPos = this.m_58899_().m_121945_(direction);
            BlockEntity blockEntity = this.f_58857_.m_7702_(outputPos);
            if (blockEntity == null || blockEntity instanceof CableBlockEntity || (energy = (IEnergyStorage)blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).resolve().orElse(null)) == null || !energy.canReceive()) continue;
            return true;
        }
        return false;
    }

    public List<Direction> getConnectedSides() {
        if (this.connectedSides == null) {
            this.connectedSides = new ArrayList<Direction>();
            for (Direction direction : Direction.values()) {
                if (CableBlock.connectionTypeSide((BlockGetter)this.m_58904_(), this.m_58899_(), direction) != CableBlock.ConnectorType.BLOCK) continue;
                this.connectedSides.add(direction);
            }
        }
        return this.connectedSides;
    }

    public int validOutputs() {
        int outputs = 0;
        for (Direction direction : this.getConnectedSides()) {
            SGJourneyEnergy sgjourneyEnergy;
            IEnergyStorage energy;
            BlockPos outputPos = this.m_58899_().m_121945_(direction);
            BlockEntity blockEntity = this.f_58857_.m_7702_(outputPos);
            if (blockEntity == null || (energy = (IEnergyStorage)blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).resolve().orElse(null)) == null || !energy.canReceive()) continue;
            if (energy instanceof SGJourneyEnergy && (sgjourneyEnergy = (SGJourneyEnergy)energy).getTrueEnergyStored() < sgjourneyEnergy.getTrueMaxEnergyStored()) {
                ++outputs;
                continue;
            }
            if (energy.getEnergyStored() >= energy.getMaxEnergyStored()) continue;
            ++outputs;
        }
        return outputs;
    }

    public long outputEnergy(Direction direction, long toOutput, boolean simulate, boolean zeroPointEnergy) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
        if (blockEntity == null) {
            return 0L;
        }
        IEnergyStorage energy = blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).resolve().orElse(null);
        if (energy == null || !energy.canReceive()) {
            return 0L;
        }
        if (energy instanceof SGJourneyEnergy) {
            SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)energy;
            return zeroPointEnergy ? sgjourneyEnergy.receiveZeroPointEnergy(toOutput, simulate) : sgjourneyEnergy.receiveLongEnergy(toOutput, simulate);
        }
        if (zeroPointEnergy && !((Boolean)CommonZPMConfig.other_mods_use_zero_point_energy.get()).booleanValue()) {
            return 0L;
        }
        return energy.receiveEnergy(SGJourneyEnergy.regularEnergy(toOutput), simulate);
    }

    public long transferEnergy(long toTransfer, boolean simulate, boolean zeroPointEnergy) {
        if (zeroPointEnergy && !this.canTransferZeroPointEnergy()) {
            return 0L;
        }
        ConduitNetworks.ConduitNetwork cableNetwork = this.getNetwork();
        if (cableNetwork == null) {
            return 0L;
        }
        return cableNetwork.transferEnergy(this.m_58904_(), toTransfer, simulate, zeroPointEnergy);
    }

    public abstract boolean canTransferZeroPointEnergy();

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public static class LargeNaquadahCable
    extends CableBlockEntity {
        public LargeNaquadahCable(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_CABLE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.large_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.large_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class MediumNaquadahCable
    extends CableBlockEntity {
        public MediumNaquadahCable(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.MEDIUM_NAQUADAH_CABLE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.medium_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.medium_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class SmallNaquadahCable
    extends CableBlockEntity {
        public SmallNaquadahCable(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SMALL_NAQUADAH_CABLE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.small_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.small_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class NaquadahWire
    extends CableBlockEntity {
        public NaquadahWire(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.NAQUADAH_WIRE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.naquadah_wire_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.naquadah_wire_transfers_zero_point_energy.get();
        }
    }
}

