/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateRingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class ClassicStargateBaseBlock
extends HorizontalDirectionalBlock {
    public ClassicStargateBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            Direction direction;
            Orientation orientation;
            ItemStack stack = player.m_21120_(hand);
            Address.Mutable address = new Address.Mutable();
            if (((Boolean)CommonStargateConfig.enable_address_choice.get()).booleanValue() && stack.m_150930_((Item)ItemInit.CONTROL_CRYSTAL.get())) {
                String name = stack.m_41786_().getString();
                if (address.fromString(name).getType() != Address.Type.ADDRESS_9_CHEVRON) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.classic.invalid_address"), true);
                    return InteractionResult.FAIL;
                }
                if (BlockEntityList.get(level).containsStargate(address)) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.classic.address_exists"), true);
                    return InteractionResult.FAIL;
                }
            }
            if ((orientation = ClassicStargateBaseBlock.getPlacementOrientation(level, pos, direction = (Direction)level.m_8055_(pos).m_61143_((Property)f_54117_))) == null) {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.classic.incorrect_setup"), true);
                return InteractionResult.FAIL;
            }
            ClassicStargateBlock block = (ClassicStargateBlock)BlockInit.CLASSIC_STARGATE.get();
            level.m_7731_(pos, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)ClassicStargateBlock.FACING, (Comparable)direction)).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
            for (StargatePart part : block.getParts()) {
                if (part.equals(StargatePart.BASE)) continue;
                level.m_7731_(part.getRingPos(pos, direction, orientation), (BlockState)((BlockState)((BlockState)((ClassicStargateRingBlock)BlockInit.CLASSIC_RING.get()).m_49966_().m_61124_((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)direction)).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
            }
            BlockEntity baseEntity = level.m_7702_(pos);
            if (baseEntity instanceof ClassicStargateEntity) {
                ClassicStargateEntity stargate = (ClassicStargateEntity)baseEntity;
                if (address.getLength() == 8) {
                    stargate.set9ChevronAddress(new Address.Immutable(address));
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                stargate.symbolInfo().setPointOfOrigin(PointOfOrigin.randomPointOfOrigin(level.m_7654_(), (ResourceKey<Level>)level.m_46472_()));
                stargate.symbolInfo().setSymbols(Symbols.fromDimension(level.m_7654_(), (ResourceKey<Level>)level.m_46472_()));
                stargate.displayID();
                stargate.addStargateToNetwork();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private static Block getClassicStargateBlock(StargatePart part) {
        return switch (part) {
            case StargatePart.LEFT, StargatePart.LEFT3_ABOVE, StargatePart.LEFT3_ABOVE4, StargatePart.LEFT2_ABOVE6, StargatePart.ABOVE6, StargatePart.RIGHT2_ABOVE6, StargatePart.RIGHT3_ABOVE4, StargatePart.RIGHT3_ABOVE, StargatePart.RIGHT -> (Block)BlockInit.CLASSIC_STARGATE_CHEVRON_BLOCK.get();
            default -> (Block)BlockInit.CLASSIC_STARGATE_RING_BLOCK.get();
        };
    }

    private static boolean checkParts(Level level, BlockPos pos, Direction direction, Orientation orientation) {
        ClassicStargateBlock block = (ClassicStargateBlock)BlockInit.CLASSIC_STARGATE.get();
        for (StargatePart part : block.getParts()) {
            if (part.equals(StargatePart.BASE) || level.m_8055_(part.getRingPos(pos, direction, orientation)).m_60713_(ClassicStargateBaseBlock.getClassicStargateBlock(part))) continue;
            return false;
        }
        return true;
    }

    private static Orientation getPlacementOrientation(Level level, BlockPos pos, Direction direction) {
        for (Orientation orientation : Orientation.values()) {
            if (!ClassicStargateBaseBlock.checkParts(level, pos, direction, orientation)) continue;
            return orientation;
        }
        return null;
    }
}

