/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemInventoryProvider
implements ICapabilityProvider {
    private static final String INVENTORY = "Inventory";
    private ItemStack stack;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public ItemInventoryProvider(ItemStack stack) {
        this.stack = stack;
    }

    public abstract int getNumberOfSlots();

    public abstract boolean isValid(int var1, @Nonnull ItemStack var2);

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(this.getNumberOfSlots()){

            protected void onContentsChanged(int slot) {
                ItemInventoryProvider.this.saveInventory();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ItemInventoryProvider.this.isValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemInventoryProvider.this.loadInventory();
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemInventoryProvider.this.loadInventory();
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                ItemInventoryProvider.this.loadInventory();
                this.validateSlotIndex(slot);
                return (ItemStack)this.stacks.get(slot);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return LazyOptional.empty();
    }

    public void loadInventory() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_(INVENTORY)) {
            this.itemHandler.deserializeNBT(tag.m_128469_(INVENTORY));
        }
    }

    public void saveInventory() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128365_(INVENTORY, (Tag)this.itemHandler.serializeNBT());
        this.stack.m_41751_(tag);
    }
}

