/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.InterfaceMethod;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.InterfacePeripheral;
import net.povstalec.sgjourney.common.compatibility.computer_functions.GenericStargateFunctions;

public class StargatePeripheral
extends InterfacePeripheral {
    protected AbstractStargateEntity stargate;

    public StargatePeripheral(AbstractInterfaceEntity interfaceEntity, AbstractStargateEntity stargate) {
        super(interfaceEntity);
        this.stargate = stargate;
        stargate.registerInterfaceMethods(new StargatePeripheralWrapper(this, interfaceEntity.getInterfaceType()));
    }

    @Override
    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        String methodName = this.getMethodNames()[method];
        return ((InterfaceMethod)this.methods.get(methodName)).use(computer, context, this.interfaceEntity, this.stargate, arguments);
    }

    public void queueEvent(String eventName, Object ... objects) {
        for (IComputerAccess computer : this.interfaceEntity.getPeripheralWrapper().computerList) {
            int length = objects.length + 1;
            Object[] attachmentObjects = new Object[length];
            attachmentObjects[0] = computer.getAttachmentName();
            for (int i = 1; i < length; ++i) {
                attachmentObjects[i] = objects[i - 1];
            }
            computer.queueEvent(eventName, attachmentObjects);
        }
    }

    @LuaFunction
    public final int getStargateGeneration() {
        return GenericStargateFunctions.getStargateGeneration(this.stargate);
    }

    @LuaFunction
    public final String getStargateType() {
        return GenericStargateFunctions.getStargateType(this.stargate);
    }

    @LuaFunction
    public final boolean isStargateConnected() {
        return GenericStargateFunctions.isStargateConnected(this.stargate);
    }

    @LuaFunction
    public final boolean isStargateDialingOut() {
        return GenericStargateFunctions.isStargateDialingOut(this.stargate);
    }

    @LuaFunction
    public final boolean isWormholeOpen() {
        return GenericStargateFunctions.isWormholeOpen(this.stargate);
    }

    @LuaFunction
    public final long getStargateEnergy() {
        return GenericStargateFunctions.getStargateEnergy(this.stargate);
    }

    @LuaFunction
    public final int getChevronsEngaged() {
        return GenericStargateFunctions.getChevronsEngaged(this.stargate);
    }

    @LuaFunction
    public final int getOpenTime() {
        return GenericStargateFunctions.getOpenTime(this.stargate);
    }

    @LuaFunction
    public final MethodResult disconnectStargate(ILuaContext context) throws LuaException {
        return context.executeMainThreadTask(() -> new Object[]{GenericStargateFunctions.disconnectStargate(this.stargate)});
    }
}

