/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.events.custom;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

@Cancelable
public class StargateEvent
extends Event {
    private final MinecraftServer server;
    private final Stargate stargate;

    public StargateEvent(MinecraftServer server, Stargate stargate) {
        this.server = server;
        this.stargate = stargate;
    }

    public Stargate getStargate() {
        return this.stargate;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Cancelable
    public static class WormholeTravel
    extends StargateEvent {
        private final Stargate destinationStargate;
        private final Entity traveler;
        private final StargateInfo.WormholeTravel wormholeTravel;

        public WormholeTravel(MinecraftServer server, Stargate stargate, Stargate destinationStargate, Entity traveler, StargateInfo.WormholeTravel wormholeTravel) {
            super(server, stargate);
            this.destinationStargate = destinationStargate;
            this.traveler = traveler;
            this.wormholeTravel = wormholeTravel;
        }

        public Stargate getDestinationStargate() {
            return this.destinationStargate;
        }

        public Entity getTraveler() {
            return this.traveler;
        }

        public StargateInfo.WormholeTravel getWormholeTravel() {
            return this.wormholeTravel;
        }
    }

    @Cancelable
    public static class Connect
    extends StargateEvent {
        private final StargateConnection.Type connectionType;
        private final Stargate connectedStargate;
        private final Address.Type addressType;
        private final boolean doKawoosh;

        public Connect(MinecraftServer server, Stargate stargate, Stargate connectedStargate, StargateConnection.Type connectionType, Address.Type addressType, boolean doKawoosh) {
            super(server, stargate);
            this.connectedStargate = connectedStargate;
            this.connectionType = connectionType;
            this.addressType = addressType;
            this.doKawoosh = doKawoosh;
        }

        public Stargate getConnectedStargate() {
            return this.connectedStargate;
        }

        public StargateConnection.Type getConnectionType() {
            return this.connectionType;
        }

        public Address.Type getAddressType() {
            return this.addressType;
        }

        public boolean doKawoosh() {
            return this.doKawoosh;
        }
    }

    @Cancelable
    public static class Dial
    extends StargateEvent {
        private final Address dialedAddress;
        private final boolean doKawoosh;

        public Dial(MinecraftServer server, Stargate stargate, Address dialedAddress, boolean doKawoosh) {
            super(server, stargate);
            this.dialedAddress = dialedAddress.clone();
            this.doKawoosh = doKawoosh;
        }

        public Address getDialedAddress() {
            return this.dialedAddress;
        }

        public boolean doKawoosh() {
            return this.doKawoosh;
        }
    }
}

