/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.capabilities.ZPMEnergyProvider;
import net.povstalec.sgjourney.common.capabilities.ZeroPointEnergy;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import org.jetbrains.annotations.Nullable;

public class ZeroPointModule
extends Item {
    private static final String ENERGY = "Energy";
    private static final String ENTROPY = "Entropy";

    public ZeroPointModule(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return !StargateJourneyConfig.disable_energy_use.get();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (1000.0f - (float)ZeroPointModule.getEntropy(stack)) / 1000.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 16743680;
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ZPMEnergyProvider(stack){};
    }

    private static int getEntropy(ItemStack stack) {
        Tag tag;
        if (!stack.m_150930_((Item)ItemInit.ZPM.get())) {
            return 0;
        }
        CompoundTag tag2 = stack.m_41784_();
        if (tag2.m_128425_(ENTROPY, 3) && (tag = tag2.m_128423_(ENTROPY)) instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return intTag.m_7047_();
        }
        return 0;
    }

    public static long getEnergy(ItemStack stack) {
        Tag tag;
        if (!stack.m_150930_((Item)ItemInit.ZPM.get())) {
            return 0L;
        }
        CompoundTag tag2 = stack.m_41784_();
        if (tag2.m_128425_(ENERGY, 4) && (tag = tag2.m_128423_(ENERGY)) instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return longTag.m_7046_();
        }
        return ZeroPointEnergy.ENERGY_PER_ENTROPY_LEVEL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int entropy = ZeroPointModule.getEntropy(stack);
        long remainingEnergy = ZeroPointModule.getEnergy(stack);
        float currentEntropy = (float)entropy * 100.0f / 1000.0f;
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.zpm.entropy").m_7220_((Component)Component.m_237113_((String)(": " + currentEntropy + "%"))).m_130940_(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + ZeroPointEnergy.zeroPointEnergyToString(entropy, remainingEnergy)))).m_130940_(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.zpm.description"));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

