/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public class CrystallizerMenu
extends InventoryMenu {
    protected final AbstractCrystallizerEntity blockEntity;
    protected final Level level;
    protected FluidStack fluidStack;

    public CrystallizerMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public CrystallizerMenu(int containerId, Inventory inventory, BlockEntity blockEntity) {
        super((MenuType)MenuInit.CRYSTALLIZER.get(), containerId);
        CrystallizerMenu.m_38869_((Container)inventory, (int)5);
        this.blockEntity = (AbstractCrystallizerEntity)blockEntity;
        this.level = inventory.f_35978_.f_19853_;
        this.fluidStack = this.blockEntity.getFluid();
        this.addPlayerInventory(inventory, 8, 84);
        this.addPlayerHotbar(inventory, 8, 142);
        this.blockEntity.getItemHandler(0).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 20)));
        this.blockEntity.getItemHandler(1).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 67, 50)));
        this.blockEntity.getItemHandler(2).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 93, 50)));
        this.blockEntity.getItemHandler(3).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 130, 36)));
        this.blockEntity.getItemHandler(4).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 34, 20)));
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluid() {
        return this.blockEntity.getFluid();
    }

    public Fluid getDesiredFluid() {
        return this.blockEntity.getDesiredFluid();
    }

    public int getProgress() {
        return this.blockEntity.progress;
    }

    public boolean m_6875_(Player player) {
        return CrystallizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.CRYSTALLIZER.get())) || CrystallizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.ADVANCED_CRYSTALLIZER.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 5;
    }

    private boolean hasRequiredLiquid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).getFluid().m_6212_(this.blockEntity.getDesiredFluid());
        }
        return false;
    }

    private static boolean countEquals(ItemStack first, ItemStack second) {
        return first.m_41613_() == second.m_41613_();
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        boolean stopQuickMove = false;
        if (index < 36) {
            stopQuickMove = true;
            if (this.hasRequiredLiquid(sourceStack)) {
                this.m_38903_(sourceStack, 40, 41, false);
            }
            if (CrystallizerMenu.countEquals(sourceStack, copyOfSourceStack) && !this.m_38903_(sourceStack, 36, 36 + this.TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + this.TE_INVENTORY_SLOT_COUNT) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        if (stopQuickMove) {
            return ItemStack.f_41583_;
        }
        return copyOfSourceStack;
    }
}

