/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.info.AddressFilterInfo;

public abstract class Address
implements Cloneable {
    public static final String ADDRESS_DIVIDER = "-";
    public static final int MIN_DIALED_ADDRESS_LENGTH = 6;
    public static final int MAX_ADDRESS_LENGTH = 9;
    protected int[] addressArray = new int[0];

    public Address() {
    }

    public Address(int ... addressArray) throws IllegalArgumentException {
        try {
            Address.verifyValidity(addressArray);
            this.addressArray = addressArray;
        }
        catch (IllegalArgumentException e) {
            StargateJourney.LOGGER.error("Error parsing address " + Address.addressIntArrayToString(addressArray), (Throwable)e);
        }
    }

    public Address(Address other) {
        this(other.addressArray);
    }

    public Address(String addressString) {
        this(Address.addressStringToIntArray(addressString));
    }

    public Address(Map<Double, Double> addressTable) {
        this(ArrayHelper.tableToArray(addressTable));
    }

    public Address(List<Integer> addressList) {
        this(Address.integerListToArray(addressList));
    }

    public static void verifyValidity(int[] addressArray) throws IllegalArgumentException {
        if (addressArray.length > 9) {
            throw new IllegalArgumentException("Address is too long <0, 9>");
        }
        if (!ArrayHelper.differentNumbers(addressArray)) {
            throw new IllegalArgumentException("Address contains duplicate symbols");
        }
        for (int i = 0; i < addressArray.length; ++i) {
            if (addressArray[i] < 0 || addressArray[i] > 47) {
                throw new IllegalArgumentException("Address symbol " + addressArray[i] + " out of bounds <0, 47>");
            }
            if (addressArray[i] != 0 || i == addressArray.length - 1) continue;
            throw new IllegalArgumentException("No symbols allowed in Address after Point of Origin");
        }
    }

    public int getLength() {
        return this.addressArray.length;
    }

    public int symbolAt(int index) {
        if (index < 0 || index >= this.addressArray.length) {
            return 0;
        }
        return this.addressArray[index];
    }

    public boolean isEmpty() {
        return this.addressArray.length == 0;
    }

    public boolean hasPointOfOrigin() {
        if (this.addressArray.length != 0) {
            return this.addressArray[this.addressArray.length - 1] == 0;
        }
        return false;
    }

    public int regularSymbolCount() {
        if (this.hasPointOfOrigin()) {
            return this.addressArray.length - 1;
        }
        return this.addressArray.length;
    }

    public Type getType() {
        if (this.hasPointOfOrigin()) {
            return Type.fromLength(this.addressArray.length);
        }
        return Type.fromLength(this.addressArray.length + 1);
    }

    public Component toComponent(boolean copyToClipboard) {
        ChatFormatting chatFormatting = switch (this.getType()) {
            case Type.ADDRESS_7_CHEVRON -> ChatFormatting.GOLD;
            case Type.ADDRESS_8_CHEVRON -> ChatFormatting.LIGHT_PURPLE;
            case Type.ADDRESS_9_CHEVRON -> ChatFormatting.AQUA;
            default -> ChatFormatting.GRAY;
        };
        Style style = Style.f_131099_;
        if (copyToClipboard) {
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
            style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.toString()));
        }
        return Component.m_237113_((String)Address.addressIntArrayToString(this.addressArray)).m_6270_(style.m_131157_(chatFormatting));
    }

    public boolean containsSymbol(int symbol) {
        for (int i = 0; i < this.getLength(); ++i) {
            if (this.symbolAt(i) != symbol) continue;
            return true;
        }
        return false;
    }

    public int[] toArray() {
        return (int[])this.addressArray.clone();
    }

    public List<Integer> toList() {
        return Arrays.stream(this.addressArray).boxed().toList();
    }

    public String toString() {
        return Address.addressIntArrayToString(this.addressArray);
    }

    public Address clone() {
        try {
            Address address = (Address)super.clone();
            address.addressArray = (int[])this.addressArray.clone();
            return address;
        }
        catch (CloneNotSupportedException e) {
            StargateJourney.LOGGER.error("Could not clone Address" + e);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Address) {
            Address address = (Address)object;
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.symbolAt(i) == address.symbolAt(i)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof AddressFilterInfo.HiddenAddress) {
            AddressFilterInfo.HiddenAddress hiddenAddress = (AddressFilterInfo.HiddenAddress)object;
            return this.equals(hiddenAddress.address());
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == this.symbolAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.symbolAt(0), this.symbolAt(1), this.symbolAt(2), this.symbolAt(3), this.symbolAt(4), this.symbolAt(5), this.symbolAt(6), this.symbolAt(7), this.symbolAt(8));
    }

    private static boolean isAllowedInAddress(char character) {
        return character == '-' || character >= '0' && character <= '9';
    }

    public static boolean canBeTransformedToAddress(String addressString) {
        for (int i = 0; i < addressString.length(); ++i) {
            char character = addressString.charAt(i);
            if (Character.isDigit(character) || character == '-') continue;
            return false;
        }
        return true;
    }

    public static int[] addressStringToIntArray(String addressString) {
        if (addressString == null || !Address.canBeTransformedToAddress(addressString)) {
            return new int[0];
        }
        String[] stringArray = addressString.split(ADDRESS_DIVIDER);
        int[] intArray = new int[]{};
        for (int i = 1; i < stringArray.length; ++i) {
            int number = Character.getNumericValue(stringArray[i].charAt(0));
            int length = stringArray[i].length();
            if (length > 1) {
                number = number * 10 + Character.getNumericValue(stringArray[i].charAt(1));
            }
            intArray = ArrayHelper.growIntArray(intArray, number);
        }
        return intArray;
    }

    public static String addressIntArrayToString(int[] array) {
        Object address = ADDRESS_DIVIDER;
        for (int symbol : array) {
            address = (String)address + symbol + ADDRESS_DIVIDER;
        }
        return address;
    }

    public static int[] integerListToArray(List<Integer> integerList) {
        return integerList.stream().mapToInt(integer -> integer).toArray();
    }

    public static int[] randomAddressArray(int prefix, int size, int limit, long seed) {
        if (size > 9) {
            throw new IllegalArgumentException("Address is too long <0, 9>");
        }
        Random random = new Random(seed);
        int[] addressArray = new int[size];
        boolean isValid = false;
        while (!isValid) {
            for (int i = 0; i < size; ++i) {
                addressArray[i] = i == 0 && prefix > 0 && prefix < limit ? prefix : random.nextInt(1, limit);
            }
            if (!ArrayHelper.differentNumbers(addressArray)) continue;
            isValid = true;
        }
        return addressArray;
    }

    public static enum Type {
        ADDRESS_INVALID(0),
        ADDRESS_9_CHEVRON(9),
        ADDRESS_8_CHEVRON(8),
        ADDRESS_7_CHEVRON(7);

        private byte value;

        private Type(byte value) {
            this.value = value;
        }

        public byte byteValue() {
            return this.value;
        }

        public static Type fromLength(int addressLength) {
            return switch (addressLength) {
                case 7 -> ADDRESS_7_CHEVRON;
                case 8 -> ADDRESS_8_CHEVRON;
                case 9 -> ADDRESS_9_CHEVRON;
                default -> ADDRESS_INVALID;
            };
        }
    }

    public static final class Immutable
    extends Address {
        public static final Codec<Immutable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("symbols").forGetter(address -> Arrays.stream(address.addressArray).boxed().collect(Collectors.toList()))).apply((Applicative)instance, Immutable::new));

        public Immutable() {
        }

        public Immutable(int ... addressArray) {
            super(addressArray);
        }

        public Immutable(Address other) {
            super(other.addressArray);
        }

        public Immutable(String addressString) {
            super(addressString);
        }

        public Immutable(Map<Double, Double> addressTable) {
            super(addressTable);
        }

        public Immutable(List<Integer> addressList) {
            super(addressList);
        }

        @Override
        public Immutable clone() {
            return (Immutable)super.clone();
        }

        public static Immutable randomAddress(int size, int limit, long seed) {
            return Immutable.randomAddress(0, size, limit, seed);
        }

        public static Immutable randomAddress(int prefix, int size, int limit, long seed) {
            return new Immutable(Immutable.randomAddressArray(prefix, size, limit, seed));
        }

        public static Immutable read(StringReader reader) {
            int i = reader.getCursor();
            while (reader.canRead() && Address.isAllowedInAddress(reader.peek())) {
                reader.skip();
            }
            String string = reader.getString().substring(i, reader.getCursor());
            return new Immutable(string);
        }

        public static Immutable extendWithPointOfOrigin(Immutable address) {
            if (!address.hasPointOfOrigin() && address.addressArray.length < 9) {
                return new Immutable(ArrayHelper.growIntArray(address.addressArray, 0));
            }
            return address;
        }
    }

    public static final class Dimension
    extends Address {
        public static final Codec<Dimension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.f_46427_.fieldOf("dimension").forGetter(address -> address.getDimension()), (App)Galaxy.RESOURCE_KEY_CODEC.optionalFieldOf("galaxy").forGetter(weightedAddress -> Optional.ofNullable(weightedAddress.galaxyKey))).apply((Applicative)instance, Dimension::new));
        protected ResourceKey<Level> dimension;
        @Nullable
        private ResourceKey<Galaxy> galaxyKey;

        public Dimension() {
        }

        public Dimension(ResourceKey<Level> dimension, Optional<ResourceKey<Galaxy>> galaxyKey) {
            this.dimension = dimension;
            this.galaxyKey = galaxyKey.orElse(null);
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public ResourceKey<Galaxy> getGalaxy() {
            return this.galaxyKey;
        }

        public void generate(MinecraftServer server) {
            Galaxy.Serializable galaxy;
            Immutable address = this.galaxyKey != null ? Universe.get(server).getAddressInGalaxyFromDimension(this.galaxyKey.m_135782_(), this.dimension) : ((galaxy = Universe.get(server).getGalaxyFromDimension(this.dimension)) != null ? Universe.get(server).getAddressInGalaxyFromDimension(galaxy.getKey().m_135782_(), this.dimension) : new Immutable());
            this.addressArray = (int[])address.addressArray.clone();
        }

        @Override
        public Dimension clone() {
            Dimension address = (Dimension)super.clone();
            address.dimension = this.dimension;
            return address;
        }
    }

    public static final class Mutable
    extends Address {
        public static final Codec<Mutable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("symbols").forGetter(address -> Arrays.stream(address.addressArray).boxed().collect(Collectors.toList()))).apply((Applicative)instance, Mutable::new));

        public Mutable() {
        }

        public Mutable(int ... addressArray) {
            super(addressArray);
        }

        public Mutable(Address otherAddress) {
            super(otherAddress.addressArray);
        }

        public Mutable(String addressString) {
            super(addressString);
        }

        public Mutable(Map<Double, Double> addressTable) {
            super(addressTable);
        }

        public Mutable(List<Integer> addressList) {
            super(addressList);
        }

        public Mutable reset() {
            this.addressArray = new int[0];
            return this;
        }

        public int[] getArray() {
            return this.addressArray;
        }

        public boolean addSymbol(int symbol) {
            if (!this.canGrow()) {
                return false;
            }
            if (symbol < 0) {
                return false;
            }
            this.addressArray = ArrayHelper.growIntArray(this.addressArray, symbol);
            return true;
        }

        public boolean canGrow() {
            if (this.addressArray.length < 9) {
                return true;
            }
            return this.hasPointOfOrigin();
        }

        public boolean canBeDialed() {
            if (this.hasPointOfOrigin()) {
                return this.addressArray.length >= 6;
            }
            return this.addressArray.length == 9;
        }

        public Mutable fromArray(int ... addressArray) {
            try {
                Mutable.verifyValidity(addressArray);
                this.addressArray = addressArray;
            }
            catch (IllegalArgumentException e) {
                StargateJourney.LOGGER.error("Error parsing address " + Mutable.addressIntArrayToString(addressArray), (Throwable)e);
            }
            return this;
        }

        public Mutable fromAddress(Address otherAddress) {
            return this.fromArray(otherAddress.addressArray);
        }

        public Mutable fromString(String addressString) {
            return this.fromArray(Mutable.addressStringToIntArray(addressString));
        }

        public Mutable fromTable(Map<Double, Double> addressTable) {
            return this.fromArray(ArrayHelper.tableToArray(addressTable));
        }

        public Mutable fromIntegerList(List<Integer> integerList) {
            return this.fromArray(Mutable.integerListToArray(integerList));
        }

        @Override
        public Mutable clone() {
            return (Mutable)super.clone();
        }

        public static Mutable randomAddress(int size, int limit, long seed) {
            return Mutable.randomAddress(0, size, limit, seed);
        }

        public static Mutable randomAddress(int prefix, int size, int limit, long seed) {
            return new Mutable(Mutable.randomAddressArray(prefix, size, limit, seed));
        }

        public static Mutable read(StringReader reader) {
            int i = reader.getCursor();
            while (reader.canRead() && Address.isAllowedInAddress(reader.peek())) {
                reader.skip();
            }
            String string = reader.getString().substring(i, reader.getCursor());
            return new Mutable(string);
        }
    }
}

