/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.ArrowTrajectory;
import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.ImpactResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4836;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ArrowDetection {
    private static final Map<UUID, ArrowTrajectory> activeTrajectories = new HashMap<UUID, ArrowTrajectory>();
    private static final double ARROW_DETECTION_RANGE = 32.0;
    private static final double GRAVITY = 0.05;
    private static final double DRAG = 0.99;
    private static final int MAX_TICKS_AHEAD = 60;
    private static final int SUBSTEPS_PER_TICK = 4;
    private static final double EPS = 1.0E-6;

    public static void detectArrows(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        boolean allowSkeleton = DodgerClient.CONFIG.skeletonDodgeEnabled;
        boolean allowStray = DodgerClient.CONFIG.strayDodgeEnabled;
        boolean allowPillager = DodgerClient.CONFIG.pillagerDodgeEnabled;
        boolean allowPiglin = DodgerClient.CONFIG.piglinDodgeEnabled;
        List arrows = world.method_8390(class_1667.class, player.method_5829().method_1014(32.0), arrow -> {
            if (!arrow.method_5805()) {
                return false;
            }
            class_1297 owner = arrow.method_24921();
            if (owner instanceof class_1613) {
                return allowSkeleton;
            }
            if (owner instanceof class_1627) {
                return allowStray;
            }
            if (owner instanceof class_1604) {
                return allowPillager;
            }
            if (owner instanceof class_4836) {
                return allowPiglin;
            }
            return false;
        });
        HashMap<UUID, ArrowTrajectory> newTrajectories = new HashMap<UUID, ArrowTrajectory>();
        for (ArrowTrajectory existing : activeTrajectories.values()) {
            if (existing.isExpired()) continue;
            newTrajectories.put(existing.getArrowUuid(), existing);
        }
        for (class_1667 arrow2 : arrows) {
            UUID arrowId = arrow2.method_5667();
            ArrowTrajectory existingTrajectory = activeTrajectories.get(arrowId);
            if (existingTrajectory != null) {
                class_238 playerBox;
                class_243 velocity;
                ImpactResult impact;
                ArrayList<class_243> updatedPoints = new ArrayList<class_243>(existingTrajectory.getTrajectoryPoints());
                class_243 currentPos = Compat.pos((class_1297)arrow2);
                if (updatedPoints.isEmpty() || ((class_243)updatedPoints.get(updatedPoints.size() - 1)).method_1025(currentPos) > 0.1) {
                    updatedPoints.add(currentPos);
                }
                boolean targetsPlayer = (impact = ArrowDetection.predictImpactWithAABB(currentPos, velocity = arrow2.method_18798(), playerBox = player.method_5829().method_1014(0.2))) != null;
                ArrowTrajectory updatedTrajectory = new ArrowTrajectory(arrow2, existingTrajectory.getShooterUuid(), updatedPoints, impact != null ? impact.point : currentPos, targetsPlayer, existingTrajectory.getCreationTime(), impact != null ? Double.valueOf(impact.etaMs) : null);
                newTrajectories.put(arrowId, updatedTrajectory);
                continue;
            }
            ArrowTrajectory newTrajectory = ArrowDetection.createTrajectory(arrow2, (class_1657)player);
            newTrajectories.put(arrowId, newTrajectory);
        }
        activeTrajectories.clear();
        activeTrajectories.putAll(newTrajectories);
    }

    private static ArrowTrajectory createTrajectory(class_1667 arrow, class_1657 player) {
        class_1309 shooter = (class_1309)arrow.method_24921();
        class_243 currentPos = Compat.pos((class_1297)arrow);
        class_243 velocity = arrow.method_18798();
        ArrayList<class_243> trajectoryPoints = new ArrayList<class_243>();
        trajectoryPoints.add(currentPos);
        class_238 playerBox = player.method_5829().method_1014(0.2);
        ImpactResult impact = ArrowDetection.predictImpactWithAABB(currentPos, velocity, playerBox);
        boolean targetsPlayer = impact != null;
        return new ArrowTrajectory(arrow, shooter.method_5667(), trajectoryPoints, impact != null ? impact.point : currentPos, targetsPlayer, System.currentTimeMillis(), impact != null ? Double.valueOf(impact.etaMs) : null);
    }

    private static ImpactResult predictImpactWithAABB(class_243 startPos, class_243 startVel, class_238 targetBox) {
        if (targetBox.method_1006(startPos)) {
            return new ImpactResult(startPos, 0.0);
        }
        class_243 pos = startPos;
        class_243 vel = startVel;
        double dt = 0.25;
        int maxSteps = 240;
        for (int i = 0; i < 240; ++i) {
            class_243 prevPos = pos;
            pos = pos.method_1019(vel.method_1021(0.25));
            vel = vel.method_1031(0.0, -0.0125, 0.0);
            double dragPow = Math.pow(0.99, 0.25);
            vel = vel.method_1021(dragPow);
            class_243 hit = ArrowDetection.segmentAabbIntersection(prevPos, pos, targetBox);
            if (hit == null) continue;
            double tTicks = (double)(i + 1) * 0.25;
            double etaMs = tTicks * 50.0;
            return new ImpactResult(hit, etaMs);
        }
        return null;
    }

    private static class_243 segmentAabbIntersection(class_243 p0, class_243 p1, class_238 b) {
        double tmp;
        double t2;
        double t1;
        double inv;
        double tMin = 0.0;
        double tMax = 1.0;
        double dx = p1.field_1352 - p0.field_1352;
        double dy = p1.field_1351 - p0.field_1351;
        double dz = p1.field_1350 - p0.field_1350;
        if (Math.abs(dx) < 1.0E-6) {
            if (p0.field_1352 < b.field_1323 || p0.field_1352 > b.field_1320) {
                return null;
            }
        } else {
            inv = 1.0 / dx;
            t1 = (b.field_1323 - p0.field_1352) * inv;
            t2 = (b.field_1320 - p0.field_1352) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (Math.abs(dy) < 1.0E-6) {
            if (p0.field_1351 < b.field_1322 || p0.field_1351 > b.field_1325) {
                return null;
            }
        } else {
            inv = 1.0 / dy;
            t1 = (b.field_1322 - p0.field_1351) * inv;
            t2 = (b.field_1325 - p0.field_1351) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (Math.abs(dz) < 1.0E-6) {
            if (p0.field_1350 < b.field_1321 || p0.field_1350 > b.field_1324) {
                return null;
            }
        } else {
            inv = 1.0 / dz;
            t1 = (b.field_1321 - p0.field_1350) * inv;
            t2 = (b.field_1324 - p0.field_1350) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (tMin < 0.0 || tMin > 1.0) {
            return null;
        }
        return new class_243(p0.field_1352 + dx * tMin, p0.field_1351 + dy * tMin, p0.field_1350 + dz * tMin);
    }

    public static List<ArrowTrajectory> getTrajectories() {
        return new ArrayList<ArrowTrajectory>(activeTrajectories.values());
    }

    public static void clearTrajectories() {
        activeTrajectories.clear();
    }
}

