/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1667;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class ArrowTrajectory {
    private final UUID arrowUuid;
    private final UUID shooterUuid;
    private final List<class_243> trajectoryPoints;
    private final class_243 targetPosition;
    private final long creationTime;
    private final boolean targetsPlayer;
    private final Double etaMs;

    public ArrowTrajectory(class_1667 arrow, UUID shooterUuid, List<class_243> trajectoryPoints, class_243 targetPos, boolean targetsPlayer) {
        this(arrow, shooterUuid, trajectoryPoints, targetPos, targetsPlayer, System.currentTimeMillis(), null);
    }

    public ArrowTrajectory(class_1667 arrow, UUID shooterUuid, List<class_243> trajectoryPoints, class_243 targetPos, boolean targetsPlayer, long creationTime) {
        this(arrow, shooterUuid, trajectoryPoints, targetPos, targetsPlayer, creationTime, null);
    }

    public ArrowTrajectory(class_1667 arrow, UUID shooterUuid, List<class_243> trajectoryPoints, class_243 targetPos, boolean targetsPlayer, long creationTime, Double etaMs) {
        this.arrowUuid = arrow.method_5667();
        this.shooterUuid = shooterUuid;
        this.trajectoryPoints = trajectoryPoints;
        this.targetPosition = targetPos;
        this.creationTime = creationTime;
        this.targetsPlayer = targetsPlayer;
        this.etaMs = etaMs;
    }

    public UUID getArrowUuid() {
        return this.arrowUuid;
    }

    public UUID getShooterUuid() {
        return this.shooterUuid;
    }

    public List<class_243> getTrajectoryPoints() {
        return this.trajectoryPoints;
    }

    public class_243 getStartPosition() {
        return this.trajectoryPoints.isEmpty() ? class_243.field_1353 : this.trajectoryPoints.get(0);
    }

    public class_243 getTargetPosition() {
        return this.targetPosition;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean targetsPlayer() {
        return this.targetsPlayer;
    }

    public Double getEtaMs() {
        return this.etaMs;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.creationTime > 3000L;
    }

    public float getFadeOpacity() {
        long age = System.currentTimeMillis() - this.creationTime;
        if (age >= 3000L) {
            return 0.0f;
        }
        if (age <= 2000L) {
            return 1.0f;
        }
        float fadeProgress = (float)(age - 2000L) / 1000.0f;
        return 1.0f - fadeProgress;
    }
}

