/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.BlazeDodger;
import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.FireballImpact;
import com.dodger.ImpactResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1545;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BlazeTracker {
    private static final Set<UUID> aggressiveBlazes = new HashSet<UUID>();
    private static final double DETECTION_RANGE = 64.0;
    private static final int MAX_TICKS_AHEAD = 60;
    private static final double FIREBALL_RADIUS = 0.2;
    private static final double PLAYER_SAFE_PADDING = 0.05;
    private static final Map<UUID, FireballImpact> activeFireballs = new HashMap<UUID, FireballImpact>();
    private static final double EPS = 1.0E-6;

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!DodgerClient.CONFIG.blazeDodgeEnabled && !DodgerClient.CONFIG.blazeDebugEnabled) {
            aggressiveBlazes.clear();
            activeFireballs.clear();
            BlazeDodger.clear();
            return;
        }
        if (client.field_1761 == null || client.field_1761.method_2920() == null || !client.field_1761.method_2920().method_8388()) {
            aggressiveBlazes.clear();
            activeFireballs.clear();
            BlazeDodger.clear();
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        aggressiveBlazes.removeIf(arg_0 -> BlazeTracker.lambda$tick$1((class_1937)world, (class_1657)player, arg_0));
        world.method_8390(class_1545.class, player.method_5829().method_1014(64.0), class_1309::method_5805).forEach(arg_0 -> BlazeTracker.lambda$tick$2((class_1657)player, arg_0));
        if (DodgerClient.CONFIG.blazeDebugEnabled || DodgerClient.CONFIG.blazeDodgeEnabled) {
            BlazeTracker.detectFireballs(client);
        }
        if (DodgerClient.CONFIG.blazeDodgeEnabled) {
            BlazeDodger.tick(client);
        }
    }

    private static boolean isTargetingPlayer(class_1545 blaze, class_1657 player) {
        class_1309 target = blaze.method_5968();
        if (target != null && target.equals((Object)player)) {
            return true;
        }
        if (blaze.method_6510() && blaze.method_6057((class_1297)player)) {
            return true;
        }
        return blaze.method_6057((class_1297)player) && blaze.method_5858((class_1297)player) <= 256.0;
    }

    private static void detectFireballs(class_310 client) {
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_238 expandedPlayer = new class_238(player.method_5829().field_1323 - 0.2 - 0.05, player.method_5829().field_1322, player.method_5829().field_1321 - 0.2 - 0.05, player.method_5829().field_1320 + 0.2 + 0.05, player.method_5829().field_1325, player.method_5829().field_1324 + 0.2 + 0.05);
        List fireballs = world.method_8390(class_1677.class, player.method_5829().method_1014(64.0), f -> f.method_5805() && f.method_18798().method_1027() > 0.05 && f.method_24921() instanceof class_1545);
        HashMap<UUID, FireballImpact> updated = new HashMap<UUID, FireballImpact>();
        for (class_1677 fb : fireballs) {
            ArrayList<class_243> pts;
            ImpactResult impact;
            class_243 pos = Compat.pos((class_1297)fb);
            class_243 vel = fb.method_18798();
            if (vel.method_1027() < 1.0E-6 || (impact = BlazeTracker.predictImpactStraight(pos, vel, expandedPlayer)) == null) continue;
            UUID id = fb.method_5667();
            FireballImpact existing = activeFireballs.get(id);
            long created = existing != null ? existing.creationTime : System.currentTimeMillis();
            ArrayList<class_243> arrayList = pts = existing != null && existing.trajectoryPoints != null ? new ArrayList<class_243>(existing.trajectoryPoints) : new ArrayList<class_243>();
            if (pts.isEmpty() || ((class_243)pts.get(pts.size() - 1)).method_1025(pos) > 0.04) {
                pts.add(pos);
            }
            FireballImpact fi = new FireballImpact(id, impact.point, impact.etaMs, created, pts, true, true);
            updated.put(id, fi);
        }
        activeFireballs.clear();
        activeFireballs.putAll(updated);
    }

    private static ImpactResult predictImpactStraight(class_243 start, class_243 velocity, class_238 expandedPlayer) {
        double speed = velocity.method_1033();
        if (speed < 1.0E-6) {
            return null;
        }
        class_243 dir = velocity.method_1029();
        class_243 end = start.method_1019(dir.method_1021(speed * 60.0));
        class_243 hit = BlazeTracker.segmentAabbIntersection(start, end, expandedPlayer);
        if (hit == null) {
            return null;
        }
        double distance = hit.method_1022(start);
        double ticks = distance / speed;
        double etaMs = ticks * 50.0;
        return new ImpactResult(hit, etaMs);
    }

    private static class_243 segmentAabbIntersection(class_243 p0, class_243 p1, class_238 b) {
        double tmp;
        double t2;
        double t1;
        double inv;
        double tMin = 0.0;
        double tMax = 1.0;
        double dx = p1.field_1352 - p0.field_1352;
        double dy = p1.field_1351 - p0.field_1351;
        double dz = p1.field_1350 - p0.field_1350;
        if (Math.abs(dx) >= 1.0E-6) {
            inv = 1.0 / dx;
            t1 = (b.field_1323 - p0.field_1352) * inv;
            t2 = (b.field_1320 - p0.field_1352) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        } else if (p0.field_1352 < b.field_1323 || p0.field_1352 > b.field_1320) {
            return null;
        }
        if (Math.abs(dy) >= 1.0E-6) {
            inv = 1.0 / dy;
            t1 = (b.field_1322 - p0.field_1351) * inv;
            t2 = (b.field_1325 - p0.field_1351) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        } else if (p0.field_1351 < b.field_1322 || p0.field_1351 > b.field_1325) {
            return null;
        }
        if (Math.abs(dz) >= 1.0E-6) {
            inv = 1.0 / dz;
            t1 = (b.field_1321 - p0.field_1350) * inv;
            t2 = (b.field_1324 - p0.field_1350) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        } else if (p0.field_1350 < b.field_1321 || p0.field_1350 > b.field_1324) {
            return null;
        }
        if (tMin < 0.0 || tMin > 1.0) {
            return null;
        }
        return new class_243(p0.field_1352 + dx * tMin, p0.field_1351 + dy * tMin, p0.field_1350 + dz * tMin);
    }

    public static List<FireballImpact> getActiveImpacts() {
        return new ArrayList<FireballImpact>(activeFireballs.values());
    }

    public static Set<UUID> getAggressiveBlazes() {
        return new HashSet<UUID>(aggressiveBlazes);
    }

    private static /* synthetic */ void lambda$tick$2(class_1657 player, class_1545 b) {
        if (BlazeTracker.isTargetingPlayer(b, player)) {
            aggressiveBlazes.add(b.method_5667());
        }
    }

    private static /* synthetic */ boolean lambda$tick$1(class_1937 world, class_1657 player, UUID uuid) {
        Iterator iterator = world.method_8390(class_1545.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
        if (iterator.hasNext()) {
            class_1545 b = (class_1545)iterator.next();
            return b.method_5805() && b.method_5858((class_1297)player) <= 4096.0;
        }
        return true;
    }
}

