/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.ArrowDetection;
import com.dodger.ArrowTrajectory;
import com.dodger.AutoDodger;
import com.dodger.AutoDodgerDebug;
import com.dodger.DodgerClient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class DodgerHud {
    private static long lastLogMs = 0L;
    private static boolean loggedOnce = false;

    public static void render(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (DodgerClient.CONFIG == null || !DodgerClient.CONFIG.hudEnabled) {
            return;
        }
        class_327 tr = client.field_1772;
        int x = DodgerClient.CONFIG.hudX;
        int y = DodgerClient.CONFIG.hudY;
        ArrayList<class_5250> lines = new ArrayList<class_5250>();
        if (!loggedOnce) {
            loggedOnce = true;
            DodgerClient.LOGGER.info("Dodger HUD render callback active");
        }
        int ping = client.method_1562() != null && client.method_1562().method_2871(client.field_1724.method_5667()) != null ? client.method_1562().method_2871(client.field_1724.method_5667()).method_2959() : 0;
        String dim = client.field_1687.method_27983().method_29177().toString();
        lines.add(class_2561.method_43470((String)"Dodger HUD ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)("[Ping: " + ping + " ms] ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)dim).method_27692(class_124.field_1063)));
        List<ArrowTrajectory> traj = ArrowDetection.getTrajectories();
        long now = System.currentTimeMillis();
        traj.removeIf(t -> t.isExpired() || !t.targetsPlayer());
        traj.sort(Comparator.comparingDouble(t -> {
            Double eta = t.getEtaMs();
            return eta == null ? Double.POSITIVE_INFINITY : eta;
        }));
        if (traj.isEmpty()) {
            lines.add(class_2561.method_43470((String)"No threats").method_27692(class_124.field_1077));
        } else {
            int shown = 0;
            for (ArrowTrajectory t2 : traj) {
                if (shown++ >= 4) break;
                Double eta = t2.getEtaMs();
                class_243 target = t2.getTargetPosition();
                String etaStr = eta == null ? "n/a" : String.format(Locale.US, "%.0f ms", eta);
                String distStr = String.format(Locale.US, "x%.1f y%.1f z%.1f", target.field_1352 - client.field_1724.method_23317(), target.field_1351 - client.field_1724.method_23318(), target.field_1350 - client.field_1724.method_23321());
                lines.add(class_2561.method_43470((String)"ETA ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(etaStr + " ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)distStr).method_27692(class_124.field_1068)));
            }
        }
        class_243 v = client.field_1724.method_18798();
        String vel = String.format(Locale.US, "v=(%.2f, %.2f, %.2f)", v.field_1352, v.field_1351, v.field_1350);
        lines.add(class_2561.method_43470((String)vel).method_27692(class_124.field_1080));
        AutoDodgerDebug dbg = AutoDodger.getDebug();
        if (dbg != null) {
            String dod = String.format(Locale.US, "dodge axis=(%.2f,%.2f,%.2f) dist=%.2f speedCap=%.2f", dbg.axis.field_1352, dbg.axis.field_1351, dbg.axis.field_1350, dbg.maxDistance, dbg.maxSpeed);
            lines.add(class_2561.method_43470((String)dod).method_27692(class_124.field_1065));
        }
        int width = 240;
        int n = lines.size();
        Objects.requireNonNull(tr);
        int height = n * (9 + 1) + 4;
        int bgColor = -2013265920;
        context.method_25294(x - 4, y - 2, x - 4 + width, y - 2 + height, bgColor);
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 t3 = (class_2561)lines.get(i);
            Objects.requireNonNull(tr);
            context.method_51439(tr, t3, x, y + i * (9 + 1), 0xFFFFFF, true);
        }
        class_5250 class_52502 = class_2561.method_43470((String)"TEST RED");
        int n2 = lines.size();
        Objects.requireNonNull(tr);
        context.method_51439(tr, (class_2561)class_52502, x, y + n2 * (9 + 1) + 5, 0xFF0000, false);
        class_5250 class_52503 = class_2561.method_43470((String)"TEST GREEN");
        int n3 = lines.size() + 1;
        Objects.requireNonNull(tr);
        context.method_51439(tr, (class_2561)class_52503, x, y + n3 * (9 + 1) + 5, 65280, false);
        class_5250 class_52504 = class_2561.method_43470((String)"TEST BLUE");
        int n4 = lines.size() + 2;
        Objects.requireNonNull(tr);
        context.method_51439(tr, (class_2561)class_52504, x, y + n4 * (9 + 1) + 5, 255, false);
        long nowMs = System.currentTimeMillis();
        if (nowMs - lastLogMs > 1000L) {
            lastLogMs = nowMs;
            int pingMs = client.method_1562() != null && client.method_1562().method_2871(client.field_1724.method_5667()) != null ? client.method_1562().method_2871(client.field_1724.method_5667()).method_2959() : 0;
            DodgerClient.LOGGER.debug("HUD tick: ping={}ms threats={} pos=({}, {}, {})", new Object[]{pingMs, traj.size(), String.format(Locale.US, "%.1f", client.field_1724.method_23317()), String.format(Locale.US, "%.1f", client.field_1724.method_23318()), String.format(Locale.US, "%.1f", client.field_1724.method_23321())});
        }
    }
}

