/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.ArrowDetection;
import com.dodger.ArrowTrajectory;
import com.dodger.AutoDodger;
import com.dodger.AutoDodgerDebug;
import com.dodger.BlazeDodger;
import com.dodger.BlazeDodgerDebug;
import com.dodger.BlazeTracker;
import com.dodger.DodgerClient;
import com.dodger.FireballImpact;
import com.dodger.GhastTracker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class DodgerHudNew {
    private static long lastLogMs = 0L;
    private static boolean loggedOnce = false;
    private static final List<class_2561> cachedLines = new ArrayList<class_2561>();

    public static void tick(class_310 client) {
        long nowMs;
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (DodgerClient.CONFIG == null || !DodgerClient.CONFIG.hudEnabled) {
            return;
        }
        if (!loggedOnce) {
            loggedOnce = true;
            DodgerClient.LOGGER.info("Dodger HUD tick active");
        }
        cachedLines.clear();
        int ping = client.method_1562() != null && client.method_1562().method_2871(client.field_1724.method_5667()) != null ? client.method_1562().method_2871(client.field_1724.method_5667()).method_2959() : 0;
        String dim = client.field_1687.method_27983().method_29177().toString();
        cachedLines.add((class_2561)class_2561.method_43470((String)"Dodger HUD ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)("[Ping: " + ping + " ms] ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)dim).method_27692(class_124.field_1063)));
        List<ArrowTrajectory> traj = ArrowDetection.getTrajectories();
        long now = System.currentTimeMillis();
        traj.removeIf(t -> t.isExpired() || !t.targetsPlayer());
        traj.sort(Comparator.comparingDouble(t -> {
            Double eta = t.getEtaMs();
            return eta == null ? Double.POSITIVE_INFINITY : eta;
        }));
        ArrayList<FireballImpact> fireballs = new ArrayList<FireballImpact>();
        fireballs.addAll(GhastTracker.getActiveImpacts());
        fireballs.addAll(BlazeTracker.getActiveImpacts());
        fireballs.removeIf(fi -> fi.isExpired() || !fi.targetsPlayer);
        fireballs.sort(Comparator.comparingDouble(fi -> {
            Double eta = fi.etaMs;
            return eta == null ? Double.POSITIVE_INFINITY : eta;
        }));
        ArrayList<Object> allThreats = new ArrayList<Object>();
        allThreats.addAll(traj);
        allThreats.addAll(fireballs);
        allThreats.sort(Comparator.comparingDouble(threat -> {
            if (threat instanceof ArrowTrajectory) {
                Double eta = ((ArrowTrajectory)threat).getEtaMs();
                return eta == null ? Double.POSITIVE_INFINITY : eta;
            }
            if (threat instanceof FireballImpact) {
                Double eta = ((FireballImpact)threat).etaMs;
                return eta == null ? Double.POSITIVE_INFINITY : eta;
            }
            return Double.POSITIVE_INFINITY;
        }));
        if (allThreats.isEmpty()) {
            cachedLines.add((class_2561)class_2561.method_43470((String)"No threats").method_27692(class_124.field_1077));
        } else {
            int shown = 0;
            for (Object e : allThreats) {
                String distStr;
                String etaStr;
                class_243 target;
                Double eta;
                if (shown++ >= 4) break;
                if (e instanceof ArrowTrajectory) {
                    ArrowTrajectory t2 = (ArrowTrajectory)e;
                    eta = t2.getEtaMs();
                    target = t2.getTargetPosition();
                    etaStr = eta == null ? "n/a" : String.format(Locale.US, "%.0f ms", eta);
                    distStr = String.format(Locale.US, "x%.1f y%.1f z%.1f", target.field_1352 - client.field_1724.method_23317(), target.field_1351 - client.field_1724.method_23318(), target.field_1350 - client.field_1724.method_23321());
                    cachedLines.add((class_2561)class_2561.method_43470((String)"Arrow ETA ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(etaStr + " ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)distStr).method_27692(class_124.field_1068)));
                    continue;
                }
                if (!(e instanceof FireballImpact)) continue;
                FireballImpact fi2 = (FireballImpact)e;
                eta = fi2.etaMs;
                target = fi2.impactPoint;
                etaStr = eta == null ? "n/a" : String.format(Locale.US, "%.0f ms", eta);
                distStr = String.format(Locale.US, "x%.1f y%.1f z%.1f", target.field_1352 - client.field_1724.method_23317(), target.field_1351 - client.field_1724.method_23318(), target.field_1350 - client.field_1724.method_23321());
                String type = fi2.trajectoryPoints.size() > 0 && fi2.trajectoryPoints.get(0) != null ? "Fireball" : "SmallFireball";
                cachedLines.add((class_2561)class_2561.method_43470((String)(type + " ETA ")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(etaStr + " ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)distStr).method_27692(class_124.field_1068)));
            }
        }
        class_243 v = client.field_1724.method_18798();
        String vel = String.format(Locale.US, "v=(%.2f, %.2f, %.2f)", v.field_1352, v.field_1351, v.field_1350);
        cachedLines.add((class_2561)class_2561.method_43470((String)vel).method_27692(class_124.field_1080));
        AutoDodgerDebug autoDodgerDebug = AutoDodger.getDebug();
        if (autoDodgerDebug != null) {
            String dod = String.format(Locale.US, "dodge axis=(%.2f,%.2f,%.2f) dist=%.2f speedCap=%.2f", autoDodgerDebug.axis.field_1352, autoDodgerDebug.axis.field_1351, autoDodgerDebug.axis.field_1350, autoDodgerDebug.maxDistance, autoDodgerDebug.maxSpeed);
            cachedLines.add((class_2561)class_2561.method_43470((String)dod).method_27692(class_124.field_1065));
        }
        if ((nowMs = System.currentTimeMillis()) - lastLogMs > 1000L) {
            lastLogMs = nowMs;
            int pingMs = client.method_1562() != null && client.method_1562().method_2871(client.field_1724.method_5667()) != null ? client.method_1562().method_2871(client.field_1724.method_5667()).method_2959() : 0;
            DodgerClient.LOGGER.debug("HUD tick: ping={}ms threats={} pos=({}, {}, {})", new Object[]{pingMs, traj.size(), String.format(Locale.US, "%.1f", client.field_1724.method_23317()), String.format(Locale.US, "%.1f", client.field_1724.method_23318()), String.format(Locale.US, "%.1f", client.field_1724.method_23321())});
        }
    }

    public static void renderHUD(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (DodgerClient.CONFIG == null || !DodgerClient.CONFIG.hudEnabled) {
            return;
        }
        class_327 tr = client.field_1772;
        int x = DodgerClient.CONFIG.hudX;
        int y = DodgerClient.CONFIG.hudY;
        Objects.requireNonNull(tr);
        int lineHeight = 9 + 2;
        int bgColor = -1879048192;
        int ping = client.method_1562() != null && client.method_1562().method_2871(client.field_1724.method_5667()) != null ? client.method_1562().method_2871(client.field_1724.method_5667()).method_2959() : 0;
        String dim = client.field_1687.method_27983().method_29177().toString();
        if (dim.contains(":")) {
            dim = dim.split(":")[1];
        }
        List<ArrowTrajectory> threats = ArrowDetection.getTrajectories();
        threats.removeIf(t -> t.isExpired() || !t.targetsPlayer());
        threats.sort(Comparator.comparingDouble(t -> {
            Double eta = t.getEtaMs();
            return eta == null ? Double.POSITIVE_INFINITY : eta;
        }));
        ArrayList<FireballImpact> fireballs = new ArrayList<FireballImpact>();
        fireballs.addAll(GhastTracker.getActiveImpacts());
        fireballs.addAll(BlazeTracker.getActiveImpacts());
        fireballs.removeIf(fi -> fi.isExpired() || !fi.targetsPlayer);
        fireballs.sort(Comparator.comparingDouble(fi -> {
            Double eta = fi.etaMs;
            return eta == null ? Double.POSITIVE_INFINITY : eta;
        }));
        ArrayList<Object> allThreats = new ArrayList<Object>();
        allThreats.addAll(threats);
        allThreats.addAll(fireballs);
        allThreats.sort(Comparator.comparingDouble(threat -> {
            if (threat instanceof ArrowTrajectory) {
                Double eta = ((ArrowTrajectory)threat).getEtaMs();
                return eta == null ? Double.POSITIVE_INFINITY : eta;
            }
            if (threat instanceof FireballImpact) {
                Double eta = ((FireballImpact)threat).etaMs;
                return eta == null ? Double.POSITIVE_INFINITY : eta;
            }
            return Double.POSITIVE_INFINITY;
        }));
        class_243 v = client.field_1724.method_18798();
        String velocity = String.format(Locale.US, "v=(%.2f, %.2f, %.2f)", v.field_1352, v.field_1351, v.field_1350);
        AutoDodgerDebug dodge = AutoDodger.getDebug();
        String dodgeInfo = dodge != null ? String.format(Locale.US, "dodge: axis=(%.2f,%.2f,%.2f) dist=%.2f", dodge.axis.field_1352, dodge.axis.field_1351, dodge.axis.field_1350, dodge.maxDistance) : "dodge: inactive";
        BlazeDodgerDebug blazeDodge = BlazeDodger.getDebug();
        String blazeDodgeInfo = blazeDodge != null ? String.format(Locale.US, "blaze dodge: axis=(%.2f,%.2f,%.2f) dist=%.2f", blazeDodge.axis.field_1352, blazeDodge.axis.field_1351, blazeDodge.axis.field_1350, blazeDodge.distance) : null;
        ArrayList<Object> linesList = new ArrayList<Object>();
        int hits = DodgerClient.CONFIG.hitsTaken;
        linesList.add("Dodger HUD [Ping: " + ping + "ms] " + dim + " | Hits: " + hits);
        if (allThreats.isEmpty()) {
            linesList.add("No threats");
        } else {
            int shown = 0;
            for (Object e : allThreats) {
                String relPos;
                String etaStr;
                Double eta;
                if (shown++ >= 3) break;
                if (e instanceof ArrowTrajectory) {
                    ArrowTrajectory t2 = (ArrowTrajectory)e;
                    eta = t2.getEtaMs();
                    class_243 class_2432 = t2.getTargetPosition();
                    etaStr = eta == null ? "n/a" : String.format(Locale.US, "%.0fms", eta);
                    relPos = String.format(Locale.US, "(%.1f, %.1f, %.1f)", class_2432.field_1352 - client.field_1724.method_23317(), class_2432.field_1351 - client.field_1724.method_23318(), class_2432.field_1350 - client.field_1724.method_23321());
                    linesList.add("Arrow ETA " + etaStr + " " + relPos);
                    continue;
                }
                if (!(e instanceof FireballImpact)) continue;
                FireballImpact fi2 = (FireballImpact)e;
                eta = fi2.etaMs;
                class_243 class_2433 = fi2.impactPoint;
                etaStr = eta == null ? "n/a" : String.format(Locale.US, "%.0fms", eta);
                relPos = String.format(Locale.US, "(%.1f, %.1f, %.1f)", class_2433.field_1352 - client.field_1724.method_23317(), class_2433.field_1351 - client.field_1724.method_23318(), class_2433.field_1350 - client.field_1724.method_23321());
                String type = fi2.trajectoryPoints.size() > 0 && fi2.trajectoryPoints.get(0) != null ? "Fireball" : "SmallFireball";
                linesList.add(type + " ETA " + etaStr + " " + relPos);
            }
        }
        linesList.add(velocity);
        linesList.add(dodgeInfo);
        if (blazeDodgeInfo != null) {
            linesList.add(blazeDodgeInfo);
        }
        String[] lines = linesList.toArray(new String[0]);
        int maxWidth = 0;
        for (String string : lines) {
            int width = tr.method_1727(string);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int n = maxWidth + 16;
        int bgHeight = lines.length * lineHeight + 8;
        context.method_25294(x - 4, y - 4, x + n, y + bgHeight, bgColor);
        for (int i = 0; i < lines.length; ++i) {
            int n2 = -1;
            String line = lines[i];
            if (i == 0) {
                n2 = -256;
            } else if (line.startsWith("No threats")) {
                n2 = -16711936;
            } else if (line.startsWith("Arrow ETA")) {
                n2 = -48060;
            } else if (line.startsWith("Fireball ETA") || line.startsWith("SmallFireball ETA")) {
                n2 = -30652;
            } else if (line.startsWith("v=")) {
                n2 = -16711681;
            } else if (line.startsWith("dodge:") || line.startsWith("blaze dodge:")) {
                n2 = dodge != null || blazeDodge != null ? -10496 : -5592406;
            }
            context.method_51439(tr, (class_2561)class_2561.method_43470((String)line), x, y + i * lineHeight, n2, true);
        }
    }
}

