/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.EvokerTrajectory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1564;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class EvokerDetection {
    private static final Map<UUID, EvokerTrajectory> active = new HashMap<UUID, EvokerTrajectory>();
    private static final double RANGE = 48.0;

    public static void detect(class_310 client) {
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            return;
        }
        if (!EvokerDetection.isImminent((class_1937)world, (class_1657)player)) {
            active.clear();
            return;
        }
        List evokers = world.method_8390(class_1564.class, player.method_5829().method_1014(48.0), class_1309::method_5805);
        HashMap<UUID, EvokerTrajectory> newMap = new HashMap<UUID, EvokerTrajectory>();
        for (EvokerTrajectory ex : active.values()) {
            if (ex.isExpired()) continue;
            newMap.put(ex.evokerUuid, ex);
        }
        for (class_1564 e : evokers) {
            UUID id = e.method_5667();
            class_243 start = Compat.pos((class_1297)e).method_1031(0.0, (double)e.method_5751(), 0.0);
            class_243 end = player.method_5829().method_1005();
            int segments = 12;
            ArrayList<class_243> pts = new ArrayList<class_243>(segments + 1);
            for (int i = 0; i <= segments; ++i) {
                double t = (double)i / (double)segments;
                pts.add(new class_243(start.field_1352 + (end.field_1352 - start.field_1352) * t, start.field_1351 + (end.field_1351 - start.field_1351) * t, start.field_1350 + (end.field_1350 - start.field_1350) * t));
            }
            class_238 playerBox = player.method_5829().method_1014(0.2);
            boolean targetsPlayer = true;
            long created = System.currentTimeMillis();
            newMap.put(id, new EvokerTrajectory(id, pts, end, targetsPlayer, created));
        }
        active.clear();
        active.putAll(newMap);
    }

    private static boolean isImminent(class_1937 world, class_1657 player) {
        double range = 4.0;
        for (class_1669 f : world.method_8390(class_1669.class, player.method_5829().method_1014(range), e -> true)) {
            double dx = f.method_23317() - player.method_23317();
            double dz = f.method_23321() - player.method_23321();
            double dXZ = Math.sqrt(dx * dx + dz * dz);
            int age = f.field_6012;
            if (dXZ <= 2.2 && age >= 4 && age <= 20) {
                return true;
            }
            if (!f.method_5829().method_1014(0.1).method_994(player.method_5829())) continue;
            return true;
        }
        return false;
    }

    public static List<EvokerTrajectory> getTrajectories() {
        return new ArrayList<EvokerTrajectory>(active.values());
    }

    public static void clearTrajectories() {
        active.clear();
    }
}

