/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.EmergencyResult;
import com.dodger.FireballImpact;
import com.dodger.JumpResult;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class GhastDodger {
    private static final double STEP_DISTANCE = 1.0;
    private static final double STEP_IMPULSE = 0.55;
    private static final double STEP_MAX_SPEED = 0.75;
    private static final double MIN_MOTION = 0.05;
    private static GhastSession session;
    private static int consecutiveFailedMoves;
    private static final int MAX_CONSECUTIVE_FAILURES = 3;
    private static boolean emergencyMode;
    private static class_243 lockedDirection;
    private static int sameDodgeCount;
    private static long lastJumpTime;
    private static final long JUMP_COOLDOWN_MS = 500L;

    private static boolean isFireBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_22089);
    }

    private static boolean containsFireAtPosition(class_1937 world, class_238 playerBox) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(playerBox.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(playerBox.field_1320 - 1.0E-6));
        int minY = class_3532.method_15357((double)(playerBox.field_1322 + 1.0E-6));
        int maxY = class_3532.method_15357((double)(playerBox.field_1325 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(playerBox.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(playerBox.field_1324 - 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    pos.method_10103(x, y, z);
                    if (!GhastDodger.isFireBlock(world.method_8320((class_2338)pos))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void clear() {
        session = null;
        consecutiveFailedMoves = 0;
        emergencyMode = false;
        lockedDirection = null;
        sameDodgeCount = 0;
        lastJumpTime = 0L;
    }

    public static void tick(class_310 client, List<FireballImpact> impacts) {
        class_243 candidate;
        long currentTime;
        double dotProd;
        double score;
        class_243 chosenAxis;
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        if (impacts == null || impacts.isEmpty()) {
            session = null;
            return;
        }
        class_243 pPos = Compat.pos((class_1297)player);
        boolean inDanger = false;
        for (FireballImpact fi : impacts) {
            double dx = pPos.field_1352 - fi.impactPoint.field_1352;
            double dz = pPos.field_1350 - fi.impactPoint.field_1350;
            double dist = Math.sqrt(dx * dx + dz * dz);
            if (!(dist < 2.01)) continue;
            inDanger = true;
            break;
        }
        if (!inDanger) {
            session = null;
            lockedDirection = null;
            sameDodgeCount = 0;
            return;
        }
        FireballImpact target = null;
        double bestKey = Double.MAX_VALUE;
        for (FireballImpact fi : impacts) {
            double dx = pPos.field_1352 - fi.impactPoint.field_1352;
            double dz = pPos.field_1350 - fi.impactPoint.field_1350;
            double dist = Math.sqrt(dx * dx + dz * dz);
            if (!(dist < 2.01)) continue;
            double d = fi.etaMs != null ? fi.etaMs : dist;
            double key = d;
            if (!(key < bestKey)) continue;
            bestKey = key;
            target = fi;
        }
        if (target == null) {
            session = null;
            return;
        }
        class_243 center = target.impactPoint;
        double dx = pPos.field_1352 - center.field_1352;
        double dz = pPos.field_1350 - center.field_1350;
        double dist = Math.sqrt(dx * dx + dz * dz);
        class_243 traj = GhastDodger.getFireballDirectionXZ(target);
        class_243 v = player.method_18798();
        class_243 vXZ = new class_243(v.field_1352, 0.0, v.field_1350);
        double motionWeight = 0.2;
        if (lockedDirection != null) {
            chosenAxis = lockedDirection;
            if (++sameDodgeCount > 5) {
                lockedDirection = null;
                sameDodgeCount = 0;
            }
        } else if (traj != null && traj.method_1027() > 1.0E-6) {
            class_243 away;
            class_243[] candidates;
            class_243 up = new class_243(0.0, 1.0, 0.0);
            class_243 left = up.method_1036(traj).method_1029();
            class_243 right = traj.method_1036(up).method_1029();
            chosenAxis = null;
            double bestScore = -1.7976931348623157E308;
            for (class_243 axis : candidates = new class_243[]{left, right}) {
                class_243 candPos = pPos.method_1019(axis.method_1021(1.0));
                if (!GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, candPos, impacts)) continue;
                double ndx = candPos.field_1352 - center.field_1352;
                double ndz = candPos.field_1350 - center.field_1350;
                double newDist = Math.sqrt(ndx * ndx + ndz * ndz);
                double distanceGain = newDist - dist;
                double motionBonus = 0.0;
                if (vXZ.method_1027() > 0.0025000000000000005) {
                    motionBonus = 0.05 * vXZ.method_1029().method_1026(axis);
                }
                if (!((score = distanceGain + motionBonus) > bestScore)) continue;
                bestScore = score;
                chosenAxis = axis;
            }
            if (chosenAxis == null && (away = new class_243(dx, 0.0, dz)).method_1027() > 1.0E-6) {
                class_243[] blendAngles;
                away = away.method_1029();
                for (class_243 angle : blendAngles = new class_243[]{left.method_1021(0.75).method_1019(away.method_1021(0.25)).method_1029(), right.method_1021(0.75).method_1019(away.method_1021(0.25)).method_1029(), left.method_1021(0.5).method_1019(away.method_1021(0.5)).method_1029(), right.method_1021(0.5).method_1019(away.method_1021(0.5)).method_1029()}) {
                    double parallelness;
                    double perpendicularBonus;
                    double ndz;
                    double ndx;
                    double newDist;
                    double score2;
                    class_243 candPos = pPos.method_1019(angle.method_1021(1.0));
                    if (!GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, candPos, impacts) || !((score2 = (newDist = Math.sqrt((ndx = candPos.field_1352 - center.field_1352) * ndx + (ndz = candPos.field_1350 - center.field_1350) * ndz)) - dist + (perpendicularBonus = (1.0 - (parallelness = Math.abs(angle.method_1026(traj)))) * 2.0)) > bestScore)) continue;
                    bestScore = score2;
                    chosenAxis = angle;
                }
            }
        } else {
            chosenAxis = null;
        }
        if (chosenAxis == null) {
            class_243 m;
            double parallelness;
            class_243 away = new class_243(dx, 0.0, dz);
            away = away.method_1027() < 1.0E-6 ? new class_243(1.0, 0.0, 0.0) : away.method_1029();
            if (traj != null && traj.method_1027() > 1.0E-6 && (parallelness = Math.abs(away.method_1026(traj))) > 0.7) {
                away = GhastDodger.rotateYaw(away, Math.toRadians(60.0));
            }
            if (vXZ.method_1027() > 0.0025000000000000005 && (m = vXZ.method_1029()).method_1026(away) < -0.3) {
                away = GhastDodger.rotateYaw(away, Math.toRadians(30.0));
            }
            chosenAxis = away;
        }
        if (session != null && chosenAxis != null && lockedDirection == null && (dotProd = GhastDodger.session.axisXZ.method_1026(chosenAxis)) < 0.0) {
            lockedDirection = GhastDodger.session.axisXZ;
            sameDodgeCount = 0;
            chosenAxis = lockedDirection;
        }
        if (session == null || GhastDodger.session.axisXZ.method_1026(chosenAxis) < 0.8) {
            session = new GhastSession(chosenAxis, pPos);
        }
        boolean canJump = (currentTime = System.currentTimeMillis()) - lastJumpTime >= 500L;
        boolean shouldJump = false;
        if (canJump) {
            class_243 candidateY1 = pPos.method_1019(GhastDodger.session.axisXZ.method_1021(GhastDodger.session.maxStepDistance)).method_1031(0.0, 1.0, 0.0);
            if (GhastDodger.isSafeTargetAtHeight((class_1937)world, (class_1657)player, candidateY1, impacts)) {
                session = new GhastSession(GhastDodger.session.axisXZ, pPos, GhastDodger.session.maxStepDistance, true);
                candidate = candidateY1;
                shouldJump = true;
            } else {
                candidate = pPos.method_1019(GhastDodger.session.axisXZ.method_1021(GhastDodger.session.maxStepDistance));
                if (!GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, candidate, impacts)) {
                    candidate = null;
                } else {
                    shouldJump = false;
                }
            }
        } else {
            candidate = pPos.method_1019(GhastDodger.session.axisXZ.method_1021(GhastDodger.session.maxStepDistance));
            if (!GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, candidate, impacts)) {
                candidate = null;
            }
            shouldJump = false;
        }
        if (candidate == null) {
            class_243 left = GhastDodger.rotateYaw(GhastDodger.session.axisXZ, Math.toRadians(15.0));
            class_243 right = GhastDodger.rotateYaw(GhastDodger.session.axisXZ, -Math.toRadians(15.0));
            if (canJump) {
                class_243 candLY1 = pPos.method_1019(left.method_1021(GhastDodger.session.maxStepDistance)).method_1031(0.0, 1.0, 0.0);
                class_243 candRY1 = pPos.method_1019(right.method_1021(GhastDodger.session.maxStepDistance)).method_1031(0.0, 1.0, 0.0);
                boolean okLY1 = GhastDodger.isSafeTargetAtHeight((class_1937)world, (class_1657)player, candLY1, impacts);
                boolean okRY1 = GhastDodger.isSafeTargetAtHeight((class_1937)world, (class_1657)player, candRY1, impacts);
                if (okLY1 && (!okRY1 || candLY1.method_1025(center) > candRY1.method_1025(center))) {
                    session = new GhastSession(left, pPos, GhastDodger.session.maxStepDistance, true);
                    candidate = candLY1;
                    shouldJump = true;
                } else if (okRY1) {
                    session = new GhastSession(right, pPos, GhastDodger.session.maxStepDistance, true);
                    candidate = candRY1;
                    shouldJump = true;
                }
            }
            if (candidate == null) {
                class_243 candL = pPos.method_1019(left.method_1021(GhastDodger.session.maxStepDistance));
                class_243 candR = pPos.method_1019(right.method_1021(GhastDodger.session.maxStepDistance));
                boolean okL = GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, candL, impacts);
                boolean okR = GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, candR, impacts);
                if (okL && (!okR || candL.method_1025(center) > candR.method_1025(center))) {
                    session = new GhastSession(left, pPos);
                    candidate = candL;
                    shouldJump = false;
                } else if (okR) {
                    session = new GhastSession(right, pPos);
                    candidate = candR;
                    shouldJump = false;
                }
            }
            if (candidate == null) {
                class_243[] angles = new class_243[]{GhastDodger.rotateYaw(GhastDodger.session.axisXZ, Math.toRadians(30.0)), GhastDodger.rotateYaw(GhastDodger.session.axisXZ, -Math.toRadians(30.0)), GhastDodger.rotateYaw(GhastDodger.session.axisXZ, Math.toRadians(45.0)), GhastDodger.rotateYaw(GhastDodger.session.axisXZ, -Math.toRadians(45.0)), GhastDodger.rotateYaw(GhastDodger.session.axisXZ, Math.toRadians(60.0)), GhastDodger.rotateYaw(GhastDodger.session.axisXZ, -Math.toRadians(60.0))};
                class_243 bestAngleCandidate = null;
                double bestAngleScore = -1.7976931348623157E308;
                boolean bestRequiresJump = false;
                class_243 bestAngle = null;
                for (class_243 angle : angles) {
                    double candDist;
                    class_243 cand;
                    double candDist2;
                    double score3;
                    class_243 candY1 = pPos.method_1019(angle.method_1021(GhastDodger.session.maxStepDistance)).method_1031(0.0, 1.0, 0.0);
                    if (GhastDodger.isSafeTargetAtHeight((class_1937)world, (class_1657)player, candY1, impacts) && (score3 = (candDist2 = candY1.method_1025(center)) + 100.0) > bestAngleScore) {
                        bestAngleScore = score3;
                        bestAngleCandidate = candY1;
                        bestAngle = angle;
                        bestRequiresJump = true;
                    }
                    if (!GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, cand = pPos.method_1019(angle.method_1021(GhastDodger.session.maxStepDistance)), impacts) || !((score = (candDist = cand.method_1025(center))) > bestAngleScore)) continue;
                    bestAngleScore = score;
                    bestAngleCandidate = cand;
                    bestAngle = angle;
                    bestRequiresJump = false;
                }
                if (bestAngleCandidate != null) {
                    session = new GhastSession(bestAngle, pPos, GhastDodger.session.maxStepDistance, bestRequiresJump);
                    candidate = bestAngleCandidate;
                } else {
                    class_243 extendedSafePos = GhastDodger.findExtendedSafePosition((class_1937)world, (class_1657)player, center, 2.0, impacts);
                    if (extendedSafePos != null) {
                        class_243 toSafe = extendedSafePos.method_1020(pPos);
                        if (toSafe.method_1027() > 1.0E-6) {
                            boolean candidateSafe;
                            boolean requiresJump = extendedSafePos.field_1351 > pPos.field_1351 + 0.5;
                            class_243 horizontalDirection = new class_243(toSafe.field_1352, 0.0, toSafe.field_1350).method_1029();
                            class_243 extendedCandidate = pPos.method_1019(horizontalDirection.method_1021(GhastDodger.session.maxStepDistance));
                            if (requiresJump) {
                                extendedCandidate = extendedCandidate.method_1031(0.0, 1.0, 0.0);
                            }
                            boolean bl = candidateSafe = requiresJump ? GhastDodger.isSafeTargetAtHeight((class_1937)world, (class_1657)player, extendedCandidate, impacts) : GhastDodger.isSafeTarget((class_1937)world, (class_1657)player, extendedCandidate, impacts);
                            if (candidateSafe) {
                                session = new GhastSession(horizontalDirection, pPos, GhastDodger.session.maxStepDistance, requiresJump);
                                candidate = extendedCandidate;
                            }
                        }
                    } else {
                        EmergencyResult emergency = GhastDodger.findEmergencyEscape((class_1937)world, (class_1657)player, center, 2.0, pPos);
                        if (emergency != null) {
                            session = new GhastSession(emergency.direction, pPos, emergency.stepDistance);
                            candidate = pPos.method_1019(emergency.direction.method_1021(emergency.stepDistance));
                            emergencyMode = true;
                            consecutiveFailedMoves = 0;
                            lockedDirection = null;
                            sameDodgeCount = 0;
                        } else {
                            ++consecutiveFailedMoves;
                            return;
                        }
                    }
                }
            }
        }
        class_243 axis = GhastDodger.session.axisXZ;
        double comp = v.method_1026(axis);
        double compNew = class_3532.method_15350((double)(comp + 0.55), (double)-0.75, (double)0.75);
        class_243 vNew = v.method_1019(axis.method_1021(compNew - comp));
        if (GhastDodger.session.needsJump && player.method_24828() && !GhastDodger.session.hasJumped) {
            vNew = new class_243(vNew.field_1352, 0.42, vNew.field_1350);
            GhastDodger.session.hasJumped = true;
            lastJumpTime = System.currentTimeMillis();
        }
        player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
        consecutiveFailedMoves = 0;
        double traveledNow = Compat.pos((class_1297)player).method_1020(GhastDodger.session.startPos).method_1026(axis);
        GhastDodger.session.traveled = Math.max(GhastDodger.session.traveled, traveledNow);
        double newDx = Compat.pos((class_1297)player).field_1352 - center.field_1352;
        double newDz = Compat.pos((class_1297)player).field_1350 - center.field_1350;
        double newDist = Math.sqrt(newDx * newDx + newDz * newDz);
        if (newDist > dist + 0.3 && lockedDirection != null) {
            lockedDirection = null;
            sameDodgeCount = 0;
        }
        if (GhastDodger.session.traveled >= GhastDodger.session.maxStepDistance) {
            class_243 v2 = player.method_18798();
            double c = v2.method_1026(axis);
            player.method_18800(v2.field_1352 - axis.field_1352 * c, v2.field_1351, v2.field_1350 - axis.field_1350 * c);
            session = new GhastSession(axis, Compat.pos((class_1297)player), GhastDodger.session.maxStepDistance);
        }
    }

    private static JumpResult tryJumpEscape(class_1937 world, class_1657 player, class_243 blastCenter, class_243 preferredAxis, class_243 currentPos, double stepDistance, List<FireballImpact> allImpacts) {
        class_243 direction;
        double angleRad;
        int angleDeg;
        JumpResult bestResult = null;
        double bestScore = -1.7976931348623157E308;
        double currentDist = Math.sqrt(Math.pow(currentPos.field_1352 - blastCenter.field_1352, 2.0) + Math.pow(currentPos.field_1350 - blastCenter.field_1350, 2.0));
        for (angleDeg = 0; angleDeg < 360; angleDeg += 45) {
            double[] distances;
            angleRad = Math.toRadians(angleDeg);
            direction = new class_243(Math.cos(angleRad), 0.0, Math.sin(angleRad)).method_1029();
            for (double dist : distances = new double[]{stepDistance, stepDistance * 1.5, stepDistance * 2.0}) {
                class_243 target = currentPos.method_1019(direction.method_1021(dist)).method_1031(0.0, 1.0, 0.0);
                if (!GhastDodger.isSafeTargetAtHeight(world, player, target, allImpacts)) continue;
                double targetDist = Math.sqrt(Math.pow(target.field_1352 - blastCenter.field_1352, 2.0) + Math.pow(target.field_1350 - blastCenter.field_1350, 2.0));
                double distanceScore = targetDist - currentDist;
                boolean outsideBlastRadius = targetDist > 2.5;
                double radiusBonus = outsideBlastRadius ? 10.0 : 0.0;
                double reachabilityBonus = (3.0 - dist) * 0.5;
                double score = distanceScore + radiusBonus + reachabilityBonus;
                if (outsideBlastRadius && score > bestScore) {
                    bestScore = score;
                    bestResult = new JumpResult(direction, target);
                    continue;
                }
                if (outsideBlastRadius || !(distanceScore > 0.5) || !(score > bestScore)) continue;
                bestScore = score;
                bestResult = new JumpResult(direction, target);
            }
        }
        if (bestResult != null) {
            return bestResult;
        }
        for (angleDeg = 0; angleDeg < 360; angleDeg += 30) {
            double targetDist;
            angleRad = Math.toRadians(angleDeg);
            direction = new class_243(Math.cos(angleRad), 0.0, Math.sin(angleRad)).method_1029();
            class_243 target = currentPos.method_1019(direction.method_1021(stepDistance)).method_1031(0.0, 1.0, 0.0);
            if (!GhastDodger.isSafeTargetAtHeight(world, player, target, allImpacts) || !((targetDist = Math.sqrt(Math.pow(target.field_1352 - blastCenter.field_1352, 2.0) + Math.pow(target.field_1350 - blastCenter.field_1350, 2.0))) >= currentDist - 0.5)) continue;
            return new JumpResult(direction, target);
        }
        return null;
    }

    private static boolean isSafeTargetAtHeight(class_1937 world, class_1657 player, class_243 target, List<FireballImpact> allImpacts) {
        class_243 delta;
        if (!GhastDodger.isAwayFromAllFireballs(target, allImpacts)) {
            return false;
        }
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (GhastDodger.containsFireAtPosition(world, shifted)) {
            return false;
        }
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!GhastDodger.isJumpPathClear(world, player, playerBox, delta)) {
            return false;
        }
        return GhastDodger.isFootprintSafe(world, shifted);
    }

    private static boolean isJumpPathClear(class_1937 world, class_1657 player, class_238 startBox, class_243 delta) {
        double verticalDelta = delta.field_1351;
        if (verticalDelta > 0.0) {
            class_238 upwardBox = startBox.method_989(0.0, verticalDelta, 0.0);
            if (!world.method_8587((class_1297)player, upwardBox)) {
                return false;
            }
            if (GhastDodger.containsFireAtPosition(world, upwardBox)) {
                return false;
            }
        }
        double STEP = 0.25;
        double horizontalLen = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        if (horizontalLen < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(horizontalLen / 0.25));
        class_243 horizontalStep = new class_243(delta.field_1352 / (double)steps, 0.0, delta.field_1350 / (double)steps);
        class_238 box = startBox.method_989(0.0, Math.max(0.0, verticalDelta), 0.0);
        for (int i = 1; i <= steps; ++i) {
            if (!world.method_8587((class_1297)player, box = box.method_997(horizontalStep))) {
                return false;
            }
            if (!GhastDodger.containsFireAtPosition(world, box)) continue;
            return false;
        }
        return true;
    }

    private static class_243 getFireballDirectionXZ(FireballImpact target) {
        if (target == null || target.trajectoryPoints == null || target.trajectoryPoints.size() < 2) {
            return null;
        }
        int n = target.trajectoryPoints.size();
        class_243 a = target.trajectoryPoints.get(n - 2);
        class_243 b = target.trajectoryPoints.get(n - 1);
        class_243 d = b.method_1020(a);
        class_243 xz = new class_243(d.field_1352, 0.0, d.field_1350);
        if (xz.method_1027() < 1.0E-6) {
            return null;
        }
        return xz.method_1029();
    }

    private static class_243 rotateYaw(class_243 vec, double radians) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return new class_243(vec.field_1352 * cos - vec.field_1350 * sin, 0.0, vec.field_1352 * sin + vec.field_1350 * cos).method_1029();
    }

    private static boolean isAwayFromAllFireballs(class_243 target, List<FireballImpact> allImpacts) {
        if (allImpacts == null || allImpacts.isEmpty()) {
            return true;
        }
        for (FireballImpact impact : allImpacts) {
            double dx = target.field_1352 - impact.impactPoint.field_1352;
            double dz = target.field_1350 - impact.impactPoint.field_1350;
            double dist = Math.sqrt(dx * dx + dz * dz);
            if (!(dist < 2.5)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafeTarget(class_1937 world, class_1657 player, class_243 target) {
        return GhastDodger.isSafeTarget(world, player, target, null);
    }

    private static boolean isSafeTarget(class_1937 world, class_1657 player, class_243 target, List<FireballImpact> allImpacts) {
        class_243 delta;
        if (allImpacts != null && !GhastDodger.isAwayFromAllFireballs(target, allImpacts)) {
            return false;
        }
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (GhastDodger.containsFireAtPosition(world, shifted)) {
            return false;
        }
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!GhastDodger.isPathClear(world, player, playerBox, delta)) {
            return false;
        }
        return GhastDodger.isFootprintSafe(world, shifted);
    }

    private static boolean isPathClear(class_1937 world, class_1657 player, class_238 startBox, class_243 delta) {
        double STEP = 0.2;
        double len = delta.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(len / 0.2));
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_238 box = startBox;
        for (int i = 1; i <= steps; ++i) {
            if (!world.method_8587((class_1297)player, box = box.method_997(step))) {
                return false;
            }
            if (!GhastDodger.containsFireAtPosition(world, box)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFootprintSafe(class_1937 world, class_238 shifted) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 1; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_2680 blockState = world.method_8320((class_2338)pos);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (blockState.method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static class_243 findExtendedSafePosition(class_1937 world, class_1657 player, class_243 blastCenter, double blastRadius, List<FireballImpact> allImpacts) {
        int[] yOffsets;
        class_243 playerPos = Compat.pos((class_1297)player);
        class_243 bestPos = null;
        double bestScore = Double.MAX_VALUE;
        int searchRadius = 8;
        int playerX = class_3532.method_15357((double)playerPos.field_1352);
        int playerZ = class_3532.method_15357((double)playerPos.field_1350);
        for (int yOffset : yOffsets = new int[]{2, 1, 0, -1}) {
            for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
                for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                    double distToBlast;
                    boolean safe;
                    if (dx == 0 && dz == 0 && yOffset == 0) continue;
                    class_243 testPos = new class_243((double)(playerX + dx) + 0.5, playerPos.field_1351 + (double)yOffset, (double)(playerZ + dz) + 0.5);
                    boolean bl = safe = yOffset > 0 ? GhastDodger.isSafeTargetAtHeight(world, player, testPos, allImpacts) : GhastDodger.isSafeTarget(world, player, testPos, allImpacts);
                    if (!safe || !((distToBlast = testPos.method_1022(blastCenter)) > blastRadius + 0.5)) continue;
                    double distToPlayer = testPos.method_1022(playerPos);
                    double heightBonus = 0.0;
                    if (yOffset == 2) {
                        heightBonus = -20.0;
                    } else if (yOffset == 1) {
                        heightBonus = -15.0;
                    } else if (yOffset < 0) {
                        heightBonus = 10.0;
                    }
                    double score = distToPlayer + distToBlast * 0.1 + heightBonus;
                    if (!(score < bestScore)) continue;
                    bestScore = score;
                    bestPos = testPos;
                }
            }
        }
        return bestPos;
    }

    private static EmergencyResult findEmergencyEscape(class_1937 world, class_1657 player, class_243 blastCenter, double blastRadius, class_243 playerPos) {
        class_243 testPos;
        class_243 direction;
        int angle;
        class_243 away = playerPos.method_1020(blastCenter).method_1029();
        for (int distance = 2; distance <= 3; ++distance) {
            class_243 testPos2 = playerPos.method_1019(away.method_1021((double)distance));
            if (!GhastDodger.isEmergencySafeTarget(world, player, testPos2, blastCenter, blastRadius)) continue;
            return new EmergencyResult(away, distance);
        }
        for (angle = 0; angle < 360; angle += 45) {
            double radians = Math.toRadians(angle);
            direction = new class_243(Math.cos(radians), 0.0, Math.sin(radians));
            testPos = playerPos.method_1019(direction.method_1021(2.0));
            double currentDist = playerPos.method_1022(blastCenter);
            double newDist = testPos.method_1022(blastCenter);
            if (!(newDist > currentDist) || !GhastDodger.isMinimallySafeTarget(world, player, testPos)) continue;
            return new EmergencyResult(direction, 2.0);
        }
        for (angle = 0; angle < 360; angle += 30) {
            double radians = Math.toRadians(angle);
            direction = new class_243(Math.cos(radians), 0.0, Math.sin(radians));
            testPos = playerPos.method_1019(direction.method_1021(1.5));
            if (!GhastDodger.isLastResortSafeTarget(world, player, testPos, blastCenter, blastRadius)) continue;
            return new EmergencyResult(direction, 1.5);
        }
        return null;
    }

    private static boolean isEmergencySafeTarget(class_1937 world, class_1657 player, class_243 target, class_243 blastCenter, double blastRadius) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (GhastDodger.containsFireAtPosition(world, shifted)) {
            return false;
        }
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!GhastDodger.isPathClear(world, player, playerBox, delta)) {
            return false;
        }
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isMinimallySafeTarget(class_1937 world, class_1657 player, class_243 target) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (GhastDodger.containsFireAtPosition(world, shifted)) {
            return false;
        }
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isLastResortSafeTarget(class_1937 world, class_1657 player, class_243 target, class_243 blastCenter, double blastRadius) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (GhastDodger.containsFireAtPosition(world, shifted)) {
            return false;
        }
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        double currentDist = Compat.pos((class_1297)player).method_1022(blastCenter);
        double newDist = target.method_1022(blastCenter);
        return newDist > currentDist + 0.5;
    }

    static {
        consecutiveFailedMoves = 0;
        emergencyMode = false;
        lockedDirection = null;
        sameDodgeCount = 0;
        lastJumpTime = 0L;
    }

    @Environment(value=EnvType.CLIENT)
    private static class GhastSession {
        final class_243 axisXZ;
        final class_243 startPos;
        double traveled;
        final double maxStepDistance;
        final boolean needsJump;
        boolean hasJumped;

        GhastSession(class_243 axisXZ, class_243 startPos) {
            this(axisXZ, startPos, 1.0, false);
        }

        GhastSession(class_243 axisXZ, class_243 startPos, double maxStepDistance) {
            this(axisXZ, startPos, maxStepDistance, false);
        }

        GhastSession(class_243 axisXZ, class_243 startPos, double maxStepDistance, boolean needsJump) {
            this.axisXZ = axisXZ;
            this.startPos = startPos;
            this.maxStepDistance = maxStepDistance;
            this.traveled = 0.0;
            this.needsJump = needsJump;
            this.hasJumped = false;
        }
    }
}

