/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.FireballImpact;
import com.dodger.GhastDodger;
import com.dodger.ImpactResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class GhastTracker {
    private static final Set<UUID> aggressiveGhasts = new HashSet<UUID>();
    private static final double DETECTION_RANGE = 64.0;
    private static final double GRAVITY = 0.0;
    private static final double DRAG = 0.99;
    private static final int MAX_TICKS_AHEAD = 60;
    private static final int SUBSTEPS_PER_TICK = 4;
    public static final double BLAST_RADIUS = 2.0;
    private static final Map<UUID, FireballImpact> activeFireballs = new HashMap<UUID, FireballImpact>();
    private static final double EPS = 1.0E-6;

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!DodgerClient.CONFIG.ghastDodgeEnabled && !DodgerClient.CONFIG.ghastDebugEnabled) {
            aggressiveGhasts.clear();
            activeFireballs.clear();
            GhastDodger.clear();
            return;
        }
        if (client.field_1761 == null || client.field_1761.method_2920() == null || !client.field_1761.method_2920().method_8388()) {
            aggressiveGhasts.clear();
            activeFireballs.clear();
            GhastDodger.clear();
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List all = world.method_8390(class_1571.class, player.method_5829().method_1014(64.0), class_1309::method_5805);
        if (world.method_8510() % 300L == 0L && !all.isEmpty()) {
            DodgerClient.LOGGER.debug("Found {} ghasts in range", (Object)all.isEmpty());
        }
        aggressiveGhasts.removeIf(arg_0 -> GhastTracker.lambda$tick$1((class_1937)world, (class_1657)player, arg_0));
        world.method_8390(class_1571.class, player.method_5829().method_1014(64.0), class_1309::method_5805).forEach(arg_0 -> GhastTracker.lambda$tick$2((class_1657)player, arg_0));
        if (DodgerClient.CONFIG.ghastDebugEnabled || DodgerClient.CONFIG.ghastDodgeEnabled) {
            GhastTracker.detectFireballs(client);
        }
        if (DodgerClient.CONFIG.ghastDodgeEnabled) {
            GhastDodger.tick(client, GhastTracker.getActiveImpacts());
        }
    }

    private static boolean isTargetingPlayer(class_1571 ghast, class_1657 player) {
        class_1309 target = ghast.method_5968();
        if (target != null && target.equals((Object)player)) {
            return true;
        }
        if (ghast.method_6510() && ghast.method_6057((class_1297)player)) {
            return true;
        }
        return ghast.method_6057((class_1297)player) && ghast.method_5858((class_1297)player) <= 256.0;
    }

    private static void detectFireballs(class_310 client) {
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List fireballs = world.method_8390(class_1674.class, player.method_5829().method_1014(64.0), f -> {
            if (!f.method_5805() || !(f.method_24921() instanceof class_1571)) {
                return false;
            }
            boolean hasVelocity = f.method_18798().method_1027() > 0.1;
            boolean farFromOwner = f.method_24921() == null || f.method_5858(f.method_24921()) > 9.0;
            return hasVelocity && farFromOwner;
        });
        HashMap<UUID, FireballImpact> newMap = new HashMap<UUID, FireballImpact>();
        for (FireballImpact fi : activeFireballs.values()) {
            if (fi.isExpired()) continue;
            newMap.put(fi.fireballUuid, fi);
        }
        for (class_1674 fireball : fireballs) {
            class_243 pos;
            UUID id = fireball.method_5667();
            FireballImpact existing = activeFireballs.get(id);
            if (existing == null || existing.trajectoryPoints == null || existing.trajectoryPoints.isEmpty()) {
                pos = Compat.pos((class_1297)fireball);
                ArrayList<class_243> initialPoints = new ArrayList<class_243>();
                initialPoints.add(pos);
                FireballImpact placeholder = new FireballImpact(id, pos, null, System.currentTimeMillis(), initialPoints, false, false);
                newMap.put(id, placeholder);
                continue;
            }
            pos = Compat.pos((class_1297)fireball);
            class_243 vel = fireball.method_18798();
            ImpactResult groundImpact = GhastTracker.predictGroundImpact(pos, vel, (class_1937)world);
            class_238 playerBox = player.method_5829().method_1014(0.2);
            ImpactResult playerImpact = GhastTracker.predictImpactWithAABB(pos, vel, playerBox);
            ImpactResult impact = null;
            boolean targetsPlayer = false;
            if (playerImpact != null && (groundImpact == null || playerImpact.etaMs <= groundImpact.etaMs)) {
                impact = playerImpact;
                targetsPlayer = true;
            } else if (groundImpact != null) {
                impact = groundImpact;
                targetsPlayer = false;
            }
            class_243 impactPos = impact != null ? impact.point : pos;
            Double etaMs = impact != null ? Double.valueOf(impact.etaMs) : null;
            long created = existing != null ? existing.creationTime : System.currentTimeMillis();
            ArrayList<Object> points = existing != null && existing.trajectoryPoints != null ? new ArrayList<class_243>(existing.trajectoryPoints) : new ArrayList<class_243>();
            if (points.isEmpty() || ((class_243)points.get(points.size() - 1)).method_1025(pos) > 0.05) {
                points.add(pos);
            }
            FireballImpact updated = new FireballImpact(id, impactPos, etaMs, created, points, targetsPlayer, true);
            newMap.put(id, updated);
        }
        activeFireballs.clear();
        activeFireballs.putAll(newMap);
    }

    private static ImpactResult predictGroundImpact(class_243 startPos, class_243 startVel, class_1937 world) {
        class_243 pos = startPos;
        class_243 vel = startVel;
        for (int tick = 0; tick < 60; ++tick) {
            class_243 nextPos = pos.method_1019(vel);
            if (nextPos.field_1351 <= 0.0) {
                double fraction = (0.0 - pos.field_1351) / (nextPos.field_1351 - pos.field_1351);
                class_243 groundImpact = new class_243(pos.field_1352 + (nextPos.field_1352 - pos.field_1352) * fraction, 0.0, pos.field_1350 + (nextPos.field_1350 - pos.field_1350) * fraction);
                double etaMs = (double)tick * 50.0;
                return new ImpactResult(groundImpact, etaMs);
            }
            pos = nextPos;
            vel = vel.method_1021(0.99);
        }
        return null;
    }

    private static ImpactResult predictImpactWithAABB(class_243 startPos, class_243 startVel, class_238 targetBox) {
        if (targetBox.method_1006(startPos)) {
            return new ImpactResult(startPos, 0.0);
        }
        class_243 pos = startPos;
        class_243 vel = startVel;
        double dt = 0.25;
        int maxSteps = 240;
        for (int i = 0; i < 240; ++i) {
            class_243 prevPos = pos;
            pos = pos.method_1019(vel.method_1021(0.25));
            vel = vel.method_1031(0.0, -0.0, 0.0);
            double dragPow = Math.pow(0.99, 0.25);
            vel = vel.method_1021(dragPow);
            class_243 hit = GhastTracker.segmentAabbIntersection(prevPos, pos, targetBox);
            if (hit == null) continue;
            double tTicks = (double)(i + 1) * 0.25;
            double etaMs = tTicks * 50.0;
            return new ImpactResult(hit, etaMs);
        }
        return null;
    }

    private static class_243 segmentAabbIntersection(class_243 p0, class_243 p1, class_238 b) {
        double tmp;
        double t2;
        double t1;
        double inv;
        double tMin = 0.0;
        double tMax = 1.0;
        double dx = p1.field_1352 - p0.field_1352;
        double dy = p1.field_1351 - p0.field_1351;
        double dz = p1.field_1350 - p0.field_1350;
        if (Math.abs(dx) < 1.0E-6) {
            if (p0.field_1352 < b.field_1323 || p0.field_1352 > b.field_1320) {
                return null;
            }
        } else {
            inv = 1.0 / dx;
            t1 = (b.field_1323 - p0.field_1352) * inv;
            t2 = (b.field_1320 - p0.field_1352) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (Math.abs(dy) < 1.0E-6) {
            if (p0.field_1351 < b.field_1322 || p0.field_1351 > b.field_1325) {
                return null;
            }
        } else {
            inv = 1.0 / dy;
            t1 = (b.field_1322 - p0.field_1351) * inv;
            t2 = (b.field_1325 - p0.field_1351) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (Math.abs(dz) < 1.0E-6) {
            if (p0.field_1350 < b.field_1321 || p0.field_1350 > b.field_1324) {
                return null;
            }
        } else {
            inv = 1.0 / dz;
            t1 = (b.field_1321 - p0.field_1350) * inv;
            t2 = (b.field_1324 - p0.field_1350) * inv;
            if (t1 > t2) {
                tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (tMin < 0.0 || tMin > 1.0) {
            return null;
        }
        return new class_243(p0.field_1352 + dx * tMin, p0.field_1351 + dy * tMin, p0.field_1350 + dz * tMin);
    }

    public static List<FireballImpact> getActiveImpacts() {
        long currentTime = System.currentTimeMillis();
        return activeFireballs.values().stream().filter(fi -> fi.isReady && currentTime - fi.creationTime >= 300L).collect(Collectors.toList());
    }

    public static Set<UUID> getAggressiveGhasts() {
        return new HashSet<UUID>(aggressiveGhasts);
    }

    private static /* synthetic */ void lambda$tick$2(class_1657 player, class_1571 g) {
        if (GhastTracker.isTargetingPlayer(g, player)) {
            aggressiveGhasts.add(g.method_5667());
        }
    }

    private static /* synthetic */ boolean lambda$tick$1(class_1937 world, class_1657 player, UUID uuid) {
        Iterator iterator = world.method_8390(class_1571.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
        if (iterator.hasNext()) {
            class_1571 g = (class_1571)iterator.next();
            return g.method_5805() && g.method_5858((class_1297)player) <= 4096.0;
        }
        return true;
    }
}

