/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.ArrowDetection;
import com.dodger.ArrowTrajectory;
import com.dodger.AutoDodger;
import com.dodger.AutoDodgerDebug;
import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class HitTracker {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static float lastHealth = -1.0f;
    private static long lastHitMillis = 0L;
    private static final long HIT_DEBOUNCE_MS = 250L;

    public static void tick(class_310 client) {
        long now;
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_746 p = client.field_1724;
        float health = p.method_6032() + p.method_6067();
        if (lastHealth < 0.0f) {
            lastHealth = health;
            return;
        }
        if (health < lastHealth - 0.05f && (now = System.currentTimeMillis()) - lastHitMillis > 250L) {
            lastHitMillis = now;
            HitTracker.onPlayerHit(client, lastHealth, health);
        }
        lastHealth = health;
    }

    private static void onPlayerHit(class_310 client, float prev, float now) {
        try {
            if (DodgerClient.CONFIG != null) {
                ++DodgerClient.CONFIG.hitsTaken;
                DodgerClient.CONFIG.save();
            }
            LinkedHashMap<String, Object> snap = new LinkedHashMap<String, Object>();
            snap.put("timestamp", Instant.now().toString());
            snap.put("epochMs", System.currentTimeMillis());
            snap.put("prevHealth", Float.valueOf(prev));
            snap.put("newHealth", Float.valueOf(now));
            snap.put("hitsTaken", DodgerClient.CONFIG != null ? Integer.valueOf(DodgerClient.CONFIG.hitsTaken) : null);
            int ping = 0;
            try {
                class_640 ple;
                class_634 nh = client.method_1562();
                class_640 class_6402 = ple = nh != null ? nh.method_2871(client.field_1724.method_5667()) : null;
                if (ple != null) {
                    ping = ple.method_2959();
                }
            }
            catch (Exception nh) {
                // empty catch block
            }
            snap.put("pingMs", ping);
            String dim = client.field_1687.method_27983().method_29177().toString();
            snap.put("dimension", dim);
            class_243 pos = Compat.pos((class_1297)client.field_1724);
            class_243 vel = client.field_1724.method_18798();
            snap.put("pos", List.of(Double.valueOf(HitTracker.round(pos.field_1352)), Double.valueOf(HitTracker.round(pos.field_1351)), Double.valueOf(HitTracker.round(pos.field_1350))));
            snap.put("vel", List.of(Double.valueOf(HitTracker.round(vel.field_1352)), Double.valueOf(HitTracker.round(vel.field_1351)), Double.valueOf(HitTracker.round(vel.field_1350))));
            ArrayList threatsOut = new ArrayList();
            try {
                List<ArrowTrajectory> threats = ArrowDetection.getTrajectories();
                threats.removeIf(t -> t.isExpired() || !t.targetsPlayer());
                threats.sort(Comparator.comparingDouble(t -> {
                    Double eta = t.getEtaMs();
                    return eta == null ? Double.POSITIVE_INFINITY : eta;
                }));
                int cap = Math.min(5, threats.size());
                for (int i = 0; i < cap; ++i) {
                    ArrowTrajectory t2 = threats.get(i);
                    LinkedHashMap<String, Object> tmap = new LinkedHashMap<String, Object>();
                    Double eta = t2.getEtaMs();
                    class_243 target = t2.getTargetPosition();
                    tmap.put("etaMs", eta);
                    tmap.put("target", target != null ? List.of(Double.valueOf(HitTracker.round(target.field_1352)), Double.valueOf(HitTracker.round(target.field_1351)), Double.valueOf(HitTracker.round(target.field_1350))) : null);
                    threatsOut.add(tmap);
                }
            }
            catch (Exception threats) {
                // empty catch block
            }
            snap.put("threats", threatsOut);
            AutoDodgerDebug dbg = AutoDodger.getDebug();
            if (dbg != null) {
                LinkedHashMap<String, Object> dm = new LinkedHashMap<String, Object>();
                dm.put("axis", List.of(Double.valueOf(HitTracker.round(dbg.axis.field_1352)), Double.valueOf(HitTracker.round(dbg.axis.field_1351)), Double.valueOf(HitTracker.round(dbg.axis.field_1350))));
                dm.put("maxDistance", HitTracker.round(dbg.maxDistance));
                dm.put("maxSpeed", HitTracker.round(dbg.maxSpeed));
                snap.put("dodge", dm);
            } else {
                snap.put("dodge", null);
            }
            HitTracker.appendJsonLine(HitTracker.getHitsLogPath(client), GSON.toJson(snap));
            client.execute(() -> {
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Dodger: registered hit #" + (DodgerClient.CONFIG != null ? DodgerClient.CONFIG.hitsTaken : 0))), true);
                }
            });
        }
        catch (Exception e) {
            DodgerClient.LOGGER.warn("HitTracker error: {}", (Object)e.getMessage());
        }
    }

    private static double round(double v) {
        return (double)Math.round(v * 100.0) / 100.0;
    }

    private static void appendJsonLine(Path path, String jsonLine) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);){
                w.write(jsonLine);
                w.write("\n");
            }
        }
        catch (IOException e) {
            DodgerClient.LOGGER.warn("Failed writing hit log: {}", (Object)e.getMessage());
        }
    }

    private static Path getHitsLogPath(class_310 client) {
        return client.field_1697.toPath().resolve("config").resolve("dodger-hits.jsonl");
    }

    public static void reset() {
        lastHealth = -1.0f;
        lastHitMillis = 0L;
    }
}

