/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.ShulkerTrajectory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1678;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ShulkerDetection {
    private static final Map<UUID, ShulkerTrajectory> activeTrajectories = new HashMap<UUID, ShulkerTrajectory>();
    private static final double HIT_RADIUS = 0.75;

    public static void detect(class_310 client, Set<UUID> trackedBullets) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_238 playerBox = player.method_5829();
        class_238 expandedPlayerBox = playerBox.method_1014(0.25);
        HashMap<UUID, ShulkerTrajectory> newTraj = new HashMap<UUID, ShulkerTrajectory>();
        for (ShulkerTrajectory existing : activeTrajectories.values()) {
            if (existing.isExpired()) continue;
            newTraj.put(existing.getBulletUuid(), existing);
        }
        for (UUID id : trackedBullets) {
            List list = world.method_8390(class_1678.class, playerBox.method_1014(64.0), b -> b.method_5667().equals(id) && b.method_5805());
            for (class_1678 bullet : list) {
                boolean overlap;
                class_243 pos = Compat.pos((class_1297)bullet);
                class_243 vel = bullet.method_18798();
                class_238 hitBox = new class_238(pos.field_1352 - 0.75, pos.field_1351 - 0.75, pos.field_1350 - 0.75, pos.field_1352 + 0.75, pos.field_1351 + 0.75, pos.field_1350 + 0.75);
                boolean targetsPlayer = false;
                class_243 collisionPoint = null;
                boolean intersects = hitBox.method_994(expandedPlayerBox);
                boolean bl = overlap = intersects || ShulkerDetection.boxesOverlap(expandedPlayerBox, hitBox);
                if (overlap) {
                    targetsPlayer = true;
                    collisionPoint = ShulkerDetection.computeOverlapCenter(hitBox, playerBox);
                    if (collisionPoint == null) {
                        collisionPoint = playerBox.method_1005();
                    }
                }
                ShulkerTrajectory t = new ShulkerTrajectory(id, pos, vel, hitBox, targetsPlayer, collisionPoint != null ? collisionPoint : pos, System.currentTimeMillis());
                newTraj.put(id, t);
            }
        }
        activeTrajectories.clear();
        activeTrajectories.putAll(newTraj);
    }

    private static boolean boxesOverlap(class_238 a, class_238 b) {
        boolean ox = a.field_1320 > b.field_1323 && a.field_1323 < b.field_1320;
        boolean oy = a.field_1325 > b.field_1322 && a.field_1322 < b.field_1325;
        boolean oz = a.field_1324 > b.field_1321 && a.field_1321 < b.field_1324;
        return ox && oy && oz;
    }

    private static class_243 computeOverlapCenter(class_238 a, class_238 b) {
        if (!a.method_994(b)) {
            return null;
        }
        double minX = Math.max(a.field_1323, b.field_1323);
        double maxX = Math.min(a.field_1320, b.field_1320);
        double minY = Math.max(a.field_1322, b.field_1322);
        double maxY = Math.min(a.field_1325, b.field_1325);
        double minZ = Math.max(a.field_1321, b.field_1321);
        double maxZ = Math.min(a.field_1324, b.field_1324);
        return new class_243((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
    }

    public static List<ShulkerTrajectory> getTrajectories() {
        return new ArrayList<ShulkerTrajectory>(activeTrajectories.values());
    }

    public static void clear() {
        activeTrajectories.clear();
    }
}

