/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.ArrowDetection;
import com.dodger.AutoDodger;
import com.dodger.DodgerClient;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1627;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class StrayTracker {
    private static final Set<UUID> aggressiveStrays = new HashSet<UUID>();
    private static final double DETECTION_RANGE = 64.0;

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!DodgerClient.CONFIG.strayDodgeEnabled) {
            aggressiveStrays.clear();
            ArrowDetection.clearTrajectories();
            AutoDodger.clear();
            return;
        }
        if (client.field_1761 == null || client.field_1761.method_2920() == null || !client.field_1761.method_2920().method_8388()) {
            aggressiveStrays.clear();
            ArrowDetection.clearTrajectories();
            AutoDodger.clear();
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List allStrays = world.method_8390(class_1627.class, player.method_5829().method_1014(64.0), stray -> stray.method_5805());
        if (world.method_8510() % 300L == 0L && !allStrays.isEmpty()) {
            DodgerClient.LOGGER.debug("Found {} strays in range", (Object)allStrays.size());
        }
        aggressiveStrays.removeIf(arg_0 -> StrayTracker.lambda$tick$2((class_1937)world, (class_1657)player, arg_0));
        world.method_8390(class_1627.class, player.method_5829().method_1014(64.0), stray -> stray.method_5805()).forEach(arg_0 -> StrayTracker.lambda$tick$4((class_1657)player, arg_0));
        ArrowDetection.detectArrows(client);
        AutoDodger.tick(client);
    }

    private static boolean isTargetingPlayer(class_1627 stray, class_1657 player) {
        class_1309 target = stray.method_5968();
        if (target != null && target.equals((Object)player)) {
            return true;
        }
        if (stray.method_6510() && stray.method_6057((class_1297)player)) {
            return true;
        }
        return stray.method_6057((class_1297)player) && stray.method_5858((class_1297)player) <= 256.0;
    }

    public static boolean isStrayAggressive(UUID strayUuid) {
        return aggressiveStrays.contains(strayUuid);
    }

    public static Set<UUID> getAggressiveStrays() {
        return new HashSet<UUID>(aggressiveStrays);
    }

    private static /* synthetic */ void lambda$tick$4(class_1657 player, class_1627 stray) {
        if (StrayTracker.isTargetingPlayer(stray, player)) {
            aggressiveStrays.add(stray.method_5667());
        }
    }

    private static /* synthetic */ boolean lambda$tick$2(class_1937 world, class_1657 player, UUID uuid) {
        Iterator iterator = world.method_8390(class_1627.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
        if (iterator.hasNext()) {
            class_1627 stray = (class_1627)iterator.next();
            return stray.method_5805() && stray.method_5858((class_1297)player) <= 4096.0;
        }
        return true;
    }
}

