/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.ImpactResult;
import com.dodger.TridentTrajectory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1551;
import net.minecraft.class_1685;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class TridentDetection {
    private static final Map<UUID, TridentTrajectory> activeTrajectories = new HashMap<UUID, TridentTrajectory>();
    private static final double DETECTION_RANGE = 48.0;
    private static final double GRAVITY = 0.05;
    private static final double DRAG = 0.99;
    private static final int MAX_TICKS_AHEAD = 60;
    private static final int SUBSTEPS_PER_TICK = 4;
    private static final double EPS = 1.0E-6;

    public static void detectTridents(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List tridents = world.method_8390(class_1685.class, player.method_5829().method_1014(48.0), t -> t.method_5805() && t.method_24921() instanceof class_1551);
        HashMap<UUID, TridentTrajectory> newMap = new HashMap<UUID, TridentTrajectory>();
        for (TridentTrajectory ex : activeTrajectories.values()) {
            if (ex.isExpired()) continue;
            newMap.put(ex.tridentUuid, ex);
        }
        for (class_1685 t2 : tridents) {
            class_238 playerBox;
            ImpactResult impact;
            ArrayList<class_243> pts;
            UUID id = t2.method_5667();
            TridentTrajectory existing = activeTrajectories.get(id);
            class_243 pos = Compat.pos((class_1297)t2);
            class_243 vel = t2.method_18798();
            ArrayList<Object> arrayList = pts = existing != null ? new ArrayList<class_243>(existing.points) : new ArrayList();
            if (pts.isEmpty() || ((class_243)pts.get(pts.size() - 1)).method_1025(pos) > 0.05) {
                pts.add(pos);
            }
            boolean targetsPlayer = (impact = TridentDetection.predictImpactWithAABB(pos, vel, playerBox = player.method_5829().method_1014(0.2))) != null;
            long created = existing != null ? existing.creationTime : System.currentTimeMillis();
            newMap.put(id, new TridentTrajectory(id, pts, impact != null ? impact.point : pos, targetsPlayer, created, impact != null ? Double.valueOf(impact.etaMs) : null));
        }
        activeTrajectories.clear();
        activeTrajectories.putAll(newMap);
    }

    private static ImpactResult predictImpactWithAABB(class_243 startPos, class_243 startVel, class_238 target) {
        if (target.method_1006(startPos)) {
            return new ImpactResult(startPos, 0.0);
        }
        class_243 pos = startPos;
        class_243 vel = startVel;
        double dt = 0.25;
        int max = 240;
        for (int i = 0; i < max; ++i) {
            class_243 prev = pos;
            pos = pos.method_1019(vel.method_1021(dt));
            vel = vel.method_1031(0.0, -0.05 * dt, 0.0).method_1021(Math.pow(0.99, dt));
            class_243 hit = TridentDetection.segmentAabbIntersection(prev, pos, target);
            if (hit == null) continue;
            return new ImpactResult(hit, (double)(i + 1) * dt * 50.0);
        }
        return null;
    }

    private static class_243 segmentAabbIntersection(class_243 p0, class_243 p1, class_238 b) {
        double t;
        double t2;
        double t1;
        double inv;
        double tMin = 0.0;
        double tMax = 1.0;
        double dx = p1.field_1352 - p0.field_1352;
        double dy = p1.field_1351 - p0.field_1351;
        double dz = p1.field_1350 - p0.field_1350;
        if (Math.abs(dx) < 1.0E-6) {
            if (p0.field_1352 < b.field_1323 || p0.field_1352 > b.field_1320) {
                return null;
            }
        } else {
            inv = 1.0 / dx;
            t1 = (b.field_1323 - p0.field_1352) * inv;
            t2 = (b.field_1320 - p0.field_1352) * inv;
            if (t1 > t2) {
                t = t1;
                t1 = t2;
                t2 = t;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (Math.abs(dy) < 1.0E-6) {
            if (p0.field_1351 < b.field_1322 || p0.field_1351 > b.field_1325) {
                return null;
            }
        } else {
            inv = 1.0 / dy;
            t1 = (b.field_1322 - p0.field_1351) * inv;
            t2 = (b.field_1325 - p0.field_1351) * inv;
            if (t1 > t2) {
                t = t1;
                t1 = t2;
                t2 = t;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (Math.abs(dz) < 1.0E-6) {
            if (p0.field_1350 < b.field_1321 || p0.field_1350 > b.field_1324) {
                return null;
            }
        } else {
            inv = 1.0 / dz;
            t1 = (b.field_1321 - p0.field_1350) * inv;
            t2 = (b.field_1324 - p0.field_1350) * inv;
            if (t1 > t2) {
                t = t1;
                t1 = t2;
                t2 = t;
            }
            if ((tMin = Math.max(tMin, t1)) > (tMax = Math.min(tMax, t2))) {
                return null;
            }
        }
        if (tMin < 0.0 || tMin > 1.0) {
            return null;
        }
        return new class_243(p0.field_1352 + dx * tMin, p0.field_1351 + dy * tMin, p0.field_1350 + dz * tMin);
    }

    public static List<TridentTrajectory> getTrajectories() {
        return new ArrayList<TridentTrajectory>(activeTrajectories.values());
    }

    public static void clearTrajectories() {
        activeTrajectories.clear();
    }
}

