/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.VexTrajectory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1634;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class VexDetection {
    private static final Map<UUID, VexTrajectory> activeTrajectories = new HashMap<UUID, VexTrajectory>();
    private static final double HIT_BOX_RADIUS = 1.5;

    public static void detect(class_310 client, Set<UUID> aggressiveVexes) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_238 playerBox = player.method_5829();
        class_238 expandedPlayerBox = playerBox.method_1014(0.5);
        HashMap<UUID, VexTrajectory> newTrajectories = new HashMap<UUID, VexTrajectory>();
        for (VexTrajectory existing : activeTrajectories.values()) {
            if (existing.isExpired()) continue;
            newTrajectories.put(existing.getVexUuid(), existing);
        }
        for (UUID vexId : aggressiveVexes) {
            List vexList = world.method_8390(class_1634.class, playerBox.method_1014(32.0), vex -> vex.method_5667().equals(vexId) && vex.method_5805());
            for (class_1634 vex2 : vexList) {
                class_243 vexPos = Compat.pos((class_1297)vex2);
                class_243 vexVelocity = vex2.method_18798();
                boolean isCharging = VexDetection.isVexCharging(vex2);
                boolean isAttacking = vex2.method_6510() || isCharging;
                class_243 vexCenter = vexPos.method_1031(0.0, 0.4, 0.0);
                class_238 vexHitBox = new class_238(vexCenter.field_1352 - 1.5, vexCenter.field_1351 - 1.5, vexCenter.field_1350 - 1.5, vexCenter.field_1352 + 1.5, vexCenter.field_1351 + 1.5, vexCenter.field_1350 + 1.5);
                boolean targetsPlayer = false;
                class_243 collisionPoint = null;
                if (isAttacking) {
                    boolean boxesIntersect = vexHitBox.method_994(expandedPlayerBox);
                    boolean playerInsideVexBox = VexDetection.isBoxInside(expandedPlayerBox, vexHitBox);
                    boolean bl = targetsPlayer = boxesIntersect || playerInsideVexBox;
                    if (targetsPlayer && (collisionPoint = VexDetection.calculateCollisionPoint(vexHitBox, playerBox)) == null) {
                        collisionPoint = playerBox.method_1005();
                    }
                }
                VexTrajectory trajectory = new VexTrajectory(vexId, vexPos, vexVelocity, vexHitBox, isAttacking, targetsPlayer, collisionPoint != null ? collisionPoint : vexPos, System.currentTimeMillis());
                newTrajectories.put(vexId, trajectory);
            }
        }
        activeTrajectories.clear();
        activeTrajectories.putAll(newTrajectories);
    }

    private static boolean isBoxInside(class_238 box1, class_238 box2) {
        boolean overlapX = box1.field_1320 > box2.field_1323 && box1.field_1323 < box2.field_1320;
        boolean overlapY = box1.field_1325 > box2.field_1322 && box1.field_1322 < box2.field_1325;
        boolean overlapZ = box1.field_1324 > box2.field_1321 && box1.field_1321 < box2.field_1324;
        return overlapX && overlapY && overlapZ;
    }

    private static class_243 calculateCollisionPoint(class_238 vexBox, class_238 playerBox) {
        if (!vexBox.method_994(playerBox)) {
            return null;
        }
        double overlapMinX = Math.max(vexBox.field_1323, playerBox.field_1323);
        double overlapMaxX = Math.min(vexBox.field_1320, playerBox.field_1320);
        double overlapMinY = Math.max(vexBox.field_1322, playerBox.field_1322);
        double overlapMaxY = Math.min(vexBox.field_1325, playerBox.field_1325);
        double overlapMinZ = Math.max(vexBox.field_1321, playerBox.field_1321);
        double overlapMaxZ = Math.min(vexBox.field_1324, playerBox.field_1324);
        return new class_243((overlapMinX + overlapMaxX) / 2.0, (overlapMinY + overlapMaxY) / 2.0, (overlapMinZ + overlapMaxZ) / 2.0);
    }

    public static List<VexTrajectory> getTrajectories() {
        return new ArrayList<VexTrajectory>(activeTrajectories.values());
    }

    private static boolean isVexCharging(class_1634 vex) {
        try {
            Class<class_1634> vexClass = class_1634.class;
            Field flagsField = vexClass.getDeclaredField("VEX_FLAGS");
            flagsField.setAccessible(true);
            class_2940 vexFlags = (class_2940)flagsField.get(null);
            byte flags = (Byte)vex.method_5841().method_12789(vexFlags);
            return (flags & 1) != 0;
        }
        catch (Exception e) {
            if (DodgerClient.CONFIG.vexDebugEnabled) {
                DodgerClient.LOGGER.error("Failed to access VEX_FLAGS via reflection", (Throwable)e);
            }
            return false;
        }
    }

    public static void clear() {
        activeTrajectories.clear();
    }
}

