/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.ImpactResult;
import com.dodger.PotionImpact;
import com.dodger.WitchDodger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1640;
import net.minecraft.class_1657;
import net.minecraft.class_1686;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class WitchTracker {
    private static final Set<UUID> aggressiveWitches = new HashSet<UUID>();
    private static final double DETECTION_RANGE = 64.0;
    private static final double GRAVITY = 0.03;
    private static final double DRAG = 0.99;
    private static final int MAX_TICKS_AHEAD = 60;
    private static final int SUBSTEPS_PER_TICK = 4;
    public static final double SPLASH_RADIUS = 4.0;
    private static final Map<UUID, PotionImpact> activePotions = new HashMap<UUID, PotionImpact>();
    private static final double EPS = 1.0E-6;

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (client.field_1761 == null || client.field_1761.method_2920() == null || !client.field_1761.method_2920().method_8388()) {
            aggressiveWitches.clear();
            activePotions.clear();
            WitchDodger.clear();
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List all = world.method_8390(class_1640.class, player.method_5829().method_1014(64.0), class_1309::method_5805);
        if (world.method_8510() % 300L == 0L && !all.isEmpty()) {
            DodgerClient.LOGGER.debug("Found {} witches in range", (Object)all.size());
        }
        aggressiveWitches.removeIf(arg_0 -> WitchTracker.lambda$tick$1((class_1937)world, (class_1657)player, arg_0));
        world.method_8390(class_1640.class, player.method_5829().method_1014(64.0), class_1309::method_5805).forEach(arg_0 -> WitchTracker.lambda$tick$2((class_1657)player, arg_0));
        if (DodgerClient.CONFIG.witchDebugEnabled || DodgerClient.CONFIG.witchDodgeEnabled) {
            WitchTracker.detectPotions(client);
        }
        if (DodgerClient.CONFIG.witchDodgeEnabled) {
            WitchDodger.tick(client, WitchTracker.getActiveImpacts());
        }
    }

    private static boolean isTargetingPlayer(class_1640 witch, class_1657 player) {
        class_1309 target = witch.method_5968();
        if (target != null && target.equals((Object)player)) {
            return true;
        }
        if (witch.method_6510() && witch.method_6057((class_1297)player)) {
            return true;
        }
        return witch.method_6057((class_1297)player) && witch.method_5858((class_1297)player) <= 256.0;
    }

    private static void detectPotions(class_310 client) {
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List potions = world.method_8390(class_1686.class, player.method_5829().method_1014(64.0), p -> p.method_5805() && p.method_24921() instanceof class_1640);
        HashMap<UUID, PotionImpact> newMap = new HashMap<UUID, PotionImpact>();
        for (PotionImpact pi : activePotions.values()) {
            if (pi.isExpired()) continue;
            newMap.put(pi.potionUuid, pi);
        }
        for (class_1686 potion : potions) {
            class_243 vel;
            UUID id = potion.method_5667();
            PotionImpact existing = activePotions.get(id);
            class_243 pos = Compat.pos((class_1297)potion);
            ImpactResult impact = WitchTracker.predictImpact(pos, vel = potion.method_18798(), (class_1937)world);
            class_243 impactPos = impact != null ? impact.point : pos;
            Double etaMs = impact != null ? Double.valueOf(impact.etaMs) : null;
            long created = existing != null ? existing.creationTime : System.currentTimeMillis();
            ArrayList<Object> points = existing != null && existing.trajectoryPoints != null ? new ArrayList<class_243>(existing.trajectoryPoints) : new ArrayList<class_243>();
            if (points.isEmpty() || ((class_243)points.get(points.size() - 1)).method_1025(pos) > 0.05) {
                points.add(pos);
            }
            PotionImpact updated = new PotionImpact(id, impactPos, etaMs, created, points);
            newMap.put(id, updated);
        }
        activePotions.clear();
        activePotions.putAll(newMap);
    }

    private static ImpactResult predictImpact(class_243 startPos, class_243 startVel, class_1937 world) {
        class_243 pos = startPos;
        class_243 vel = startVel;
        double dt = 0.25;
        int maxSteps = 240;
        for (int i = 0; i < 240; ++i) {
            class_243 prev = pos;
            pos = pos.method_1019(vel.method_1021(0.25));
            vel = vel.method_1031(0.0, -0.0075, 0.0).method_1021(Math.pow(0.99, 0.25));
            if (!world.method_8320(new class_2338(class_3532.method_15357((double)pos.field_1352), class_3532.method_15357((double)pos.field_1351), class_3532.method_15357((double)pos.field_1350))).method_26220((class_1922)world, new class_2338(class_3532.method_15357((double)pos.field_1352), class_3532.method_15357((double)pos.field_1351), class_3532.method_15357((double)pos.field_1350))).method_1110()) {
                double tTicks = (double)(i + 1) * 0.25;
                return new ImpactResult(pos, tTicks * 50.0);
            }
            if (!(pos.field_1351 <= Math.floor(pos.field_1351))) continue;
            double tTicks = (double)(i + 1) * 0.25;
            return new ImpactResult(new class_243(pos.field_1352, Math.floor(pos.field_1351), pos.field_1350), tTicks * 50.0);
        }
        return null;
    }

    public static List<PotionImpact> getActiveImpacts() {
        return new ArrayList<PotionImpact>(activePotions.values());
    }

    public static Set<UUID> getAggressiveWitches() {
        return new HashSet<UUID>(aggressiveWitches);
    }

    private static /* synthetic */ void lambda$tick$2(class_1657 player, class_1640 w) {
        if (WitchTracker.isTargetingPlayer(w, player)) {
            aggressiveWitches.add(w.method_5667());
        }
    }

    private static /* synthetic */ boolean lambda$tick$1(class_1937 world, class_1657 player, UUID uuid) {
        Iterator iterator = world.method_8390(class_1640.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
        if (iterator.hasNext()) {
            class_1640 w = (class_1640)iterator.next();
            return w.method_5805() && w.method_5858((class_1297)player) <= 4096.0;
        }
        return true;
    }
}

