/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.BlazeDodgerDebug;
import com.dodger.Compat;
import com.dodger.DodgerClient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1545;
import net.minecraft.class_1677;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BlazeDodger {
    private static final double FIREBALL_RADIUS = 0.2;
    private static final double PLAYER_SAFE_PADDING = 0.05;
    private static final int MAX_PATH_TICKS = 60;
    private static final double BASE_DODGE = 1.0;
    private static final double DODGE_INCREMENT = 0.5;
    private static final double MAX_TOTAL_DODGE = 3.0;
    private static final int MAX_DODGE_STEPS = 4;
    private static final double IMPULSE = 0.85;
    private static final double MAX_LATERAL_SPEED = 1.2;
    private static final double MOVE_BIAS_THRESHOLD = 0.05;
    private static BlazeDodgerDebug lastDebug = null;

    public static void clear() {
        lastDebug = null;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!DodgerClient.CONFIG.blazeDodgeEnabled) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        List fireballs = world.method_8390(class_1677.class, player.method_5829().method_1014(64.0), f -> f.method_5805() && f.method_18798().method_1027() > 0.05 && f.method_24921() instanceof class_1545);
        if (fireballs.isEmpty()) {
            lastDebug = null;
            return;
        }
        ArrayList<Threat> threats = new ArrayList<Threat>();
        class_238 playerBox = BlazeDodger.expandPlayerBox(player.method_5829());
        for (class_1677 fb : fireballs) {
            Threat t;
            class_243 pos = Compat.pos((class_1297)fb);
            class_243 vel = fb.method_18798();
            if (vel.method_1027() < 1.0E-6 || (t = BlazeDodger.predictThreat(pos, vel, playerBox)) == null) continue;
            threats.add(t);
        }
        if (threats.isEmpty()) {
            lastDebug = null;
            return;
        }
        threats.sort(Comparator.comparingDouble(th -> th.etaMs));
        Threat primary = (Threat)threats.get(0);
        class_243 horizDir = primary.direction.method_1029();
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 right = up.method_1036(horizDir).method_1029();
        class_243 left = horizDir.method_1036(up).method_1029();
        class_243 startPos = Compat.pos((class_1297)player);
        double totalPlanned = 0.0;
        class_243 chosenAxis = null;
        class_243 cumulativeOffset = class_243.field_1353;
        double attemptDistance = 1.0;
        class_243 vel = player.method_18798();
        class_243 horizVel = new class_243(vel.field_1352, 0.0, vel.field_1350);
        double horizSpeed = horizVel.method_1033();
        double leftPref = horizSpeed > 1.0E-6 ? horizVel.method_1029().method_1026(left) : 0.0;
        double rightPref = horizSpeed > 1.0E-6 ? horizVel.method_1029().method_1026(right) : 0.0;
        double playerHeight = playerBox.field_1325 - playerBox.field_1322;
        for (int step = 0; step < 4 && totalPlanned < 3.0; ++step) {
            class_243 candLeft = startPos.method_1019(cumulativeOffset).method_1019(left.method_1021(attemptDistance));
            class_243 candRight = startPos.method_1019(cumulativeOffset).method_1019(right.method_1021(attemptDistance));
            boolean leftSafe = BlazeDodger.isPositionSafe(candLeft, fireballs, playerHeight);
            boolean rightSafe = BlazeDodger.isPositionSafe(candRight, fireballs, playerHeight);
            class_243 chosenStep = null;
            if (leftSafe && rightSafe) {
                boolean rightBiased;
                boolean leftBiased = leftPref > 0.05 && rightPref < 0.05;
                boolean bl = rightBiased = rightPref > 0.05 && leftPref < 0.05;
                if (leftBiased) {
                    chosenStep = left.method_1021(attemptDistance);
                } else if (rightBiased) {
                    chosenStep = right.method_1021(attemptDistance);
                } else if (leftPref > 0.05 && rightPref > 0.05 && Math.abs(leftPref - rightPref) > 0.05) {
                    chosenStep = (leftPref > rightPref ? left : right).method_1021(attemptDistance);
                }
                if (chosenStep == null) {
                    double rc;
                    double lc = BlazeDodger.clearanceScore(candLeft, fireballs);
                    chosenStep = lc >= (rc = BlazeDodger.clearanceScore(candRight, fireballs)) ? left.method_1021(attemptDistance) : right.method_1021(attemptDistance);
                }
            } else if (leftSafe) {
                chosenStep = left.method_1021(attemptDistance);
            } else if (rightSafe) {
                chosenStep = right.method_1021(attemptDistance);
            } else {
                if ((attemptDistance += 0.5) + totalPlanned > 3.0) break;
                --step;
                continue;
            }
            cumulativeOffset = cumulativeOffset.method_1019(chosenStep);
            totalPlanned = cumulativeOffset.method_1033();
            chosenAxis = cumulativeOffset.method_1029();
            if (BlazeDodger.isPositionSafe(startPos.method_1019(cumulativeOffset), fireballs, playerHeight)) break;
        }
        if (chosenAxis == null || totalPlanned < 1.0E-4) {
            return;
        }
        double scale = class_3532.method_15350((double)(totalPlanned / 1.0), (double)0.6, (double)1.5);
        class_243 axis = chosenAxis;
        class_243 v = player.method_18798();
        double comp = v.field_1352 * axis.field_1352 + v.field_1350 * axis.field_1350;
        double compNew = class_3532.method_15350((double)(comp + 0.85 * scale), (double)-1.2, (double)1.2);
        class_243 add = axis.method_1021(compNew - comp);
        class_243 vNew = new class_243(v.field_1352 + add.field_1352, v.field_1351, v.field_1350 + add.field_1350);
        player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
        lastDebug = new BlazeDodgerDebug(axis, totalPlanned, compNew);
    }

    private static class_238 expandPlayerBox(class_238 original) {
        return new class_238(original.field_1323 - 0.2 - 0.05, original.field_1322, original.field_1321 - 0.2 - 0.05, original.field_1320 + 0.2 + 0.05, original.field_1325, original.field_1324 + 0.2 + 0.05);
    }

    private static Threat predictThreat(class_243 start, class_243 velocity, class_238 playerBoxExpanded) {
        double speed = velocity.method_1033();
        if (speed < 1.0E-6) {
            return null;
        }
        class_243 dir = velocity.method_1029();
        class_243 end = start.method_1019(dir.method_1021(speed * 60.0));
        class_243 hit = BlazeDodger.segmentAabbIntersection(start, end, playerBoxExpanded);
        if (hit == null) {
            return null;
        }
        double distance = hit.method_1022(start);
        double ticks = distance / speed;
        double etaMs = ticks * 50.0;
        return new Threat(dir, etaMs, hit);
    }

    private static boolean isPositionSafe(class_243 pos, List<class_1677> fireballs, double playerHeight) {
        double playerHalfWidth = 0.3;
        for (class_1677 fb : fireballs) {
            class_243 fbPos = Compat.pos((class_1297)fb);
            class_243 vel = fb.method_18798();
            if (vel.method_1027() < 1.0E-6) continue;
            class_243 dir = vel.method_1029();
            class_243 rel = pos.method_1020(fbPos);
            double t = rel.method_1026(dir);
            if (t < 0.0 || t > vel.method_1033() * 60.0) continue;
            class_243 closest = fbPos.method_1019(dir.method_1021(t));
            double dx = pos.field_1352 - closest.field_1352;
            double dz = pos.field_1350 - closest.field_1350;
            double horizDist2 = dx * dx + dz * dz;
            double minAllow = 0.2 + playerHalfWidth + 0.05;
            if (!(horizDist2 <= minAllow * minAllow)) continue;
            return false;
        }
        return true;
    }

    private static double clearanceScore(class_243 pos, List<class_1677> fireballs) {
        double score = 0.0;
        for (class_1677 fb : fireballs) {
            class_243 fbPos = Compat.pos((class_1297)fb);
            class_243 vel = fb.method_18798();
            if (vel.method_1027() < 1.0E-6) continue;
            class_243 dir = vel.method_1029();
            class_243 rel = pos.method_1020(fbPos);
            double t = class_3532.method_15350((double)rel.method_1026(dir), (double)0.0, (double)(vel.method_1033() * 60.0));
            class_243 closest = fbPos.method_1019(dir.method_1021(t));
            double dx = pos.field_1352 - closest.field_1352;
            double dz = pos.field_1350 - closest.field_1350;
            double dist = Math.sqrt(dx * dx + dz * dz);
            score += dist;
        }
        return score;
    }

    private static class_243 segmentAabbIntersection(class_243 p0, class_243 p1, class_238 b) {
        double tMin = 0.0;
        double tMax = 1.0;
        double dx = p1.field_1352 - p0.field_1352;
        double dy = p1.field_1351 - p0.field_1351;
        double dz = p1.field_1350 - p0.field_1350;
        if (!BlazeDodger.slabIntersect(p0.field_1352, dx, b.field_1323, b.field_1320, tMin, tMax)) {
            return null;
        }
        double[] tx = BlazeDodger.slabValues(p0.field_1352, dx, b.field_1323, b.field_1320, tMin, tMax);
        if ((tMin = tx[0]) > (tMax = tx[1])) {
            return null;
        }
        if (!BlazeDodger.slabIntersect(p0.field_1351, dy, b.field_1322, b.field_1325, tMin, tMax)) {
            return null;
        }
        double[] ty = BlazeDodger.slabValues(p0.field_1351, dy, b.field_1322, b.field_1325, tMin, tMax);
        if ((tMin = ty[0]) > (tMax = ty[1])) {
            return null;
        }
        if (!BlazeDodger.slabIntersect(p0.field_1350, dz, b.field_1321, b.field_1324, tMin, tMax)) {
            return null;
        }
        double[] tz = BlazeDodger.slabValues(p0.field_1350, dz, b.field_1321, b.field_1324, tMin, tMax);
        if ((tMin = tz[0]) > (tMax = tz[1])) {
            return null;
        }
        if (tMin < 0.0 || tMin > 1.0) {
            return null;
        }
        return new class_243(p0.field_1352 + dx * tMin, p0.field_1351 + dy * tMin, p0.field_1350 + dz * tMin);
    }

    private static boolean slabIntersect(double p0, double d, double min, double max, double tMin, double tMax) {
        if (Math.abs(d) < 1.0E-9) {
            return !(p0 < min) && !(p0 > max);
        }
        return true;
    }

    private static double[] slabValues(double p0, double d, double min, double max, double tMin, double tMax) {
        if (Math.abs(d) < 1.0E-9) {
            return new double[]{tMin, tMax};
        }
        double inv = 1.0 / d;
        double t1 = (min - p0) * inv;
        double t2 = (max - p0) * inv;
        if (t1 > t2) {
            double tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        tMin = Math.max(tMin, t1);
        tMax = Math.min(tMax, t2);
        return new double[]{tMin, tMax};
    }

    public static BlazeDodgerDebug getDebug() {
        return lastDebug;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Threat {
        final class_243 direction;
        final double etaMs;
        final class_243 impactPoint;

        Threat(class_243 dir, double eta, class_243 hit) {
            this.direction = new class_243(dir.field_1352, 0.0, dir.field_1350);
            this.etaMs = eta;
            this.impactPoint = hit;
        }
    }
}

