/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.DodgerClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "dodger-client.json";
    public boolean hudEnabled = true;
    public int hudX = 6;
    public int hudY = 6;
    public int hitsTaken = 0;
    public boolean debugOverlaysEnabled = true;
    public boolean skeletonDodgeEnabled = true;
    public boolean strayDodgeEnabled = true;
    public boolean pillagerDodgeEnabled = true;
    public boolean witchDodgeEnabled = true;
    public boolean witchDebugEnabled = true;
    public boolean drownedDodgeEnabled = true;
    public boolean drownedDebugEnabled = true;
    public boolean evokerDodgeEnabled = true;
    public boolean evokerDebugEnabled = true;
    public boolean vexDodgeEnabled = true;
    public boolean vexDebugEnabled = true;
    public boolean shulkerDodgeEnabled = true;
    public boolean shulkerDebugEnabled = true;
    public boolean ghastDodgeEnabled = true;
    public boolean ghastDebugEnabled = true;
    public boolean blazeDodgeEnabled = true;
    public boolean blazeDebugEnabled = true;
    public boolean piglinDodgeEnabled = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientConfig load() {
        Path path = ClientConfig.getConfigPath();
        if (!Files.exists(path, new LinkOption[0])) return new ClientConfig();
        try (BufferedReader r = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ClientConfig cfg = (ClientConfig)GSON.fromJson((Reader)r, ClientConfig.class);
            if (cfg == null) return new ClientConfig();
            ClientConfig clientConfig = cfg;
            return clientConfig;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ClientConfig();
    }

    public void save() {
        Path path = ClientConfig.getConfigPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)w);
            }
        }
        catch (IOException e) {
            DodgerClient.LOGGER.warn("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static Path getConfigPath() {
        Path gameDir = class_310.method_1551().field_1697.toPath();
        return gameDir.resolve("config").resolve(FILE_NAME);
    }
}

