/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerActions;
import com.dodger.DodgerClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public class DodgerConfigScreen
extends class_437 {
    private final class_437 parent;
    private int visualDebugHeaderBaseY = -1;
    private int mobHeaderBaseY = -1;
    private float scrollOffset = 0.0f;
    private int contentHeight = 0;
    private int contentTop = 28;
    private int contentBottomPadding = 36;
    private class_4185 resetButton;
    private int resetButtonBaseY = -1;
    public static class_304 OPEN_CONFIG_KEY;
    private final List<ConfigLabel> configLabels = new ArrayList<ConfigLabel>();
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public static void registerKeybinding() {
        if (OPEN_CONFIG_KEY == null) {
            OPEN_CONFIG_KEY = KeyBindingHelper.registerKeyBinding((class_304)Compat.createKeybinding("key.dodger.open_config", 79, "category.dodger.general"));
        }
    }

    public DodgerConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Dodger Settings"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.configLabels.clear();
        this.entries.clear();
        this.scrollOffset = 0.0f;
        int centerX = this.field_22789 / 2;
        int leftX = centerX - 155;
        int rightX = centerX + 80;
        int bw = 75;
        int bh = 20;
        int spacing = 24;
        int y = 43;
        this.mobHeaderBaseY = y - 11;
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Skeleton", DodgerClient.CONFIG.skeletonDodgeEnabled, v -> {
            DodgerClient.CONFIG.skeletonDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Stray", DodgerClient.CONFIG.strayDodgeEnabled, v -> {
            DodgerClient.CONFIG.strayDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Pillager", DodgerClient.CONFIG.pillagerDodgeEnabled, v -> {
            DodgerClient.CONFIG.pillagerDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Witch", DodgerClient.CONFIG.witchDodgeEnabled, v -> {
            DodgerClient.CONFIG.witchDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Drowned (Trident)", DodgerClient.CONFIG.drownedDodgeEnabled, v -> {
            DodgerClient.CONFIG.drownedDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Evoker", DodgerClient.CONFIG.evokerDodgeEnabled, v -> {
            DodgerClient.CONFIG.evokerDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Vex", DodgerClient.CONFIG.vexDodgeEnabled, v -> {
            DodgerClient.CONFIG.vexDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Piglin (Crossbow)", DodgerClient.CONFIG.piglinDodgeEnabled, v -> {
            DodgerClient.CONFIG.piglinDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Ghast", DodgerClient.CONFIG.ghastDodgeEnabled, v -> {
            DodgerClient.CONFIG.ghastDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Blaze", DodgerClient.CONFIG.blazeDodgeEnabled, v -> {
            DodgerClient.CONFIG.blazeDodgeEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Shulker", DodgerClient.CONFIG.shulkerDodgeEnabled, v -> {
            DodgerClient.CONFIG.shulkerDodgeEnabled = v;
        });
        y += spacing;
        this.visualDebugHeaderBaseY = y += 11;
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Debug Render Overlays", DodgerClient.CONFIG.debugOverlaysEnabled, v -> {
            DodgerClient.CONFIG.debugOverlaysEnabled = v;
        });
        this.addToggleEntry(leftX, rightX, y += spacing, bw, bh, "Debug HUD", DodgerClient.CONFIG.hudEnabled, v -> {
            DodgerClient.CONFIG.hudEnabled = v;
        });
        this.resetButtonBaseY = y += spacing;
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset Statistics"), b -> {
            DodgerActions.resetStatsAndLogs();
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Dodger stats and logs reset!"), true);
            }
        }).method_46434(centerX - 100, this.resetButtonBaseY, 200, bh).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 29, 200, 20).method_46431());
    }

    private void addToggleEntry(int leftX, int rightX, int y, int buttonWidth, int buttonHeight, String label, boolean initialValue, Consumer<Boolean> onChange) {
        class_5676 btn = class_5676.method_32613((boolean)initialValue).method_32617(rightX, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)""), (b, value) -> {
            onChange.accept((Boolean)value);
            DodgerClient.CONFIG.save();
        });
        this.method_37063((class_364)btn);
        ConfigLabel labelObj = new ConfigLabel(leftX, y + 7, label);
        this.configLabels.add(labelObj);
        this.entries.add(new ConfigEntry(labelObj, (class_5676<Boolean>)btn, y));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        float baseOffset;
        boolean needsScroll;
        int contentBottom = this.field_22790 - this.contentBottomPadding;
        int availableHeight = Math.max(0, contentBottom - this.contentTop);
        int topBound = Math.max(0, this.mobHeaderBaseY);
        int bottomBound = this.resetButtonBaseY >= 0 ? this.resetButtonBaseY + 20 : topBound;
        this.contentHeight = Math.max(0, bottomBound - topBound);
        boolean bl = needsScroll = this.contentHeight > availableHeight;
        if (!needsScroll) {
            baseOffset = -((float)(availableHeight - this.contentHeight) / 2.0f);
            this.scrollOffset = 0.0f;
        } else {
            baseOffset = this.scrollOffset;
            float maxScroll = this.contentHeight - availableHeight;
            if (maxScroll < 0.0f) {
                maxScroll = 0.0f;
            }
            if (this.scrollOffset < 0.0f) {
                this.scrollOffset = 0.0f;
            }
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
        }
        for (ConfigEntry e : this.entries) {
            boolean visible;
            int newY = (int)((float)e.baseRowY - baseOffset);
            e.button.method_46419(newY);
            e.button.field_22764 = visible = newY + e.button.method_25364() >= this.contentTop && newY <= contentBottom;
        }
        if (this.resetButton != null && this.resetButtonBaseY >= 0) {
            int newY = (int)((float)this.resetButtonBaseY - baseOffset);
            this.resetButton.method_46419(newY);
            this.resetButton.field_22764 = newY + this.resetButton.method_25364() >= this.contentTop && newY <= contentBottom;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        int mobHeader = this.mobHeaderBaseY >= 0 ? (int)((float)this.mobHeaderBaseY - baseOffset) : 32;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Mob Dodging").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), this.field_22789 / 2, mobHeader, -1);
        int headerY = this.visualDebugHeaderBaseY >= 0 ? (int)((float)this.visualDebugHeaderBaseY - baseOffset) : 307;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Visual & Debug").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), this.field_22789 / 2, headerY, -1);
        context.method_44379(0, this.contentTop, this.field_22789, contentBottom);
        for (ConfigLabel label : this.configLabels) {
            int drawY = (int)((float)label.y - baseOffset);
            if (drawY + 9 < this.contentTop || drawY > contentBottom) continue;
            context.method_25303(this.field_22793, label.text, label.x, drawY, -1);
        }
        context.method_44380();
        if (needsScroll) {
            int trackX1 = this.field_22789 - 6;
            int trackX2 = this.field_22789 - 4;
            int trackY1 = this.contentTop;
            int trackY2 = contentBottom;
            context.method_25294(trackX1, trackY1, trackX2, trackY2, 0x66000000);
            int trackH = trackY2 - trackY1;
            int thumbH = Math.max(32, (int)((float)trackH * ((float)availableHeight / (float)this.contentHeight)));
            int maxThumbTravel = trackH - thumbH;
            float maxScroll = this.contentHeight - availableHeight;
            int thumbY = trackY1 + (maxScroll <= 0.0f ? 0 : (int)((float)maxThumbTravel * (this.scrollOffset / maxScroll)));
            context.method_25294(trackX1, thumbY, trackX2, thumbY + thumbH, -1711276033);
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int contentBottom = this.field_22790 - this.contentBottomPadding;
        int availableHeight = Math.max(0, contentBottom - this.contentTop);
        if (this.contentHeight > availableHeight) {
            this.scrollOffset -= (float)(verticalAmount * 10.0);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigLabel {
        int x;
        int y;
        String text;

        ConfigLabel(int x, int y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigEntry {
        final ConfigLabel label;
        final class_5676<Boolean> button;
        final int baseRowY;

        ConfigEntry(ConfigLabel label, class_5676<Boolean> button, int baseRowY) {
            this.label = label;
            this.button = button;
            this.baseRowY = baseRowY;
        }
    }
}

