/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.ArrowDetection;
import com.dodger.ArrowTrajectory;
import com.dodger.BlazeTracker;
import com.dodger.DodgerClient;
import com.dodger.DrownedTracker;
import com.dodger.EvokerDetection;
import com.dodger.EvokerTracker;
import com.dodger.EvokerTrajectory;
import com.dodger.FireDebugTracker;
import com.dodger.FireballImpact;
import com.dodger.GhastTracker;
import com.dodger.PiglinTracker;
import com.dodger.PillagerTracker;
import com.dodger.PotionImpact;
import com.dodger.RenderUtils;
import com.dodger.ShulkerDetection;
import com.dodger.ShulkerTrajectory;
import com.dodger.SkeletonTracker;
import com.dodger.StrayTracker;
import com.dodger.TridentDetection;
import com.dodger.TridentTrajectory;
import com.dodger.VexDetection;
import com.dodger.VexTracker;
import com.dodger.VexTrajectory;
import com.dodger.WitchTracker;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1545;
import net.minecraft.class_1551;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1634;
import net.minecraft.class_1640;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4836;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class DodgerRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderWorld(class_4587 matrices, class_4184 camera) {
        class_238 targetBox;
        List<class_243> pts;
        class_238 box;
        class_243 start;
        List<class_243> points;
        class_1551 ent;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (client.field_1761 == null || client.field_1761.method_2920() == null || !client.field_1761.method_2920().method_8388()) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
        if (!DodgerClient.CONFIG.debugOverlaysEnabled) {
            return;
        }
        class_243 cameraPos = new class_243(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        matrices.method_22903();
        Quaternionf invRot = new Quaternionf((Quaternionfc)camera.method_23767());
        invRot.conjugate();
        matrices.method_22907((Quaternionfc)invRot);
        matrices.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        Set<class_2338> detectedFire = FireDebugTracker.getDetectedFireBlocks();
        if (!detectedFire.isEmpty()) {
            GL11.glDisable((int)2929);
            try {
                for (class_2338 class_23382 : detectedFire) {
                    double fx = class_23382.method_10263();
                    double fy = class_23382.method_10264();
                    double fz = class_23382.method_10260();
                    class_238 fireBox = new class_238(fx, fy, fz, fx + 1.0, fy + 1.0, fz + 1.0).method_1014(0.002);
                    RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, fireBox, 1.0f, 1.0f, 0.0f, 1.0f);
                }
            }
            finally {
                GL11.glEnable((int)2929);
            }
        }
        for (UUID uUID : SkeletonTracker.getAggressiveSkeletons()) {
            Iterator fx = world.method_8390(class_1613.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(skeletonUuid)).iterator();
            if (!fx.hasNext()) continue;
            class_1613 skeleton = (class_1613)fx.next();
            class_238 box2 = skeleton.method_5829();
            RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box2, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        for (UUID uUID : StrayTracker.getAggressiveStrays()) {
            Iterator fx = world.method_8390(class_1627.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(strayUuid)).iterator();
            if (!fx.hasNext()) continue;
            class_1627 stray = (class_1627)fx.next();
            class_238 box3 = stray.method_5829();
            RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box3, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        for (UUID uUID : PillagerTracker.getAggressivePillagers()) {
            Iterator fx = world.method_8390(class_1604.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(pillagerUuid)).iterator();
            if (!fx.hasNext()) continue;
            class_1604 pillager = (class_1604)fx.next();
            class_238 box4 = pillager.method_5829();
            RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box4, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (DodgerClient.CONFIG.witchDodgeEnabled) {
            for (UUID uUID : WitchTracker.getAggressiveWitches()) {
                Iterator fx = world.method_8390(class_1640.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(witchUuid)).iterator();
                if (!fx.hasNext()) continue;
                class_1640 witch = (class_1640)fx.next();
                class_238 box5 = witch.method_5829();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box5, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        if (DodgerClient.CONFIG.drownedDodgeEnabled) {
            for (UUID uUID : DrownedTracker.getAggressiveDrowned()) {
                Iterator fx = world.method_8390(class_1551.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
                if (!fx.hasNext()) continue;
                ent = (class_1551)fx.next();
                class_238 box6 = ent.method_5829();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box6, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        if (DodgerClient.CONFIG.evokerDodgeEnabled) {
            for (UUID uUID : EvokerTracker.getAggressiveEvokers()) {
                Iterator fx = world.method_8390(class_1564.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
                if (!fx.hasNext()) continue;
                ent = (class_1564)fx.next();
                class_238 box7 = ent.method_5829();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box7, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        if (DodgerClient.CONFIG.vexDodgeEnabled) {
            for (UUID uUID : VexTracker.getAggressiveVexes()) {
                Iterator fx = world.method_8390(class_1634.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(uuid)).iterator();
                if (!fx.hasNext()) continue;
                class_1634 vex = (class_1634)fx.next();
                class_238 box8 = vex.method_5829();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box8, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        for (UUID uUID : PiglinTracker.getAggressivePiglins()) {
            Iterator fx = world.method_8390(class_4836.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(piglinUuid)).iterator();
            if (!fx.hasNext()) continue;
            class_4836 piglin = (class_4836)fx.next();
            class_238 box9 = piglin.method_5829();
            RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box9, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (DodgerClient.CONFIG.ghastDodgeEnabled) {
            for (UUID uUID : GhastTracker.getAggressiveGhasts()) {
                Iterator fx = world.method_8390(class_1571.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(ghastUuid)).iterator();
                if (!fx.hasNext()) continue;
                class_1571 ghast = (class_1571)fx.next();
                class_238 box10 = ghast.method_5829();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box10, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        if (DodgerClient.CONFIG.blazeDodgeEnabled) {
            for (UUID uUID : BlazeTracker.getAggressiveBlazes()) {
                Iterator fx = world.method_8390(class_1545.class, player.method_5829().method_1014(64.0), e -> e.method_5667().equals(blazeUuid)).iterator();
                if (!fx.hasNext()) continue;
                class_1545 blaze = (class_1545)fx.next();
                class_238 box11 = blaze.method_5829();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box11, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        for (ArrowTrajectory arrowTrajectory : ArrowDetection.getTrajectories()) {
            if (arrowTrajectory.isExpired()) continue;
            float opacity = arrowTrajectory.getFadeOpacity();
            points = arrowTrajectory.getTrajectoryPoints();
            for (int i = 0; i < points.size() - 1; ++i) {
                start = points.get(i);
                class_243 end = points.get(i + 1);
                RenderUtils.drawCylinder(matrices, (class_4597)vertexConsumers, start, end, 1.0f, 0.0f, 0.0f, opacity);
            }
            if (!arrowTrajectory.targetsPlayer()) continue;
            class_243 target = arrowTrajectory.getTargetPosition();
            class_238 targetBox2 = new class_238(target.field_1352 - 0.5, target.field_1351 - 0.5, target.field_1350 - 0.5, target.field_1352 + 0.5, target.field_1351 + 0.5, target.field_1350 + 0.5);
            RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, targetBox2, 1.0f, 0.0f, 0.0f, opacity);
        }
        if (DodgerClient.CONFIG.drownedDodgeEnabled && DodgerClient.CONFIG.drownedDebugEnabled) {
            for (TridentTrajectory tridentTrajectory : TridentDetection.getTrajectories()) {
                if (tridentTrajectory.isExpired()) continue;
                float opacity = tridentTrajectory.getFadeOpacity();
                points = tridentTrajectory.points;
                for (int i = 0; i < points.size() - 1; ++i) {
                    start = points.get(i);
                    class_243 end = points.get(i + 1);
                    RenderUtils.drawCylinder(matrices, (class_4597)vertexConsumers, start, end, 1.0f, 0.0f, 0.0f, opacity);
                }
                if (!tridentTrajectory.targetsPlayer) continue;
                class_243 target = tridentTrajectory.targetPosition;
                box = new class_238(target.field_1352 - 0.5, target.field_1351 - 0.5, target.field_1350 - 0.5, target.field_1352 + 0.5, target.field_1351 + 0.5, target.field_1350 + 0.5);
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box, 1.0f, 0.0f, 0.0f, opacity);
            }
        }
        if (DodgerClient.CONFIG.evokerDodgeEnabled && DodgerClient.CONFIG.evokerDebugEnabled) {
            for (EvokerTrajectory evokerTrajectory : EvokerDetection.getTrajectories()) {
                if (evokerTrajectory.isExpired()) continue;
                float opacity = evokerTrajectory.getFadeOpacity();
                points = evokerTrajectory.points;
                for (int i = 0; i < points.size() - 1; ++i) {
                    start = points.get(i);
                    class_243 end = points.get(i + 1);
                    RenderUtils.drawCylinder(matrices, (class_4597)vertexConsumers, start, end, 1.0f, 1.0f, 0.0f, opacity);
                }
                if (!evokerTrajectory.targetsPlayer) continue;
                class_243 target = evokerTrajectory.targetPosition;
                box = new class_238(target.field_1352 - 0.5, target.field_1351 - 0.5, target.field_1350 - 0.5, target.field_1352 + 0.5, target.field_1351 + 0.5, target.field_1350 + 0.5);
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, box, 1.0f, 1.0f, 0.0f, opacity);
            }
        }
        if (DodgerClient.CONFIG.witchDodgeEnabled && DodgerClient.CONFIG.witchDebugEnabled) {
            for (PotionImpact potionImpact : WitchTracker.getActiveImpacts()) {
                if (potionImpact.isExpired() || potionImpact.trajectoryPoints == null || potionImpact.trajectoryPoints.size() <= 1) continue;
                float opacity = potionImpact.getFadeOpacity();
                pts = potionImpact.trajectoryPoints;
                for (int i = 0; i < pts.size() - 1; ++i) {
                    RenderUtils.drawCylinder(matrices, (class_4597)vertexConsumers, pts.get(i), pts.get(i + 1), 1.0f, 0.0f, 0.0f, opacity);
                }
            }
        }
        if (DodgerClient.CONFIG.ghastDodgeEnabled && DodgerClient.CONFIG.ghastDebugEnabled) {
            for (FireballImpact fireballImpact : GhastTracker.getActiveImpacts()) {
                if (fireballImpact.isExpired() || fireballImpact.trajectoryPoints == null || fireballImpact.trajectoryPoints.size() <= 1) continue;
                float opacity = fireballImpact.getFadeOpacity();
                pts = fireballImpact.trajectoryPoints;
                for (int i = 0; i < pts.size() - 1; ++i) {
                    RenderUtils.drawCylinder(matrices, (class_4597)vertexConsumers, pts.get(i), pts.get(i + 1), 1.0f, 0.6f, 0.0f, opacity);
                }
            }
        }
        if (DodgerClient.CONFIG.blazeDodgeEnabled && DodgerClient.CONFIG.blazeDebugEnabled) {
            for (FireballImpact fireballImpact : BlazeTracker.getActiveImpacts()) {
                if (fireballImpact.isExpired() || fireballImpact.trajectoryPoints == null || fireballImpact.trajectoryPoints.size() <= 1) continue;
                float opacity = fireballImpact.getFadeOpacity();
                pts = fireballImpact.trajectoryPoints;
                for (int i = 0; i < pts.size() - 1; ++i) {
                    RenderUtils.drawCylinder(matrices, (class_4597)vertexConsumers, pts.get(i), pts.get(i + 1), 1.0f, 0.0f, 1.0f, opacity);
                }
            }
        }
        if (DodgerClient.CONFIG.ghastDodgeEnabled && DodgerClient.CONFIG.ghastDebugEnabled) {
            for (FireballImpact fireballImpact : GhastTracker.getActiveImpacts()) {
                if (fireballImpact.isExpired() || !fireballImpact.targetsPlayer) continue;
                float opacity = fireballImpact.getFadeOpacity();
                targetBox = new class_238(fireballImpact.impactPoint.field_1352 - 0.5, fireballImpact.impactPoint.field_1351 - 0.5, fireballImpact.impactPoint.field_1350 - 0.5, fireballImpact.impactPoint.field_1352 + 0.5, fireballImpact.impactPoint.field_1351 + 0.5, fireballImpact.impactPoint.field_1350 + 0.5);
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, targetBox, 1.0f, 0.0f, 0.0f, opacity);
            }
        }
        if (DodgerClient.CONFIG.blazeDodgeEnabled && DodgerClient.CONFIG.blazeDebugEnabled) {
            for (FireballImpact fireballImpact : BlazeTracker.getActiveImpacts()) {
                if (fireballImpact.isExpired() || !fireballImpact.targetsPlayer) continue;
                float opacity = fireballImpact.getFadeOpacity();
                targetBox = new class_238(fireballImpact.impactPoint.field_1352 - 0.5, fireballImpact.impactPoint.field_1351 - 0.5, fireballImpact.impactPoint.field_1350 - 0.5, fireballImpact.impactPoint.field_1352 + 0.5, fireballImpact.impactPoint.field_1351 + 0.5, fireballImpact.impactPoint.field_1350 + 0.5);
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, targetBox, 1.0f, 0.0f, 0.0f, opacity);
            }
        }
        if (DodgerClient.CONFIG.witchDodgeEnabled && DodgerClient.CONFIG.witchDebugEnabled) {
            for (PotionImpact potionImpact : WitchTracker.getActiveImpacts()) {
                if (potionImpact.isExpired()) continue;
                float opacity = potionImpact.getFadeOpacity();
                DodgerRenderer.drawSplashCubes(matrices, (class_4597)vertexConsumers, (class_1937)world, potionImpact.impactPoint, (int)Math.ceil(4.0), opacity);
            }
        }
        if (DodgerClient.CONFIG.ghastDodgeEnabled && DodgerClient.CONFIG.ghastDebugEnabled) {
            for (FireballImpact fireballImpact : GhastTracker.getActiveImpacts()) {
                if (fireballImpact.isExpired()) continue;
                float opacity = fireballImpact.getFadeOpacity();
                DodgerRenderer.drawSplashCubes(matrices, (class_4597)vertexConsumers, (class_1937)world, fireballImpact.impactPoint, (int)Math.ceil(2.0), 0.6f, 0.0f, 0.0f, opacity);
            }
        }
        if (DodgerClient.CONFIG.blazeDodgeEnabled && DodgerClient.CONFIG.blazeDebugEnabled) {
            for (FireballImpact fireballImpact : BlazeTracker.getActiveImpacts()) {
                if (fireballImpact.isExpired()) continue;
                float opacity = fireballImpact.getFadeOpacity();
                int blazeRadius = 1;
                DodgerRenderer.drawSplashCubes(matrices, (class_4597)vertexConsumers, (class_1937)world, fireballImpact.impactPoint, blazeRadius, 0.6f, 0.0f, 0.6f, opacity);
            }
        }
        if (DodgerClient.CONFIG.vexDodgeEnabled && DodgerClient.CONFIG.vexDebugEnabled) {
            for (VexTrajectory vexTrajectory : VexDetection.getTrajectories()) {
                if (vexTrajectory.isExpired()) continue;
                float opacity = vexTrajectory.getFadeOpacity();
                if (vexTrajectory.isAttacking()) {
                    class_238 hitBox = vexTrajectory.getHitBox();
                    RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, hitBox, 1.0f, 0.6f, 0.0f, opacity);
                }
                if (!vexTrajectory.targetsPlayer()) continue;
                class_243 target = vexTrajectory.getTargetPosition();
                class_238 targetBox3 = new class_238(target.field_1352 - 0.5, target.field_1351 - 0.5, target.field_1350 - 0.5, target.field_1352 + 0.5, target.field_1351 + 0.5, target.field_1350 + 0.5);
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, targetBox3, 1.0f, 0.0f, 0.0f, opacity);
            }
        }
        if (DodgerClient.CONFIG.shulkerDodgeEnabled && DodgerClient.CONFIG.shulkerDebugEnabled) {
            for (ShulkerTrajectory shulkerTrajectory : ShulkerDetection.getTrajectories()) {
                if (shulkerTrajectory.isExpired()) continue;
                float opacity = shulkerTrajectory.getFadeOpacity();
                class_238 hit = shulkerTrajectory.getHitBox();
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, hit, 0.6f, 0.0f, 0.8f, opacity);
                if (!shulkerTrajectory.targetsPlayer()) continue;
                class_243 c = shulkerTrajectory.getCollisionPoint();
                class_238 targetBox2 = new class_238(c.field_1352 - 0.5, c.field_1351 - 0.5, c.field_1350 - 0.5, c.field_1352 + 0.5, c.field_1351 + 0.5, c.field_1350 + 0.5);
                RenderUtils.drawOutlineBox(matrices, (class_4597)vertexConsumers, targetBox2, 1.0f, 0.0f, 0.0f, opacity);
            }
        }
        if (vertexConsumers instanceof class_4597.class_4598) {
            class_4597.class_4598 immediate = vertexConsumers;
            immediate.method_22993();
        }
        matrices.method_22909();
    }

    private static void drawSplashCubes(class_4587 matrices, class_4597 vertexConsumers, class_1937 world, class_243 center, int radius, float alpha) {
        DodgerRenderer.drawSplashCubes(matrices, vertexConsumers, world, center, radius, 0.2f, 0.6f, 0.0f, alpha);
    }

    private static void drawSplashCubes(class_4587 matrices, class_4597 vertexConsumers, class_1937 world, class_243 center, int radius, float r, float g, float b, float alpha) {
        int cx = class_2338.method_49638((class_2374)center).method_10263();
        int cz = class_2338.method_49638((class_2374)center).method_10260();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > radius * radius) continue;
                int x = cx + dx;
                int z = cz + dz;
                int y = world.method_8624(class_2902.class_2903.field_13203, x, z);
                class_238 box = new class_238((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                RenderUtils.drawOutlineBox(matrices, vertexConsumers, box, r, g, b, alpha);
            }
        }
    }
}

