/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.EvokerDetection;
import com.dodger.EvokerTrajectory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class EvokerDodger {
    private static final double STEP_DISTANCE = 1.0;
    private static final double STEP_IMPULSE = 0.55;
    private static final double STEP_MAX_SPEED = 0.75;
    private static final double MIN_MOTION = 0.05;
    private static Session session;

    public static void clear() {
        session = null;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!DodgerClient.CONFIG.evokerDodgeEnabled) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (!EvokerDodger.isFangsImminent((class_1937)world, (class_1657)player)) {
            session = null;
            return;
        }
        EvokerTrajectory chosen = null;
        for (EvokerTrajectory et : EvokerDetection.getTrajectories()) {
            if (et.isExpired()) continue;
            chosen = et;
            break;
        }
        if (chosen == null || chosen.points.size() < 2) {
            session = null;
            return;
        }
        int n = chosen.points.size();
        class_243 a = chosen.points.get(n - 2);
        class_243 b = chosen.points.get(n - 1);
        class_243 dir = b.method_1020(a);
        class_243 traj = new class_243(dir.field_1352, 0.0, dir.field_1350);
        if (traj.method_1027() < 1.0E-6) {
            session = null;
            return;
        }
        traj = traj.method_1029();
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 left = up.method_1036(traj).method_1029();
        class_243 right = traj.method_1036(up).method_1029();
        class_243 p = Compat.pos((class_1297)player);
        class_243 v = player.method_18798();
        class_243 vXZ = new class_243(v.field_1352, 0.0, v.field_1350);
        double motionWeight = 0.2;
        class_243 bestAxis = null;
        double bestScore = -1.7976931348623157E308;
        for (class_243 axis : new class_243[]{left, right}) {
            double score;
            class_243 cand = p.method_1019(axis.method_1021(1.0));
            if (!EvokerDodger.isSafeTarget((class_1937)world, (class_1657)player, cand)) continue;
            double motionBonus = 0.0;
            if (vXZ.method_1027() > 0.0025000000000000005) {
                motionBonus = motionWeight * vXZ.method_1029().method_1026(axis);
            }
            if (!((score = motionBonus) > bestScore)) continue;
            bestScore = score;
            bestAxis = axis;
        }
        if (bestAxis == null) {
            return;
        }
        if (session == null || EvokerDodger.session.axis.method_1026(bestAxis) < 0.8) {
            session = new Session(bestAxis, p);
        }
        double comp = v.method_1026(EvokerDodger.session.axis);
        double compNew = class_3532.method_15350((double)(comp + 0.55), (double)-0.75, (double)0.75);
        class_243 vNew = v.method_1019(EvokerDodger.session.axis.method_1021(compNew - comp));
        player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
        double traveled = Compat.pos((class_1297)player).method_1020(EvokerDodger.session.start).method_1026(EvokerDodger.session.axis);
        if (traveled >= 1.0) {
            class_243 vv = player.method_18798();
            double c = vv.method_1026(EvokerDodger.session.axis);
            player.method_18800(vv.field_1352 - EvokerDodger.session.axis.field_1352 * c, vv.field_1351, vv.field_1350 - EvokerDodger.session.axis.field_1350 * c);
            session = new Session(EvokerDodger.session.axis, Compat.pos((class_1297)player));
        }
    }

    private static boolean isFangsImminent(class_1937 world, class_1657 player) {
        double range = 3.0;
        for (class_1669 f : world.method_8390(class_1669.class, player.method_5829().method_1014(range), e -> true)) {
            double dx = f.method_23317() - player.method_23317();
            double dz = f.method_23321() - player.method_23321();
            double dXZ = Math.sqrt(dx * dx + dz * dz);
            int age = f.field_6012;
            if (dXZ <= 1.6 && age >= 6 && age <= 20) {
                return true;
            }
            if (!f.method_5829().method_1014(0.1).method_994(player.method_5829().method_1012(0.0, -0.5, 0.0))) continue;
            return true;
        }
        return false;
    }

    private static boolean isSafeTarget(class_1937 world, class_1657 player, class_243 target) {
        class_243 delta;
        class_238 box = player.method_5829();
        class_238 shifted = box.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!EvokerDodger.isPathClear(world, player, box, delta)) {
            return false;
        }
        return EvokerDodger.isFootprintSafe(world, shifted);
    }

    private static boolean isPathClear(class_1937 w, class_1657 p, class_238 start, class_243 d) {
        double len = d.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(len / 0.2));
        class_243 step = d.method_1021(1.0 / (double)steps);
        class_238 b = start;
        for (int i = 1; i <= steps; ++i) {
            if (w.method_8587((class_1297)p, b = b.method_997(step))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFootprintSafe(class_1937 w, class_238 shifted) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean ground = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    if (w.method_8320((class_2338)pos).method_26220((class_1922)w, (class_2338)pos).method_1110()) continue;
                    ground = true;
                    break;
                }
                if (ground) continue;
                return false;
            }
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Session {
        final class_243 axis;
        final class_243 start;

        Session(class_243 a, class_243 s) {
            this.axis = a;
            this.start = s;
        }
    }
}

