/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class FireDebugTracker {
    private static final int SCAN_RADIUS = 12;
    private static final Set<class_2338> detectedFireBlocks = new HashSet<class_2338>();

    private FireDebugTracker() {
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            detectedFireBlocks.clear();
            return;
        }
        if (client.field_1687.method_8510() % 5L != 0L) {
            return;
        }
        class_638 world = client.field_1687;
        class_2338 playerPos = client.field_1724.method_24515();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        detectedFireBlocks.clear();
        int px = playerPos.method_10263();
        int py = playerPos.method_10264();
        int pz = playerPos.method_10260();
        for (int dx = -12; dx <= 12; ++dx) {
            for (int dy = -12; dy <= 12; ++dy) {
                for (int dz = -12; dz <= 12; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > 144) continue;
                    mutable.method_10103(px + dx, py + dy, pz + dz);
                    class_2680 state = world.method_8320((class_2338)mutable);
                    if (!FireDebugTracker.isFire(state)) continue;
                    detectedFireBlocks.add(mutable.method_10062());
                }
            }
        }
    }

    public static Set<class_2338> getDetectedFireBlocks() {
        return Collections.unmodifiableSet(detectedFireBlocks);
    }

    private static boolean isFire(class_2680 state) {
        return state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_22089);
    }
}

