/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.ShulkerDetection;
import com.dodger.ShulkerTrajectory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2510;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ShulkerDodger {
    private static final double DODGE_DISTANCE = 1.0;
    private static final double DODGE_IMPULSE = 0.55;
    private static final double MAX_LATERAL_SPEED = 0.7;
    private static final double MIN_MOTION = 0.05;
    private static DodgeSession activeSession = null;

    public static void clear() {
        activeSession = null;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        ShulkerDodger.clamp((class_1657)player);
        for (ShulkerTrajectory t : ShulkerDetection.getTrajectories()) {
            class_243 best;
            if (!t.targetsPlayer() || t.isExpired()) continue;
            class_243 bulletVel = t.getBulletVelocity();
            class_243 velXZ = new class_243(bulletVel.field_1352, 0.0, bulletVel.field_1350);
            if (velXZ.method_1027() < 1.0E-6) {
                class_243 away = Compat.pos((class_1297)player).method_1020(t.getBulletPosition());
                velXZ = new class_243(away.field_1352, 0.0, away.field_1350);
                if (velXZ.method_1027() < 1.0E-6) {
                    velXZ = new class_243(1.0, 0.0, 0.0);
                }
            }
            velXZ = velXZ.method_1029();
            class_243 right = new class_243(-velXZ.field_1350, 0.0, velXZ.field_1352);
            class_243 left = right.method_1021(-1.0);
            class_243 playerPos = Compat.pos((class_1297)player);
            class_243 motionXZ = new class_243(player.method_18798().field_1352, 0.0, player.method_18798().field_1350);
            boolean levitating = player.method_6059(class_1294.field_5902);
            class_243 class_2432 = best = levitating ? null : ShulkerDodger.choose((class_1937)world, (class_1657)player, t.getBulletPosition(), playerPos, motionXZ, right, left);
            if (best != null) {
                ShulkerDodger.startDodge((class_1657)player, best, levitating);
            } else if (!levitating && player.method_24828() && world.method_8587((class_1297)player, player.method_5829().method_989(0.0, 1.0, 0.0))) {
                player.method_6043();
            }
            return;
        }
    }

    private static class_243 choose(class_1937 world, class_1657 player, class_243 bulletPos, class_243 playerPos, class_243 motionXZ, class_243 a, class_243 b) {
        double scoreA = ShulkerDodger.score(world, player, bulletPos, playerPos, motionXZ, a);
        double scoreB = ShulkerDodger.score(world, player, bulletPos, playerPos, motionXZ, b);
        if (Double.isFinite(scoreA) && Double.isFinite(scoreB)) {
            return scoreA >= scoreB ? a : b;
        }
        if (Double.isFinite(scoreA)) {
            return a;
        }
        if (Double.isFinite(scoreB)) {
            return b;
        }
        return null;
    }

    private static double score(class_1937 world, class_1657 player, class_243 bulletPos, class_243 playerPos, class_243 motionXZ, class_243 dir) {
        class_243 candidate = playerPos.method_1019((dir = dir.method_1029()).method_1021(1.0));
        if (!ShulkerDodger.isSafe(world, player, candidate)) {
            return Double.NEGATIVE_INFINITY;
        }
        double currentDist = playerPos.method_1022(bulletPos);
        double newDist = candidate.method_1022(bulletPos);
        if (newDist <= currentDist) {
            return Double.NEGATIVE_INFINITY;
        }
        double motionBonus = 0.0;
        if (motionXZ.method_1027() > 0.0025000000000000005) {
            motionBonus = 0.2 * motionXZ.method_1029().method_1026(dir);
        }
        return newDist + motionBonus;
    }

    private static boolean isSafe(class_1937 world, class_1657 player, class_243 target) {
        boolean acceptableStairs;
        class_243 delta;
        class_238 box = player.method_5829();
        class_238 shifted = box.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!ShulkerDodger.pathClear(world, player, box, delta)) {
            return false;
        }
        double feetY = shifted.field_1322 + 0.001;
        class_2338 groundPos = class_2338.method_49637((double)shifted.method_1005().field_1352, (double)(Math.floor(feetY) - 1.0), (double)shifted.method_1005().field_1350);
        class_2680 groundState = world.method_8320(groundPos);
        if (groundState.method_26215()) {
            return false;
        }
        class_265 shape = groundState.method_26220((class_1922)world, groundPos);
        if (shape.method_1110()) {
            return false;
        }
        class_238 shapeBox = shape.method_1107();
        boolean fullCube = ShulkerDodger.approximately(shapeBox.field_1323, 0.0) && ShulkerDodger.approximately(shapeBox.field_1322, 0.0) && ShulkerDodger.approximately(shapeBox.field_1321, 0.0) && ShulkerDodger.approximately(shapeBox.field_1320, 1.0) && ShulkerDodger.approximately(shapeBox.field_1325, 1.0) && ShulkerDodger.approximately(shapeBox.field_1324, 1.0);
        boolean isStairs = groundState.method_26204() instanceof class_2510;
        boolean bl = acceptableStairs = isStairs && ShulkerDodger.approximately(shapeBox.field_1322, 0.0) && shapeBox.field_1325 >= 0.75;
        if (!fullCube && !acceptableStairs) {
            return false;
        }
        class_2338 feetPos = class_2338.method_49637((double)(shifted.field_1323 + 0.3), (double)Math.floor(feetY), (double)(shifted.field_1321 + 0.3));
        class_2338 headPos = feetPos.method_10084();
        if (!world.method_8320(feetPos).method_26220((class_1922)world, feetPos).method_1110()) {
            return false;
        }
        if (!world.method_8320(headPos).method_26220((class_1922)world, headPos).method_1110()) {
            return false;
        }
        return !world.method_8316(feetPos).method_15767(class_3486.field_15517) && !world.method_8316(feetPos).method_15767(class_3486.field_15518);
    }

    private static boolean pathClear(class_1937 world, class_1657 player, class_238 start, class_243 delta) {
        double len = delta.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(len / 0.2));
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_238 box = start;
        for (int i = 0; i < steps; ++i) {
            if (world.method_8587((class_1297)player, box = box.method_997(step))) continue;
            return false;
        }
        return true;
    }

    private static void startDodge(class_1657 player, class_243 offset, boolean levitating) {
        class_243 axis = offset.method_1029();
        activeSession = new DodgeSession(Compat.pos((class_1297)player), axis, Math.min(offset.method_1033(), 1.0), 0.7);
        class_243 v = player.method_18798();
        double comp = v.method_1026(axis);
        double impulse = levitating ? 0.0825 : 0.55;
        double compNew = class_3532.method_15350((double)(comp + impulse), (double)-0.7, (double)0.7);
        class_243 vNew = v.method_1019(axis.method_1021(compNew - comp));
        player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
    }

    private static void clamp(class_1657 player) {
        if (activeSession == null) {
            return;
        }
        class_243 axis = activeSession.axis();
        double traveled = Compat.pos((class_1297)player).method_1020(activeSession.startPos()).method_1026(axis);
        if (traveled >= activeSession.maxDistance()) {
            class_243 v = player.method_18798();
            double comp = v.method_1026(axis);
            player.method_18800(v.field_1352 - axis.field_1352 * comp, v.field_1351, v.field_1350 - axis.field_1350 * comp);
            activeSession = null;
            return;
        }
        class_243 v = player.method_18798();
        double comp = v.method_1026(axis);
        if (Math.abs(comp) > activeSession.maxSpeed()) {
            double compNew = class_3532.method_15350((double)comp, (double)(-activeSession.maxSpeed()), (double)activeSession.maxSpeed());
            player.method_18799(v.method_1019(axis.method_1021(compNew - comp)));
        }
    }

    private static boolean approximately(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    @Environment(value=EnvType.CLIENT)
    private record DodgeSession(class_243 startPos, class_243 axis, double maxDistance, double maxSpeed) {
    }
}

