/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.TridentDetection;
import com.dodger.TridentTrajectory;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class TridentDodger {
    private static final double STEP_DISTANCE = 1.0;
    private static final double STEP_IMPULSE = 0.55;
    private static final double STEP_MAX_SPEED = 0.75;
    private static final double MIN_MOTION = 0.05;
    private static Session session;

    public static void clear() {
        session = null;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (DodgerClient.CONFIG != null && !DodgerClient.CONFIG.drownedDodgeEnabled) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        TridentTrajectory chosen = null;
        for (TridentTrajectory tt : TridentDetection.getTrajectories()) {
            if (tt.isExpired() || !tt.targetsPlayer) continue;
            chosen = tt;
            break;
        }
        if (chosen == null) {
            session = null;
            return;
        }
        class_243 traj = TridentDodger.getDirectionXZ(chosen);
        if (traj == null) {
            session = null;
            return;
        }
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 left = up.method_1036(traj).method_1029();
        class_243 right = traj.method_1036(up).method_1029();
        class_243 p = Compat.pos((class_1297)player);
        class_243 v = player.method_18798();
        class_243 vXZ = new class_243(v.field_1352, 0.0, v.field_1350);
        double motionWeight = 0.2;
        boolean playerInWater = player.method_5799() || player.method_5869();
        @Environment(value=EnvType.CLIENT)
        class Cand {
            class_243 axis;
            class_243 pos;
            boolean safe;
            boolean water;
            double score;

            Cand() {
            }
        }
        ArrayList<Cand> cands = new ArrayList<Cand>();
        for (class_243 axis : new class_243[]{left, right}) {
            class_243 candPos = p.method_1019(axis.method_1021(1.0));
            boolean safe = TridentDodger.isSafeTarget((class_1937)world, (class_1657)player, candPos);
            boolean water = TridentDodger.isCandidateInWater((class_1937)world, (class_1657)player, candPos);
            if (!safe) continue;
            Cand c = new Cand();
            c.axis = axis;
            c.pos = candPos;
            c.safe = true;
            c.water = water;
            double motionBonus = 0.0;
            if (vXZ.method_1027() > 0.0025000000000000005) {
                motionBonus = motionWeight * vXZ.method_1029().method_1026(axis);
            }
            c.score = motionBonus;
            cands.add(c);
        }
        if (cands.isEmpty()) {
            return;
        }
        if (playerInWater) {
            ArrayList<Cand> waterCands = new ArrayList<Cand>();
            for (Cand c : cands) {
                if (!c.water) continue;
                waterCands.add(c);
            }
            if (!waterCands.isEmpty()) {
                cands = waterCands;
            }
        }
        class_243 bestAxis = null;
        double bestScore = -1.7976931348623157E308;
        for (Cand c : cands) {
            double s = c.score;
            if (playerInWater) {
                s += c.water ? 0.5 : -0.5;
            }
            if (!(s > bestScore)) continue;
            bestScore = s;
            bestAxis = c.axis;
        }
        if (bestAxis == null) {
            return;
        }
        if (session == null || TridentDodger.session.axis.method_1026(bestAxis) < 0.8) {
            session = new Session(bestAxis, p);
        }
        double comp = v.method_1026(TridentDodger.session.axis);
        double compNew = class_3532.method_15350((double)(comp + 0.55), (double)-0.75, (double)0.75);
        class_243 vNew = v.method_1019(TridentDodger.session.axis.method_1021(compNew - comp));
        player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
        double traveled = Compat.pos((class_1297)player).method_1020(TridentDodger.session.start).method_1026(TridentDodger.session.axis);
        if (traveled >= 1.0) {
            class_243 vv = player.method_18798();
            double c = vv.method_1026(TridentDodger.session.axis);
            player.method_18800(vv.field_1352 - TridentDodger.session.axis.field_1352 * c, vv.field_1351, vv.field_1350 - TridentDodger.session.axis.field_1350 * c);
            session = new Session(TridentDodger.session.axis, Compat.pos((class_1297)player));
        }
    }

    private static class_243 getDirectionXZ(TridentTrajectory tt) {
        if (tt.points == null || tt.points.size() < 2) {
            return null;
        }
        int n = tt.points.size();
        class_243 a = tt.points.get(n - 2);
        class_243 b = tt.points.get(n - 1);
        class_243 d = b.method_1020(a);
        class_243 xz = new class_243(d.field_1352, 0.0, d.field_1350);
        if (xz.method_1027() < 1.0E-6) {
            return null;
        }
        return xz.method_1029();
    }

    private static boolean isSafeTarget(class_1937 world, class_1657 player, class_243 target) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!TridentDodger.isPathClear(world, player, playerBox, delta)) {
            return false;
        }
        boolean inWater = player.method_5799() || player.method_5869();
        return inWater ? TridentDodger.isWaterSafe(world, shifted) : TridentDodger.isFootprintSafe(world, shifted);
    }

    private static boolean isPathClear(class_1937 world, class_1657 player, class_238 startBox, class_243 delta) {
        double STEP = 0.2;
        double len = delta.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(len / 0.2));
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_238 box = startBox;
        for (int i = 1; i <= steps; ++i) {
            if (world.method_8587((class_1297)player, box = box.method_997(step))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFootprintSafe(class_1937 world, class_238 shifted) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isWaterSafe(class_1937 world, class_238 shifted) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int i = 0; i <= 2; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (!fluid.method_15767(class_3486.field_15518)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isCandidateInWater(class_1937 world, class_1657 player, class_243 candidate) {
        class_238 playerBox = player.method_5829();
        class_243 delta = candidate.method_1020(Compat.pos((class_1297)player));
        class_238 shifted = playerBox.method_997(delta);
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        int x = class_3532.method_15357((double)shifted.method_1005().field_1352);
        int z = class_3532.method_15357((double)shifted.method_1005().field_1350);
        class_2338.class_2339 pos = new class_2338.class_2339(x, feetY, z);
        class_3610 fluid = world.method_8316((class_2338)pos);
        return fluid.method_15767(class_3486.field_15517);
    }

    @Environment(value=EnvType.CLIENT)
    private static class Session {
        final class_243 axis;
        final class_243 start;
        double traveled;

        Session(class_243 a, class_243 s) {
            this.axis = a;
            this.start = s;
        }
    }
}

