/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.VexDetection;
import com.dodger.VexTrajectory;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class VexDodger {
    private static final double DODGE_DISTANCE = 1.0;
    private static final double DODGE_IMPULSE = 0.6;
    private static final double MAX_LATERAL_SPEED = 0.7;
    private static final double DODGE_IMPULSE_JUMP = 0.9;
    private static final double MAX_LATERAL_SPEED_JUMP = 1.1;
    private static final double MIN_MOTION = 0.05;
    private static final double JUMP_IMPULSE = 0.42;
    private static final double JUMP_EXTRA = 0.06;
    private static DodgeSession activeSession = null;

    public static void clear() {
        activeSession = null;
    }

    public static void tick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (activeSession != null) {
            VexDodger.clampActiveDodge((class_1657)player);
        }
        List<VexTrajectory> trajectories = VexDetection.getTrajectories();
        for (VexTrajectory trajectory : trajectories) {
            class_243 dodgeDirection;
            if (!trajectory.targetsPlayer()) continue;
            class_243 vexPos = trajectory.getVexPosition();
            class_243 vexVelocity = trajectory.getVexVelocity();
            class_243 collisionPoint = trajectory.getTargetPosition();
            class_243 playerPos = Compat.pos((class_1297)player);
            class_243 vexVelXZ = new class_243(vexVelocity.field_1352, 0.0, vexVelocity.field_1350);
            if (vexVelXZ.method_1027() > 1.0E-6) {
                dodgeDirection = vexVelXZ = vexVelXZ.method_1029();
            } else {
                class_243 awayFromVex = playerPos.method_1020(vexPos);
                class_243 awayFromVexXZ = new class_243(awayFromVex.field_1352, 0.0, awayFromVex.field_1350);
                if (awayFromVexXZ.method_1027() < 1.0E-6) {
                    awayFromVexXZ = new class_243(1.0, 0.0, 0.0);
                }
                dodgeDirection = awayFromVexXZ.method_1029();
            }
            class_243 motion = player.method_18798();
            class_243 motionXZ = new class_243(motion.field_1352, 0.0, motion.field_1350);
            class_243 bestOffset = VexDodger.chooseBestVexDodgeOffset((class_1937)world, (class_1657)player, vexPos, dodgeDirection, motionXZ);
            if (bestOffset != null) {
                class_243 axisXZ = new class_243(bestOffset.field_1352, 0.0, bestOffset.field_1350);
                double horizMag = axisXZ.method_1033();
                if (horizMag < 1.0E-6) break;
                axisXZ = axisXZ.method_1029();
                double planned = Math.min(horizMag, 1.0);
                boolean isJumpDodge = bestOffset.field_1351 > 0.5;
                double sessionMaxSpeed = isJumpDodge ? 1.1 : 0.7;
                activeSession = new DodgeSession(Compat.pos((class_1297)player), axisXZ, planned, sessionMaxSpeed);
                class_243 v = player.method_18798();
                double comp = v.method_1026(axisXZ);
                double initialImpulse = isJumpDodge ? 0.9 : 0.6;
                double compNew = class_3532.method_15350((double)(comp + initialImpulse), (double)(-sessionMaxSpeed), (double)sessionMaxSpeed);
                class_243 vNew = v.method_1019(axisXZ.method_1021(compNew - comp));
                if (isJumpDodge) {
                    boolean canJump;
                    boolean bl = canJump = player.method_24828() && !player.method_5799() && !player.method_5771();
                    if (canJump) {
                        player.method_6043();
                        double targetY = Math.max(player.method_18798().field_1351, 0.48);
                        vNew = new class_243(vNew.field_1352, Math.max(vNew.field_1351, targetY), vNew.field_1350);
                    } else if (vNew.field_1351 > 0.0) {
                        vNew = new class_243(vNew.field_1352, Math.min(vNew.field_1351 + 0.02, 0.42), vNew.field_1350);
                    }
                }
                player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
            }
            return;
        }
    }

    private static class_243 chooseBestVexDodgeOffset(class_1937 world, class_1657 player, class_243 vexPos, class_243 vexMovementDirection, class_243 motionXZ) {
        double MOTION_WEIGHT = 0.2;
        class_243 playerPos = Compat.pos((class_1297)player);
        double bestScoreSame = -1.7976931348623157E308;
        class_243 bestOffsetSame = null;
        double[] radii = new double[]{1.0, 0.9, 0.8};
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 right = up.method_1036(vexMovementDirection).method_1029();
        class_243 forward = vexMovementDirection.method_1036(right).method_1029();
        int samples = 16;
        for (double r : radii) {
            for (int i = 0; i < samples; ++i) {
                double score;
                double currentDistFromVex;
                double dz;
                double dx;
                double distanceFromVex;
                class_243 candidate;
                double theta = Math.PI * 2 * (double)i / (double)samples;
                class_243 dir = forward.method_1021(Math.cos(theta)).method_1019(right.method_1021(Math.sin(theta)));
                if (dir.method_1027() < 1.0E-6 || !VexDodger.isSafeTarget(world, player, candidate = playerPos.method_1019((dir = dir.method_1029()).method_1021(r))) || (distanceFromVex = Math.sqrt((dx = candidate.field_1352 - vexPos.field_1352) * dx + (dz = candidate.field_1350 - vexPos.field_1350) * dz)) <= (currentDistFromVex = Math.sqrt((playerPos.field_1352 - vexPos.field_1352) * (playerPos.field_1352 - vexPos.field_1352) + (playerPos.field_1350 - vexPos.field_1350) * (playerPos.field_1350 - vexPos.field_1350)))) continue;
                double motionBonus = 0.0;
                if (motionXZ.method_1027() > 0.0025000000000000005) {
                    class_243 m = motionXZ.method_1029();
                    motionBonus = 0.2 * m.method_1026(dir);
                }
                if (!((score = distanceFromVex + motionBonus) > bestScoreSame)) continue;
                bestScoreSame = score;
                bestOffsetSame = new class_243(dir.field_1352 * r, 0.0, dir.field_1350 * r);
            }
            if (bestOffsetSame != null) break;
        }
        if (bestOffsetSame != null) {
            return bestOffsetSame;
        }
        double bestScoreUp = -1.7976931348623157E308;
        class_243 bestOffsetUp = null;
        for (double r : radii) {
            for (int i = 0; i < samples; ++i) {
                double score;
                double currentDistFromVex;
                double dz;
                double dx;
                double distanceFromVex;
                class_243 candidate;
                double theta = Math.PI * 2 * (double)i / (double)samples;
                class_243 dir = forward.method_1021(Math.cos(theta)).method_1019(right.method_1021(Math.sin(theta)));
                if (dir.method_1027() < 1.0E-6 || !VexDodger.isSafeTarget(world, player, candidate = playerPos.method_1019((dir = dir.method_1029()).method_1021(r)).method_1031(0.0, 1.0, 0.0)) || (distanceFromVex = Math.sqrt((dx = candidate.field_1352 - vexPos.field_1352) * dx + (dz = candidate.field_1350 - vexPos.field_1350) * dz)) <= (currentDistFromVex = Math.sqrt((playerPos.field_1352 - vexPos.field_1352) * (playerPos.field_1352 - vexPos.field_1352) + (playerPos.field_1350 - vexPos.field_1350) * (playerPos.field_1350 - vexPos.field_1350)))) continue;
                double motionBonus = 0.0;
                if (motionXZ.method_1027() > 0.0025000000000000005) {
                    class_243 m = motionXZ.method_1029();
                    motionBonus = 0.2 * m.method_1026(dir);
                }
                if (!((score = distanceFromVex + motionBonus) > bestScoreUp)) continue;
                bestScoreUp = score;
                bestOffsetUp = new class_243(dir.field_1352 * r, 1.0, dir.field_1350 * r);
            }
            if (bestOffsetUp != null) break;
        }
        return bestOffsetUp;
    }

    private static boolean isSafeTarget(class_1937 world, class_1657 player, class_243 target) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!VexDodger.isPathClear(world, player, playerBox, delta)) {
            return false;
        }
        return VexDodger.isFootprintSafe(world, shifted);
    }

    private static boolean isPathClear(class_1937 world, class_1657 player, class_238 startBox, class_243 delta) {
        double STEP = 0.2;
        double len = delta.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(len / 0.2));
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_238 box = startBox;
        for (int i = 1; i <= steps; ++i) {
            if (world.method_8587((class_1297)player, box = box.method_997(step))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFootprintSafe(class_1937 world, class_238 shifted) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static void clampActiveDodge(class_1657 player) {
        if (activeSession == null) {
            return;
        }
        class_243 axis = VexDodger.activeSession.axis;
        double traveled = Compat.pos((class_1297)player).method_1020(VexDodger.activeSession.startPos).method_1026(axis);
        if (traveled >= VexDodger.activeSession.maxDistance) {
            class_243 v = player.method_18798();
            double comp = v.method_1026(axis);
            class_243 vClamped = v.method_1020(axis.method_1021(comp));
            player.method_18800(vClamped.field_1352, vClamped.field_1351, vClamped.field_1350);
            activeSession = null;
            return;
        }
        class_243 v = player.method_18798();
        double comp = v.method_1026(axis);
        if (Math.abs(comp) > VexDodger.activeSession.maxSpeed) {
            double compNew = class_3532.method_15350((double)comp, (double)(-VexDodger.activeSession.maxSpeed), (double)VexDodger.activeSession.maxSpeed);
            class_243 vNew = v.method_1019(axis.method_1021(compNew - comp));
            player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class DodgeSession {
        final class_243 startPos;
        final class_243 axis;
        final double maxDistance;
        final double maxSpeed;

        DodgeSession(class_243 startPos, class_243 axis, double maxDistance, double maxSpeed) {
            this.startPos = startPos;
            this.axis = axis;
            this.maxDistance = maxDistance;
            this.maxSpeed = maxSpeed;
        }
    }
}

