/*
 * Decompiled with CFR 0.152.
 */
package com.dodger;

import com.dodger.Compat;
import com.dodger.DodgerClient;
import com.dodger.EmergencyResult;
import com.dodger.PotionImpact;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class WitchDodger {
    private static final double STEP_DISTANCE = 1.0;
    private static final double STEP_IMPULSE = 0.55;
    private static final double STEP_MAX_SPEED = 0.75;
    private static final double MIN_MOTION = 0.05;
    private static WitchSession session;
    private static int consecutiveFailedMoves;
    private static final int MAX_CONSECUTIVE_FAILURES = 3;
    private static boolean emergencyMode;

    public static void clear() {
        session = null;
        consecutiveFailedMoves = 0;
        emergencyMode = false;
    }

    public static void tick(class_310 client, List<PotionImpact> impacts) {
        class_243 candidate;
        class_243 chosenAxis;
        class_243 right;
        class_243 left;
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        if (impacts == null || impacts.isEmpty()) {
            session = null;
            return;
        }
        PotionImpact target = null;
        double bestKey = Double.MAX_VALUE;
        for (PotionImpact pi : impacts) {
            double d = pi.etaMs != null ? pi.etaMs.doubleValue() : pi.impactPoint.method_1025(Compat.pos((class_1297)player));
            double key = d;
            if (!(key < bestKey)) continue;
            bestKey = key;
            target = pi;
        }
        if (target == null) {
            session = null;
            return;
        }
        class_243 pPos = Compat.pos((class_1297)player);
        class_243 center = target.impactPoint;
        double dx = pPos.field_1352 - center.field_1352;
        double dz = pPos.field_1350 - center.field_1350;
        double dist = Math.sqrt(dx * dx + dz * dz);
        if (dist >= 4.01) {
            session = null;
            return;
        }
        class_243 traj = WitchDodger.getPotionDirectionXZ(target);
        class_243 v = player.method_18798();
        class_243 vXZ = new class_243(v.field_1352, 0.0, v.field_1350);
        double motionWeight = 0.2;
        if (traj != null && traj.method_1027() > 1.0E-6) {
            class_243[] candidates;
            class_243 up = new class_243(0.0, 1.0, 0.0);
            left = up.method_1036(traj).method_1029();
            right = traj.method_1036(up).method_1029();
            chosenAxis = null;
            double bestScore = -1.7976931348623157E308;
            for (class_243 axis : candidates = new class_243[]{left, right}) {
                double score;
                class_243 candPos = pPos.method_1019(axis.method_1021(1.0));
                if (!WitchDodger.isSafeTarget((class_1937)world, (class_1657)player, candPos)) continue;
                double ndx = candPos.field_1352 - center.field_1352;
                double ndz = candPos.field_1350 - center.field_1350;
                double newDist = Math.sqrt(ndx * ndx + ndz * ndz);
                double motionBonus = 0.0;
                if (vXZ.method_1027() > 0.0025000000000000005) {
                    motionBonus = motionWeight * vXZ.method_1029().method_1026(axis);
                }
                if (!((score = newDist - dist + motionBonus) > bestScore)) continue;
                bestScore = score;
                chosenAxis = axis;
            }
        } else {
            chosenAxis = null;
        }
        if (chosenAxis == null) {
            class_243 m;
            class_243 away = new class_243(dx, 0.0, dz);
            away = away.method_1027() < 1.0E-6 ? new class_243(1.0, 0.0, 0.0) : away.method_1029();
            if (vXZ.method_1027() > 0.0025000000000000005 && (m = vXZ.method_1029()).method_1026(away) < -0.3) {
                away = WitchDodger.rotateYaw(away, Math.toRadians(30.0));
            }
            chosenAxis = away;
        }
        if (session == null || WitchDodger.session.axisXZ.method_1026(chosenAxis) < 0.8) {
            session = new WitchSession(chosenAxis, pPos);
        }
        if (!WitchDodger.isSafeTarget((class_1937)world, (class_1657)player, candidate = pPos.method_1019(WitchDodger.session.axisXZ.method_1021(WitchDodger.session.maxStepDistance)))) {
            left = WitchDodger.rotateYaw(WitchDodger.session.axisXZ, Math.toRadians(15.0));
            right = WitchDodger.rotateYaw(WitchDodger.session.axisXZ, -Math.toRadians(15.0));
            class_243 candL = pPos.method_1019(left.method_1021(WitchDodger.session.maxStepDistance));
            class_243 candR = pPos.method_1019(right.method_1021(WitchDodger.session.maxStepDistance));
            boolean okL = WitchDodger.isSafeTarget((class_1937)world, (class_1657)player, candL);
            boolean okR = WitchDodger.isSafeTarget((class_1937)world, (class_1657)player, candR);
            if (okL && (!okR || candL.method_1025(center) > candR.method_1025(center))) {
                session = new WitchSession(left, pPos);
                candidate = candL;
            } else if (okR) {
                session = new WitchSession(right, pPos);
                candidate = candR;
            } else {
                EmergencyResult emergency = WitchDodger.findEmergencyEscape((class_1937)world, (class_1657)player, center, 4.0, pPos);
                if (emergency != null) {
                    session = new WitchSession(emergency.direction, pPos, emergency.stepDistance);
                    chosenAxis = emergency.direction;
                    emergencyMode = true;
                    consecutiveFailedMoves = 0;
                    DodgerClient.LOGGER.debug("Witch: Using emergency escape strategy - {} blocks", (Object)emergency.stepDistance);
                } else {
                    DodgerClient.LOGGER.debug("Witch: Completely stuck, failed moves: {}", (Object)(++consecutiveFailedMoves));
                    return;
                }
            }
        }
        class_243 axis = WitchDodger.session.axisXZ;
        double comp = v.method_1026(axis);
        double compNew = class_3532.method_15350((double)(comp + 0.55), (double)-0.75, (double)0.75);
        class_243 vNew = v.method_1019(axis.method_1021(compNew - comp));
        player.method_18800(vNew.field_1352, vNew.field_1351, vNew.field_1350);
        consecutiveFailedMoves = 0;
        double traveledNow = Compat.pos((class_1297)player).method_1020(WitchDodger.session.startPos).method_1026(axis);
        WitchDodger.session.traveled = Math.max(WitchDodger.session.traveled, traveledNow);
        if (WitchDodger.session.traveled >= WitchDodger.session.maxStepDistance) {
            class_243 v2 = player.method_18798();
            double c = v2.method_1026(axis);
            player.method_18800(v2.field_1352 - axis.field_1352 * c, v2.field_1351, v2.field_1350 - axis.field_1350 * c);
            session = new WitchSession(axis, Compat.pos((class_1297)player), WitchDodger.session.maxStepDistance);
        }
    }

    private static class_243 getPotionDirectionXZ(PotionImpact target) {
        if (target == null || target.trajectoryPoints == null || target.trajectoryPoints.size() < 2) {
            return null;
        }
        int n = target.trajectoryPoints.size();
        class_243 a = target.trajectoryPoints.get(n - 2);
        class_243 b = target.trajectoryPoints.get(n - 1);
        class_243 d = b.method_1020(a);
        class_243 xz = new class_243(d.field_1352, 0.0, d.field_1350);
        if (xz.method_1027() < 1.0E-6) {
            return null;
        }
        return xz.method_1029();
    }

    private static class_243 rotateYaw(class_243 vec, double radians) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return new class_243(vec.field_1352 * cos - vec.field_1350 * sin, 0.0, vec.field_1352 * sin + vec.field_1350 * cos).method_1029();
    }

    private static boolean isSafeTarget(class_1937 world, class_1657 player, class_243 target) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!WitchDodger.isPathClear(world, player, playerBox, delta)) {
            return false;
        }
        return WitchDodger.isFootprintSafe(world, shifted);
    }

    private static boolean isPathClear(class_1937 world, class_1657 player, class_238 startBox, class_243 delta) {
        double STEP = 0.2;
        double len = delta.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        int steps = Math.max(1, (int)Math.ceil(len / 0.2));
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_238 box = startBox;
        for (int i = 1; i <= steps; ++i) {
            if (world.method_8587((class_1297)player, box = box.method_997(step))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFootprintSafe(class_1937 world, class_238 shifted) {
        double EPS = 1.0E-6;
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int minY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        int maxY = class_3532.method_15357((double)(shifted.field_1325 - 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY - 1; y <= maxY + 2; ++y) {
                    pos.method_10103(x, y, z);
                    class_2680 blockState = world.method_8320((class_2338)pos);
                    class_3610 fluid = world.method_8316((class_2338)pos);
                    if (fluid.method_15767(class_3486.field_15518)) {
                        return false;
                    }
                    if (!blockState.method_27852(class_2246.field_10036) && !blockState.method_27852(class_2246.field_22089)) continue;
                    return false;
                }
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, minY - i, z);
                    class_2680 blockState = world.method_8320((class_2338)pos);
                    if (blockState.method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static EmergencyResult findEmergencyEscape(class_1937 world, class_1657 player, class_243 splashCenter, double splashRadius, class_243 playerPos) {
        class_243 testPos;
        class_243 direction;
        int angle;
        class_243 away = playerPos.method_1020(splashCenter).method_1029();
        for (int distance = 2; distance <= 3; ++distance) {
            class_243 testPos2 = playerPos.method_1019(away.method_1021((double)distance));
            if (!WitchDodger.isEmergencySafeTarget(world, player, testPos2, splashCenter, splashRadius)) continue;
            DodgerClient.LOGGER.debug("Witch: Emergency escape - long jump {} blocks", (Object)distance);
            return new EmergencyResult(away, distance);
        }
        for (angle = 0; angle < 360; angle += 45) {
            double radians = Math.toRadians(angle);
            direction = new class_243(Math.cos(radians), 0.0, Math.sin(radians));
            testPos = playerPos.method_1019(direction.method_1021(2.0));
            double currentDist = playerPos.method_1022(splashCenter);
            double newDist = testPos.method_1022(splashCenter);
            if (!(newDist > currentDist) || !WitchDodger.isMinimallySafeTarget(world, player, testPos)) continue;
            DodgerClient.LOGGER.debug("Witch: Emergency escape - moving away from center (still in danger zone)");
            return new EmergencyResult(direction, 2.0);
        }
        for (angle = 0; angle < 360; angle += 30) {
            double radians = Math.toRadians(angle);
            direction = new class_243(Math.cos(radians), 0.0, Math.sin(radians));
            testPos = playerPos.method_1019(direction.method_1021(1.5));
            if (!WitchDodger.isLastResortSafeTarget(world, player, testPos, splashCenter, splashRadius)) continue;
            DodgerClient.LOGGER.debug("Witch: Emergency escape - accepting position with minor hazards");
            return new EmergencyResult(direction, 1.5);
        }
        return null;
    }

    private static boolean isEmergencySafeTarget(class_1937 world, class_1657 player, class_243 target, class_243 splashCenter, double splashRadius) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        if (!WitchDodger.isPathClear(world, player, playerBox, delta)) {
            return false;
        }
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isMinimallySafeTarget(class_1937 world, class_1657 player, class_243 target) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isLastResortSafeTarget(class_1937 world, class_1657 player, class_243 target, class_243 splashCenter, double splashRadius) {
        class_243 delta;
        class_238 playerBox = player.method_5829();
        class_238 shifted = playerBox.method_997(delta = target.method_1020(Compat.pos((class_1297)player)));
        if (!world.method_8587((class_1297)player, shifted)) {
            return false;
        }
        int minX = class_3532.method_15357((double)(shifted.field_1323 + 1.0E-6));
        int maxX = class_3532.method_15357((double)(shifted.field_1320 - 1.0E-6));
        int minZ = class_3532.method_15357((double)(shifted.field_1321 + 1.0E-6));
        int maxZ = class_3532.method_15357((double)(shifted.field_1324 - 1.0E-6));
        int feetY = class_3532.method_15357((double)(shifted.field_1322 + 1.0E-6));
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                boolean groundFound = false;
                for (int i = 0; i <= 4; ++i) {
                    pos.method_10103(x, feetY - i, z);
                    if (world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110()) continue;
                    groundFound = true;
                    break;
                }
                if (groundFound) continue;
                return false;
            }
        }
        double currentDist = Compat.pos((class_1297)player).method_1022(splashCenter);
        double newDist = target.method_1022(splashCenter);
        return newDist > currentDist + 0.5;
    }

    static {
        consecutiveFailedMoves = 0;
        emergencyMode = false;
    }

    @Environment(value=EnvType.CLIENT)
    private static class WitchSession {
        final class_243 axisXZ;
        final class_243 startPos;
        double traveled;
        final double maxStepDistance;

        WitchSession(class_243 axisXZ, class_243 startPos) {
            this(axisXZ, startPos, 1.0);
        }

        WitchSession(class_243 axisXZ, class_243 startPos, double maxStepDistance) {
            this.axisXZ = axisXZ;
            this.startPos = startPos;
            this.maxStepDistance = maxStepDistance;
            this.traveled = 0.0;
        }
    }
}

