/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCurtainBlock<T extends CurtainPart>
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape BRACKET_SHAPE = Block.box((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final Map<Direction, VoxelShape> TOP_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.or((VoxelShape)SHAPE, (VoxelShape)BRACKET_SHAPE));
    public static final Map<Direction, VoxelShape> SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)SHAPE);
    public static final Map<Direction, VoxelShape> BRACKET_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)BRACKET_SHAPE);
    private final DyeColor color;

    public AbstractCurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    public DyeColor getColor() {
        return this.color;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            this.updateOpen(state, level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected abstract void updateOpen(BlockState var1, Level var2, BlockPos var3);

    protected abstract T getPart(BlockState var1);

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        boolean powered = level.hasNeighborSignal(pos);
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() != level.hasNeighborSignal(pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
            if (powered) {
                this.updateOpen(state, level, pos);
            }
        }
    }

    protected BlockPos getTopBlock(LevelAccessor level, BlockPos currentPos) {
        BlockPos.MutableBlockPos pos = currentPos.mutable();
        BlockState state = level.getBlockState(pos.above());
        while (state.is((Block)this) && !this.getPart(state).isBottomOrSingle()) {
            pos.move(Direction.UP);
            state = level.getBlockState(pos.above());
        }
        return pos.immutable();
    }

    protected void openRows(Level level, BlockState state, BlockPos.MutableBlockPos topPos, Direction direction, Direction baseDirection, int length) {
        boolean leftDirection = baseDirection.getClockWise() == direction;
        while (true) {
            topPos.move(direction);
            if (!this.isConnected((LevelAccessor)level, state, (BlockPos)topPos, length)) break;
            boolean leftConnected = !leftDirection || this.isConnected((LevelAccessor)level, state, (BlockPos)topPos, baseDirection.getClockWise(), length);
            boolean rightConnected = leftDirection || this.isConnected((LevelAccessor)level, state, (BlockPos)topPos, baseDirection.getCounterClockWise(), length);
            this.openRow(level, (BlockPos)topPos, length, leftConnected, rightConnected);
        }
    }

    protected abstract void openRow(Level var1, BlockPos var2, int var3, boolean var4, boolean var5);

    protected boolean isConnected(LevelAccessor level, BlockState state, BlockPos pos, Direction direction, int length) {
        return this.isConnected(level, state, pos.relative(direction), length);
    }

    private boolean isConnected(LevelAccessor level, BlockState state, BlockPos neighborPos, int length) {
        BlockState neighborState = level.getBlockState(neighborPos);
        if (!this.shouldUpdateTogether(level, state, neighborPos, length)) {
            return false;
        }
        T part = this.getPart(neighborState);
        return part.isTopOrSingle() || this.bothSingle(state, neighborState) || part == OpenCurtainPart.LEFT || part == OpenCurtainPart.RIGHT;
    }

    private boolean shouldUpdateTogether(LevelAccessor level, BlockState state, BlockPos neighborPos, int length) {
        BlockState neighborState = level.getBlockState(neighborPos);
        if (!this.belongTogether(state, neighborState)) {
            return false;
        }
        if (this.isOpen() && (this.getPart(state).isSingleRow() || this.getPart(neighborState).isSingleRow())) {
            return false;
        }
        return this.getCurtainLength(level, neighborPos) == length;
    }

    protected abstract boolean isOpen();

    private boolean belongTogether(BlockState state, BlockState neighborState) {
        return neighborState.is((Block)this) && this.hasSameFacing(state, neighborState);
    }

    private boolean bothSingle(BlockState state, BlockState neighborState) {
        return this.getPart(state).isSingle() && this.getPart(neighborState).isSingle();
    }

    private boolean hasSameFacing(BlockState state, BlockState neighborState) {
        return state.getValue(FACING) == neighborState.getValue(FACING);
    }

    protected int getCurtainLength(LevelAccessor level, BlockPos topPos) {
        BlockPos.MutableBlockPos pos = topPos.mutable().move(Direction.DOWN);
        BlockState state = level.getBlockState((BlockPos)pos);
        int length = 1;
        while (state.is((Block)this) && !this.getPart(state).isTopOrSingle()) {
            state = level.getBlockState((BlockPos)pos.move(Direction.DOWN));
            ++length;
        }
        return length;
    }

    protected abstract T connect(BlockState var1, BlockState var2, Direction var3);

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }
}

