/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.entity.DeskDrawerBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeskDrawerBlock
extends DeskBlock
implements EntityBlock {
    private static final VoxelShape DRAWER_SHAPE = Block.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    private static final Map<Direction, VoxelShape> LEFT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.box((double)0.0, (double)4.0, (double)1.0, (double)1.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> RIGHT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.box((double)15.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private final Function<BlockState, VoxelShape> shapesCache = this.getShapeForEachState(this::calculateShape);

    public DeskDrawerBlock(WoodType woodType, TagKey<Block> tag, BlockBehaviour.Properties properties) {
        super(woodType, tag, properties);
    }

    private VoxelShape calculateShape(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean left = (Boolean)state.getValue((Property)LEFT);
        boolean right = (Boolean)state.getValue((Property)RIGHT);
        VoxelShape shape = Shapes.or((VoxelShape)SHAPE, (VoxelShape)DRAWER_SHAPE);
        if (left && right) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{LEFT_CONNECT_SHAPES.get(facing.getOpposite()), RIGHT_CONNECT_SHAPES.get(facing.getOpposite())});
        } else if (left) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)LEFT_CONNECT_SHAPES.get(facing.getOpposite()));
        } else if (right) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)RIGHT_CONNECT_SHAPES.get(facing.getOpposite()));
        }
        return shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new DeskDrawerBlockEntity(pos, state);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapesCache.apply(state);
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof DeskDrawerBlockEntity) {
                DeskDrawerBlockEntity blockEntity2 = (DeskDrawerBlockEntity)blockEntity;
                player.openMenu((MenuProvider)blockEntity2);
                player.awardStat(Stats.OPEN_BARREL);
                PiglinAi.angerNearbyPiglins((ServerLevel)serverLevel, (Player)player, (boolean)true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)level, (BlockPos)pos);
    }
}

