/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_furniture.common.block.AbstractCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ClosedCurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;
import org.jetbrains.annotations.NotNull;

public class OpenCurtainBlock
extends AbstractCurtainBlock<OpenCurtainPart> {
    public static EnumProperty<OpenCurtainPart> PART = ModBlockStateProperties.OPEN_CURTAIN_PART;

    public OpenCurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)((Object)OpenCurtainPart.SINGLE))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        OpenCurtainPart part = (OpenCurtainPart)((Object)state.getValue(PART));
        if (part == OpenCurtainPart.MIDDLE) {
            return Shapes.empty();
        }
        if (part == OpenCurtainPart.TOP) {
            return (VoxelShape)BRACKET_SHAPES.get(facing);
        }
        return part.isTopOrSingle() ? (VoxelShape)TOP_SHAPES.get(facing) : (VoxelShape)SHAPES.get(facing);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((OpenCurtainPart)((Object)state.getValue(PART))).isTopOrSingle() ? (VoxelShape)BRACKET_SHAPES.get(state.getValue((Property)FACING)) : Shapes.empty();
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return state.getValue(PART) == OpenCurtainPart.MIDDLE ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    @NotNull
    protected ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean includeData) {
        return new ItemStack((ItemLike)this.getClosedBlock());
    }

    @Override
    protected void updateOpen(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        Direction base = (Direction)state.getValue((Property)FACING);
        Direction left = base.getClockWise();
        Direction right = base.getCounterClockWise();
        BlockPos topPos = this.getTopBlock((LevelAccessor)level, pos);
        int length = this.getCurtainLength((LevelAccessor)level, topPos);
        boolean leftConnected = this.isConnected((LevelAccessor)level, state, topPos, left, length);
        boolean rightConnected = this.isConnected((LevelAccessor)level, state, topPos, right, length);
        this.openRow(level, topPos, length, leftConnected, rightConnected);
        if (leftConnected) {
            this.openRows(level, state, topPos.mutable(), left, base, length);
        }
        if (rightConnected) {
            this.openRows(level, state, topPos.mutable(), right, base, length);
        }
    }

    @Override
    protected OpenCurtainPart getPart(BlockState state) {
        return (OpenCurtainPart)((Object)state.getValue(PART));
    }

    @Override
    protected void openRow(Level level, BlockPos topPos, int length, boolean leftConnected, boolean rightConnected) {
        ClosedCurtainBlock block = this.getClosedBlock();
        for (int i = 0; i < length; ++i) {
            BlockState state = level.getBlockState(topPos.below(i));
            OpenCurtainPart part = (OpenCurtainPart)((Object)state.getValue(PART));
            ClosedCurtainPart newPart = ClosedCurtainPart.SINGLE;
            if (length != 1) {
                if (part.isTopOrSingle()) {
                    newPart = ClosedCurtainPart.TOP;
                } else if (part.isMiddle()) {
                    newPart = i + 1 >= length ? ClosedCurtainPart.BOTTOM : ClosedCurtainPart.MIDDLE;
                } else if (part.isBottomOrSingle()) {
                    newPart = ClosedCurtainPart.BOTTOM;
                }
            }
            level.setBlockAndUpdate(topPos.below(i), (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue(ClosedCurtainBlock.PART, (Comparable)((Object)newPart))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED))));
        }
    }

    @Override
    protected boolean isOpen() {
        return true;
    }

    @Override
    protected OpenCurtainPart connect(BlockState aState, BlockState bState, Direction facing) {
        return OpenCurtainPart.getTypeForConnections(aState.getBlock() instanceof OpenCurtainBlock && aState.getValue((Property)FACING) == facing, bState.getBlock() instanceof OpenCurtainBlock && bState.getValue((Property)FACING) == facing);
    }

    public ClosedCurtainBlock getClosedBlock() {
        return (ClosedCurtainBlock)((Object)((BlockRegistryEntry)ModBlocks.CLOSED_CURTAINS.get((Object)this.getColor())).get());
    }

    private void updateAboveAndBelow(Level level, BlockState state, BlockPos above, BlockPos below, Direction facing) {
        BlockState aboveState = level.getBlockState(above);
        BlockState belowState = level.getBlockState(below);
        if (aboveState.is((Block)this)) {
            level.setBlockAndUpdate(above, (BlockState)aboveState.setValue(PART, (Comparable)((Object)this.connect(level.getBlockState(above.above()), state, facing))));
        }
        if (belowState.is((Block)this)) {
            level.setBlockAndUpdate(below, (BlockState)belowState.setValue(PART, (Comparable)((Object)this.connect(state, level.getBlockState(below.below()), facing))));
        }
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        BlockState newState = level.getBlockState(pos);
        if (!(newState.getBlock() instanceof AbstractCurtainBlock) && state.getValue(PART) != OpenCurtainPart.SINGLE) {
            level.setBlockAndUpdate(pos, state);
            this.updateOpen(state, (Level)level, pos);
            level.removeBlock(pos, false);
        }
        if (!(newState.getBlock() instanceof AbstractCurtainBlock)) {
            this.updateAboveAndBelow((Level)level, newState, pos.above(), pos.below(), (Direction)state.getValue((Property)FACING));
        }
        super.affectNeighborsAfterRemoval(state, level, pos, movedByPiston);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, POWERED, FACING});
    }
}

