/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.valhelsia.valhelsia_furniture.common.entity.SeatEntity;

public interface SeatableBlock {
    public SeatEntity.EjectType getEjectType();

    default public double getRidingOffset() {
        return 0.6;
    }

    default public boolean isSeatOccupied(EntityGetter entityGetter, BlockPos pos) {
        return !entityGetter.getEntitiesOfClass(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    default public void sitOnBlock(Level level, BlockPos pos, LivingEntity entity) {
        if (!this.isSeatOccupied((EntityGetter)level, pos)) {
            SeatEntity chair = new SeatEntity(pos, this.getRidingOffset(), level, this.getEjectType());
            level.addFreshEntity((Entity)chair);
            entity.startRiding((Entity)chair);
            level.updateNeighbourForOutputSignal(pos, level.getBlockState(pos).getBlock());
        }
    }

    default public void trySitEntityOnBlock(Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player || level.hasNeighborSignal(pos)) {
                return;
            }
            this.sitOnBlock(level, pos, livingEntity);
        }
    }
}

