/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.FurnitureBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock,
FurnitureBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    private static final BooleanProperty ROTATED = ModBlockStateProperties.ROTATED;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumMap<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (EnumMap)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    private static final Map<Direction, VoxelShape> ONE_LEG_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private final WoodType woodType;

    public TableBlock(WoodType woodType, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        ArrayList<Direction> connectedDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() == Direction.Axis.Y || !((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            connectedDirections.add(direction);
        }
        if (connectedDirections.size() >= 3 || connectedDirections.size() == 2 && connectedDirections.getFirst() == ((Direction)connectedDirections.get(1)).getOpposite()) {
            return TOP_SHAPE;
        }
        if (connectedDirections.size() == 1) {
            return TWO_LEGS_SHAPES.get(connectedDirections.getFirst());
        }
        if (connectedDirections.size() == 2) {
            boolean flag = ((Direction)connectedDirections.getFirst()).getClockWise() == connectedDirections.get(1);
            return flag ? ONE_LEG_SHAPES.get(connectedDirections.getFirst()) : ONE_LEG_SHAPES.get(connectedDirections.get(1));
        }
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        boolean waterlogged = level.getFluidState(pos = context.getClickedPos()).getType() == Fluids.WATER;
        boolean rotated = context.getHorizontalDirection().getAxis() == Direction.Axis.X;
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATED, (Comparable)Boolean.valueOf(rotated))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        level.scheduleTick(pos, (Block)this, 1);
        return state;
    }

    private int getTableLength(Level level, BlockPos pos, Direction direction) {
        return this.getTableLengthInDirection(level, pos, direction) + this.getTableLengthInDirection(level, pos, direction.getOpposite());
    }

    private int getTableLengthInDirection(Level level, BlockPos pos, Direction direction) {
        BlockState state;
        int i = 1;
        while ((state = level.getBlockState(pos.relative(direction, i))).getBlock() instanceof TableBlock && ((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()))).booleanValue()) {
            ++i;
        }
        return i;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        List<Direction> directions = Direction.Plane.HORIZONTAL.stream().filter(direction -> (Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction)) == false).toList();
        for (Direction direction2 : directions) {
            int tableLengthNeighbor;
            int tableLengthCurrent;
            BlockPos offsetPos = pos.relative(direction2);
            BlockState offsetState = level.getBlockState(offsetPos);
            if (!(offsetState.getBlock() instanceof TableBlock) || (tableLengthCurrent = this.getTableLength((Level)level, pos, direction2.getClockWise())) != (tableLengthNeighbor = this.getTableLength((Level)level, offsetPos, direction2.getClockWise()))) continue;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction2), (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(pos, (Block)this, 1);
            break;
        }
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        if (direction.getAxis() == Direction.Axis.Y) {
            return state;
        }
        BooleanProperty property = PROPERTY_BY_DIRECTION.get(direction);
        BooleanProperty oppositeProperty = PROPERTY_BY_DIRECTION.get(direction.getOpposite());
        boolean isAlreadyConnected = (Boolean)state.getValue((Property)property);
        boolean isNeighborTable = neighborState.getBlock() instanceof TableBlock;
        boolean isNeighborConnected = isNeighborTable && (Boolean)neighborState.getValue((Property)oppositeProperty) != false;
        state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(isNeighborConnected));
        if (isAlreadyConnected && isNeighborConnected) {
            state = (BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise()), (Comparable)((Boolean)neighborState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise()))))).setValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise()), (Comparable)((Boolean)neighborState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise()))));
        }
        return state;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.getValue((Property)entry.getValue())).booleanValue()) {
                directions.add(rotation.rotate(entry.getKey()));
            }
            state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (Direction direction : directions) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.getValue((Property)entry.getValue())).booleanValue()) {
                directions.add(mirror.mirror(entry.getKey()));
            }
            state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (Direction direction : directions) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, ROTATED, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public FurnitureBlock.Type getType() {
        return FurnitureBlock.Type.TABLE;
    }
}

